/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.metrics.model;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.PreferenceManager;
import com.sonicsw.ma.gui.runtime.metrics.model.AbstractMetricsModel;
import com.sonicsw.ma.gui.runtime.metrics.model.AggregateValueUpdatedEvent;
import com.sonicsw.ma.gui.runtime.metrics.model.IValueListener;
import com.sonicsw.ma.gui.runtime.metrics.model.InstanceNode;
import com.sonicsw.ma.gui.runtime.metrics.model.InstanceParentNode;
import com.sonicsw.ma.gui.runtime.metrics.model.Node;
import com.sonicsw.ma.gui.runtime.metrics.model.ParentNode;
import com.sonicsw.ma.gui.runtime.util.AbstractNode;
import com.sonicsw.ma.gui.runtime.util.AbstractParentNode;
import com.sonicsw.mf.comm.InvokeTimeoutCommsException;
import com.sonicsw.mf.comm.InvokeTimeoutException;
import com.sonicsw.mf.common.metrics.IAggregateMetric;
import com.sonicsw.mf.common.metrics.IAggregateMetricsData;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mx.util.ICollationKeyProvider;
import com.sonicsw.mx.util.IEmptyArray;
import com.sonicsw.mx.util.Sorter;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.ObjectName;
import javax.swing.tree.TreeNode;

public class AggregateMetricsModel
extends AbstractMetricsModel {
    private boolean m_hasInstanceMetrics = false;
    private Timer m_pollTimer;
    private boolean m_pollLostComms = false;
    private IMetricIdentity[] m_pollParams = new IMetricIdentity[]{null};
    private String m_collectionConfigID = null;

    public AggregateMetricsModel(IRemoteMBeanServer connector, ObjectName componentName, IMetricInfo[] infos, String configID) throws Exception {
        super(connector, componentName, infos);
        this.m_collectionConfigID = configID;
        this.update(infos);
    }

    @Override
    public final void update(IMetricInfo[] info) {
        Sorter.sort((Object[])info, (ICollationKeyProvider)this, (int)info.length);
        Enumeration<TreeNode> en = this.m_treeRootNode.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            AbstractParentNode parent;
            AbstractNode node = (AbstractNode)en.nextElement();
            if (node == this.m_treeRootNode) continue;
            String name = null;
            boolean found = false;
            name = node instanceof Node || node instanceof InstanceParentNode ? ((IMetricInfo)node.getUserObject()).getMetricIdentity().getName() : ((IMetricIdentity)node.getUserObject()).getName();
            found = node instanceof InstanceNode ? this.inInstancesList((InstanceParentNode)node.getParent(), name) : this.inList(info, name);
            if (found) continue;
            if (node instanceof Node || node instanceof InstanceNode) {
                parent = (AbstractParentNode)node.getParent();
                this.removeValueListener(node);
                parent.remove(node);
                super.nodeChanged(parent);
            }
            if (!(node instanceof ParentNode) && !(node instanceof InstanceParentNode) || node.getChildCount() != 0) continue;
            parent = (AbstractParentNode)node.getParent();
            parent.remove(node);
            super.nodeChanged(parent);
        }
        this.constructTree(info);
        this.enableChildren();
    }

    private boolean inInstancesList(InstanceParentNode parent, String name) {
        IMetricIdentity identity = ((IMetricInfo)parent.getUserObject()).getMetricIdentity();
        String[] names = this.getInstanceMetricNames(identity);
        String identityName = identity.getName();
        for (int i = 0; i < names.length; ++i) {
            String instanceName = identityName + "." + names[i];
            if (!instanceName.equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean inList(IMetricInfo[] list, String metricName) {
        boolean found = false;
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].getMetricIdentity().getName().startsWith(metricName)) continue;
            found = true;
            break;
        }
        return found;
    }

    public String getCollectionConfigID() {
        return this.m_collectionConfigID;
    }

    private void constructTree(IMetricInfo[] infos) {
        this.m_hasInstanceMetrics = false;
        for (int i = 0; i < infos.length; ++i) {
            AbstractParentNode parent = this.m_treeRootNode;
            String[] nameTokens = infos[i].getMetricIdentity().getNameComponents();
            StringBuffer prefix = new StringBuffer();
            for (int j = 0; j < nameTokens.length; ++j) {
                if (j == nameTokens.length - 1) {
                    boolean isInstanceMetric = infos[i].isInstanceMetric();
                    if (isInstanceMetric) {
                        this.m_hasInstanceMetrics = true;
                    }
                    if (parent.getChild(nameTokens[j]) == null) {
                        parent.add(isInstanceMetric ? new InstanceParentNode(infos[i], nameTokens[j]) : new Node(infos[i], nameTokens[j]));
                    }
                    if (!isInstanceMetric) continue;
                    InstanceParentNode iParent = (InstanceParentNode)parent.getChild(nameTokens[j]);
                    IMetricIdentity id = ((IMetricInfo)iParent.getUserObject()).getMetricIdentity();
                    String[] names = this.getInstanceMetricNames(id);
                    for (int k = 0; k < names.length; ++k) {
                        if (iParent.getChild(names[k]) != null) continue;
                        IMetricIdentity i_id = MetricsFactory.createMetricIdentity((IMetricIdentity)id, (String)names[k]);
                        iParent.add(new InstanceNode(i_id, names[k]));
                    }
                    continue;
                }
                if (j > 0) {
                    prefix.append('.');
                }
                prefix.append(nameTokens[j]);
                AbstractParentNode childNode = (AbstractParentNode)parent.getChild(nameTokens[j]);
                if (childNode == null) {
                    childNode = new ParentNode(MetricsFactory.createMetricIdentity((String)prefix.toString()), nameTokens[j]);
                    parent.add(childNode);
                }
                parent = childNode;
            }
        }
    }

    private String[] getInstanceMetricNames(IMetricIdentity id) {
        try {
            String[] names = (String[])this.m_connector.invoke(this.m_componentName, "getInstanceMetricNames", new Object[]{this.m_collectionConfigID, id}, new String[]{String.class.getName(), IMetricIdentity.class.getName()});
            return names;
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            return IEmptyArray.EMPTY_STRING_ARRAY;
        }
    }

    private void enableChildren() {
        Enumeration<TreeNode> en = this.m_treeRootNode.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            AbstractNode node = (AbstractNode)en.nextElement();
            if (!(node instanceof Node) && !(node instanceof InstanceNode)) continue;
            node.setEnabled(true);
        }
    }

    @Override
    public void refreshTree() throws Exception {
        Object[] parameters = new Object[]{this.m_collectionConfigID};
        String[] signatures = new String[]{String.class.getName()};
        IMetricInfo[] info = (IMetricInfo[])this.m_connector.invoke(this.m_componentName, "getMonitoredMetricsInfo", parameters, signatures);
        this.update(info);
        super.nodeStructureChanged(this.m_treeRootNode);
    }

    @Override
    public void refreshMetricValues(IMetricIdentity[] id) {
        if (id != null && id.length > 0) {
            if (this.m_pollTimer == null) {
                this.m_pollTimer = new Timer(true);
            }
            this.m_pollTimer.schedule((TimerTask)new AggregateResultUpdater(id), new Date(System.currentTimeMillis()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addValueListener(IMetricIdentity metricId, IValueListener listener) {
        Hashtable hashtable = this.m_valueListeners;
        synchronized (hashtable) {
            HashSet<IValueListener> listeners = (HashSet<IValueListener>)this.m_valueListeners.get(metricId);
            if (listeners == null) {
                listeners = new HashSet<IValueListener>();
                this.m_valueListeners.put(metricId, listeners);
            }
            listeners.add(listener);
            this.updateNode(metricId);
            if (this.m_pollTimer == null) {
                this.m_pollTimer = new Timer(true);
                this.m_pollTimer.schedule((TimerTask)new AggregateResultUpdater(), new Date(System.currentTimeMillis()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeValueListener(IMetricIdentity metricId, IValueListener listener) {
        Hashtable hashtable = this.m_valueListeners;
        synchronized (hashtable) {
            HashSet listeners = (HashSet)this.m_valueListeners.get(metricId);
            if (listeners != null) {
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    this.m_valueListeners.remove(metricId);
                }
                this.updateNode(metricId);
            }
            if (this.m_valueListeners.isEmpty() && this.m_pollTimer != null) {
                this.m_pollTimer.cancel();
                this.m_pollTimer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeValueListener(AbstractNode node) {
        IMetricIdentity id = null;
        id = node instanceof InstanceNode ? (IMetricIdentity)node.getUserObject() : ((IMetricInfo)node.getUserObject()).getMetricIdentity();
        if (!this.hasValueListeners(id)) {
            return;
        }
        Hashtable hashtable = this.m_valueListeners;
        synchronized (hashtable) {
            HashSet listeners = (HashSet)this.m_valueListeners.get(id);
            if (listeners != null) {
                listeners.clear();
                if (listeners.isEmpty()) {
                    this.m_valueListeners.remove(id);
                }
                this.updateNode(id);
            }
            if (this.m_valueListeners.isEmpty() && this.m_pollTimer != null) {
                this.m_pollTimer.cancel();
                this.m_pollTimer = null;
            }
        }
    }

    static /* synthetic */ IMetricIdentity[] access$102(AggregateMetricsModel x0, IMetricIdentity[] x1) {
        x0.m_pollParams = x1;
        return x1;
    }

    private class AggregateResultUpdater
    extends TimerTask {
        private IMetricIdentity[] m_ids;
        private boolean m_oneoff;
        private int m_backPeriod;

        public AggregateResultUpdater() {
            this(null, false);
        }

        public AggregateResultUpdater(IMetricIdentity[] ids) {
            this(ids, true);
        }

        protected AggregateResultUpdater(IMetricIdentity[] ids, boolean oneoff) {
            this.m_ids = ids;
            this.m_oneoff = oneoff;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block15: {
                if (AggregateMetricsModel.this.m_pollTimer == null) {
                    return;
                }
                if (this.m_ids == null) {
                    AggregateMetricsModel.access$102(AggregateMetricsModel.this, AggregateMetricsModel.this.m_valueListeners.keySet().toArray(IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY));
                } else {
                    AggregateMetricsModel.access$102(AggregateMetricsModel.this, this.m_ids);
                }
                try {
                    this.m_backPeriod = 1000 * PreferenceManager.getInstance().getInt("preferences.metrics", "aggrPollFrequencySecs", 60);
                    IAggregateMetricsData metricsData = (IAggregateMetricsData)AggregateMetricsModel.this.m_connector.invoke(AggregateMetricsModel.this.m_componentName, "getAggregateMetricsData", new Object[]{AggregateMetricsModel.this.m_collectionConfigID, AggregateMetricsModel.this.m_pollParams, new Long(System.currentTimeMillis()), new Long(this.m_backPeriod)}, new String[]{String.class.getName(), IMetricIdentity[].class.getName(), Long.class.getName(), Long.class.getName()});
                    if (AggregateMetricsModel.this.m_pollTimer == null) {
                        return;
                    }
                    IAggregateMetric[] metrics = metricsData.getAggregateMetrics();
                    for (int i = 0; i < metrics.length; ++i) {
                        HashSet listeners = null;
                        Hashtable hashtable = AggregateMetricsModel.this.m_valueListeners;
                        synchronized (hashtable) {
                            listeners = (HashSet)AggregateMetricsModel.this.m_valueListeners.get(metrics[i].getMetricIdentity());
                        }
                        if (listeners == null) continue;
                        Iterator iterator = listeners.iterator();
                        AggregateValueUpdatedEvent vue = new AggregateValueUpdatedEvent(AggregateMetricsModel.this.m_componentName, metrics[i], AggregateMetricsModel.this.getCollectionConfigID());
                        while (AggregateMetricsModel.this.m_pollTimer != null && iterator.hasNext()) {
                            if (AggregateMetricsModel.this.m_pollTimer == null) {
                                return;
                            }
                            ((IValueListener)iterator.next()).valueUpdated(vue);
                        }
                    }
                    AggregateMetricsModel.this.m_pollLostComms = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (e instanceof InvokeTimeoutCommsException || e instanceof InvokeTimeoutException || AggregateMetricsModel.this.m_pollLostComms) break block15;
                    MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to collect metrics from " + AggregateMetricsModel.this.m_componentName, e, false);
                    AggregateMetricsModel.this.m_pollLostComms = true;
                }
            }
            if (!this.m_oneoff) {
                long nextTime;
                long pollInterval = 1000 * PreferenceManager.getInstance().getInt("preferences.metrics", "aggrPollFrequencySecs", 60);
                for (nextTime = this.scheduledExecutionTime() + pollInterval; nextTime <= System.currentTimeMillis(); nextTime += pollInterval) {
                }
                if (AggregateMetricsModel.this.m_pollTimer == null) {
                    return;
                }
                AggregateMetricsModel.this.m_pollTimer.schedule((TimerTask)new AggregateResultUpdater(), new Date(nextTime));
            }
            this.m_ids = null;
        }
    }
}

