/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.metrics.model;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.PreferenceManager;
import com.sonicsw.ma.gui.runtime.metrics.model.AbstractMetricsModel;
import com.sonicsw.ma.gui.runtime.metrics.model.AlertsModel;
import com.sonicsw.ma.gui.runtime.metrics.model.IAlertsProvider;
import com.sonicsw.ma.gui.runtime.metrics.model.IValueListener;
import com.sonicsw.ma.gui.runtime.metrics.model.InstanceNode;
import com.sonicsw.ma.gui.runtime.metrics.model.InstanceParentNode;
import com.sonicsw.ma.gui.runtime.metrics.model.Node;
import com.sonicsw.ma.gui.runtime.metrics.model.ParentNode;
import com.sonicsw.ma.gui.runtime.metrics.model.ValueUpdatedEvent;
import com.sonicsw.ma.gui.runtime.util.AbstractNode;
import com.sonicsw.ma.gui.runtime.util.AbstractParentNode;
import com.sonicsw.ma.plugin.IMonitorPlugin;
import com.sonicsw.mf.common.metrics.IAlert;
import com.sonicsw.mf.common.metrics.IMetric;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.IMetricsData;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mx.util.ICollationKeyProvider;
import com.sonicsw.mx.util.Sorter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.ObjectName;
import javax.swing.tree.TreeNode;

public class MetricsModel
extends AbstractMetricsModel {
    private static final Long[] EMPTY_LONG_ARRAY = new Long[0];
    public static final int DISABLE_INSTANCE_NONE = 0;
    public static final int DISABLE_INSTANCE_ALL = 1;
    public static final int DISABLE_INSTANCE_WILDCARD = 2;
    private boolean m_hasInstanceMetrics = false;
    private boolean m_hasMetricAlertsSupport = false;
    private Timer m_pollTimer;
    private HashMap m_pollFailures = new HashMap();
    private Object[] m_pollParams = new Object[]{null, Boolean.FALSE};
    private static final String[] POLL_SIGNATURE = new String[]{IMetricIdentity[].class.getName(), Boolean.class.getName()};
    private static final String[] ALERTS_SIGNATURE = new String[]{IAlert[].class.getName()};
    private IMonitorPlugin source = null;

    public MetricsModel(IRemoteMBeanServer connector, ObjectName componentName, IMetricInfo[] infos) throws Exception {
        super(connector, componentName, infos);
        this.update(infos);
    }

    @Override
    public final void update(IMetricInfo[] info) {
        Sorter.sort((Object[])info, (ICollationKeyProvider)this, (int)info.length);
        Enumeration<TreeNode> en = this.m_treeRootNode.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            AbstractNode node = (AbstractNode)en.nextElement();
            if (node == this.m_treeRootNode) continue;
            String name = null;
            name = node instanceof Node || node instanceof InstanceParentNode ? ((IMetricInfo)node.getUserObject()).getMetricIdentity().getName() : ((IMetricIdentity)node.getUserObject()).getName();
            if (this.inList(info, name)) continue;
            try {
                this.disableMetric(node);
            }
            catch (Exception e) {
                e.printStackTrace();
                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            }
        }
        this.constructTree(info);
    }

    private boolean inList(IMetricInfo[] list, String metricName) {
        boolean found = false;
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].getMetricIdentity().getName().startsWith(metricName)) continue;
            found = true;
            break;
        }
        return found;
    }

    public void enableMetric(AbstractNode node) throws Exception {
        HashSet ids = new HashSet();
        this.setIdentities(node, ids, true, 0);
        IMetricIdentity[] metricIds = ids.toArray(new IMetricIdentity[ids.size()]);
        this.m_connector.invoke(this.m_componentName, "enableMetrics", new Object[]{metricIds}, METRIC_IDS_SIGNATURE);
        node.setEnabled(true);
        this.refreshTree();
        node.setParentEnabled();
        for (AbstractNode changeNode = node; changeNode != this.m_treeRootNode; changeNode = (AbstractNode)changeNode.getParent()) {
            super.nodeChanged(changeNode);
        }
        Enumeration<TreeNode> en = node.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            AbstractNode descendant = (AbstractNode)en.nextElement();
            super.nodeChanged(descendant);
        }
        super.nodeChanged(node);
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(IMonitorPlugin source) {
        this.source = source;
    }

    public void enableInstancePatterns(InstanceParentNode node, List instanceNames) throws Exception {
        this.updateInstancePatterns("enableMetrics", node, instanceNames);
        if (instanceNames.contains("*")) {
            this.enableMetric(node);
        } else if (!instanceNames.isEmpty()) {
            node.setParentEnabled();
        }
    }

    public void disableInstancePatterns(InstanceParentNode node, List instanceNames) throws Exception {
        this.updateInstancePatterns("disableMetrics", node, instanceNames);
    }

    private void updateInstancePatterns(String updateOperation, InstanceParentNode node, List instanceNames) throws Exception {
        IMetricIdentity metricId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
        String[] nameComponents = metricId.getNameComponents();
        String[] instanceNameComponents = new String[nameComponents.length + 1];
        System.arraycopy(nameComponents, 0, instanceNameComponents, 0, nameComponents.length);
        int instanceNameComponentIndex = instanceNameComponents.length - 1;
        HashSet<IMetricIdentity> enabledIds = new HashSet<IMetricIdentity>();
        Iterator iterator = instanceNames.iterator();
        while (iterator.hasNext()) {
            instanceNameComponents = (String[])instanceNameComponents.clone();
            instanceNameComponents[instanceNameComponentIndex] = (String)iterator.next();
            enabledIds.add(MetricsFactory.createMetricIdentity((String[])instanceNameComponents));
        }
        IMetricIdentity[] metricIds = enabledIds.toArray(IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY);
        this.m_connector.invoke(this.m_componentName, updateOperation, new Object[]{metricIds}, METRIC_IDS_SIGNATURE);
        this.refreshTree();
        super.nodeStructureChanged(node);
    }

    @Override
    public List getInstances(InstanceParentNode node) throws Exception {
        IMetricIdentity metricId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
        String[] instances = (String[])this.m_connector.invoke(this.m_componentName, "getInstanceMetricNames", new Object[]{metricId}, METRIC_ID_SIGNATURE);
        ArrayList<String> instancesList = new ArrayList<String>(instances.length);
        for (int i = 0; i < instances.length; ++i) {
            instancesList.add(instances[i]);
        }
        return instancesList;
    }

    public String[] getEnabledMetricsPatterns(InstanceParentNode node) throws Exception {
        IMetricIdentity metricId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
        IMetricIdentity[] instancePatterns = (IMetricIdentity[])this.m_connector.invoke(this.m_componentName, "getEnabledMetrics", new Object[]{new IMetricIdentity[]{metricId}}, METRIC_IDS_SIGNATURE);
        String[] patterns = new String[instancePatterns.length];
        for (int i = 0; i < instancePatterns.length; ++i) {
            String[] patternId = instancePatterns[i].getNameComponents();
            patterns[i] = patternId[patternId.length - 1];
        }
        return patterns;
    }

    public void disableMetric(AbstractNode node) throws Exception {
        this.disableMetric(node, 1);
    }

    public void disableMetric(AbstractNode node, int instanceDisableMode) throws Exception {
        HashSet ids = new HashSet();
        this.setIdentities(node, ids, false, instanceDisableMode);
        IMetricIdentity[] metricIds = ids.toArray(new IMetricIdentity[ids.size()]);
        this.m_connector.invoke(this.m_componentName, "disableMetrics", new Object[]{metricIds}, METRIC_IDS_SIGNATURE);
        if (node instanceof InstanceNode) {
            InstanceParentNode parent = (InstanceParentNode)node.getParent();
            parent.remove(node);
            super.nodeStructureChanged(parent);
        } else if (node instanceof InstanceParentNode) {
            node.removeAllChildren();
            this.refreshTree();
            super.nodeStructureChanged(node);
        } else if (node instanceof ParentNode) {
            ArrayList<AbstractNode> instanceParents = new ArrayList<AbstractNode>();
            Enumeration<TreeNode> en = node.depthFirstEnumeration();
            while (en.hasMoreElements()) {
                AbstractNode descendant = (AbstractNode)en.nextElement();
                if (!(descendant instanceof InstanceParentNode)) continue;
                instanceParents.add(descendant);
            }
            for (int i = instanceParents.size() - 1; i >= 0; --i) {
                ((InstanceParentNode)instanceParents.get(i)).removeAllChildren();
                super.nodeStructureChanged((InstanceParentNode)instanceParents.get(i));
            }
            this.refreshTree();
            super.nodeChanged(node);
        }
        node.setEnabled(false);
        this.refreshTree();
        node.setParentEnabled();
        super.nodeChanged(node);
    }

    private void disableAlertsWhenMetricsDisabled(AbstractNode node) throws Exception {
        ArrayList<Long> highThresholdsDelta = null;
        ArrayList<Long> lowThresholdsDelta = null;
        if (node instanceof ParentNode) {
            Enumeration<TreeNode> en = ((ParentNode)node).children();
            while (en.hasMoreElements()) {
                this.disableAlertsWhenMetricsDisabled((AbstractNode)en.nextElement());
            }
        } else {
            int i;
            IMetricInfo metricInfo = (IMetricInfo)node.getUserObject();
            AlertsModel m_alertsModel = ((IAlertsProvider)((Object)node)).getAlertsModel();
            if (m_alertsModel == null) {
                return;
            }
            Long[] existingHighThresholds = m_alertsModel.getHighThresholdValues().toArray(EMPTY_LONG_ARRAY);
            Long[] existingLowThresholds = m_alertsModel.getLowThresholdValues().toArray(EMPTY_LONG_ARRAY);
            highThresholdsDelta = new ArrayList<Long>();
            if (metricInfo.supportsHighThresholdAlerts()) {
                for (i = 0; i < existingHighThresholds.length; ++i) {
                    highThresholdsDelta.add(existingHighThresholds[i]);
                }
            }
            lowThresholdsDelta = new ArrayList<Long>();
            if (metricInfo.supportsLowThresholdAlerts()) {
                for (i = 0; i < existingLowThresholds.length; ++i) {
                    lowThresholdsDelta.add(existingLowThresholds[i]);
                }
            }
            this.disableAlerts(node, highThresholdsDelta.toArray(EMPTY_LONG_ARRAY), lowThresholdsDelta.toArray(EMPTY_LONG_ARRAY));
        }
    }

    private void constructTree(IMetricInfo[] infos) {
        this.m_hasInstanceMetrics = false;
        this.m_hasMetricAlertsSupport = false;
        for (int i = 0; i < infos.length; ++i) {
            AbstractParentNode parent = this.m_treeRootNode;
            String[] nameTokens = infos[i].getMetricIdentity().getNameComponents();
            StringBuffer prefix = new StringBuffer();
            for (int j = 0; j < nameTokens.length; ++j) {
                if (j == nameTokens.length - 1) {
                    boolean isInstanceMetric = infos[i].isInstanceMetric();
                    if (isInstanceMetric) {
                        this.m_hasInstanceMetrics = true;
                    }
                    if (infos[i].supportsHighThresholdAlerts() || infos[i].supportsLowThresholdAlerts()) {
                        this.m_hasMetricAlertsSupport = true;
                    }
                    if (parent.getChild(nameTokens[j]) != null) continue;
                    parent.add(isInstanceMetric ? new InstanceParentNode(infos[i], nameTokens[j]) : new Node(infos[i], nameTokens[j]));
                    continue;
                }
                if (j > 0) {
                    prefix.append('.');
                }
                prefix.append(nameTokens[j]);
                AbstractParentNode childNode = (AbstractParentNode)parent.getChild(nameTokens[j]);
                if (childNode == null) {
                    childNode = new ParentNode(MetricsFactory.createMetricIdentity((String)prefix.toString()), nameTokens[j]);
                    parent.add(childNode);
                }
                parent = childNode;
            }
        }
    }

    @Override
    public void refreshTree() throws Exception {
        IMetricIdentity[] activeMetrics = null;
        IMetricIdentity[] enabledPatterns = null;
        IAlert[] enabledAlerts = null;
        activeMetrics = (IMetricIdentity[])this.m_connector.invoke(this.m_componentName, "getActiveMetrics", SINGLE_NULL_ARG, METRIC_IDS_SIGNATURE);
        enabledPatterns = this.m_hasInstanceMetrics ? (IMetricIdentity[])this.m_connector.invoke(this.m_componentName, "getEnabledMetrics", SINGLE_NULL_ARG, METRIC_IDS_SIGNATURE) : IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY;
        enabledAlerts = this.m_hasMetricAlertsSupport ? (IAlert[])this.m_connector.invoke(this.m_componentName, "getEnabledAlerts", SINGLE_NULL_ARG, METRIC_IDS_SIGNATURE) : new IAlert[]{};
        HashSet<IMetricIdentity> enabledExactPatternsSet = new HashSet<IMetricIdentity>();
        for (int i = 0; i < enabledPatterns.length; ++i) {
            enabledExactPatternsSet.add(enabledPatterns[i]);
        }
        HashSet<IMetricIdentity> activeMetricsSet = new HashSet<IMetricIdentity>(activeMetrics.length);
        for (int i = 0; i < activeMetrics.length; ++i) {
            activeMetricsSet.add(activeMetrics[i]);
        }
        HashMap<IMetricIdentity, HashSet<IAlert>> enabledAlertsSets = new HashMap<IMetricIdentity, HashSet<IAlert>>();
        for (int i = 0; i < enabledAlerts.length; ++i) {
            HashSet<IAlert> alerts = (HashSet<IAlert>)enabledAlertsSets.get(enabledAlerts[i].getMetricIdentity());
            if (alerts == null) {
                alerts = new HashSet<IAlert>();
                enabledAlertsSets.put(enabledAlerts[i].getMetricIdentity(), alerts);
            }
            alerts.add(enabledAlerts[i]);
        }
        this.setLeafNodeStates(this.m_treeRootNode, enabledExactPatternsSet, activeMetricsSet, enabledAlertsSets);
        Enumeration<TreeNode> en = this.m_treeRootNode.depthFirstEnumeration();
        ParentNode lastParentNode = null;
        while (en.hasMoreElements()) {
            ParentNode parent;
            AbstractNode node = (AbstractNode)en.nextElement();
            if (!(node instanceof Node) || (parent = (ParentNode)node.getParent()) == null || parent == lastParentNode) continue;
            lastParentNode = parent;
            node.setParentEnabled();
        }
    }

    private void setIdentities(AbstractNode node, HashSet identities, boolean enable, int instanceDisableMode) {
        if (node instanceof Node) {
            IMetricIdentity metricId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
            identities.add(metricId);
        } else if (node instanceof ParentNode) {
            Enumeration<TreeNode> en = ((ParentNode)node).children();
            while (en.hasMoreElements()) {
                this.setIdentities((AbstractNode)en.nextElement(), identities, enable, instanceDisableMode);
            }
        } else if (node instanceof InstanceParentNode) {
            if (enable) {
                IMetricIdentity parentId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
                IMetricIdentity patternId = MetricsFactory.createMetricIdentity((IMetricIdentity)parentId, (String)"*");
                identities.add(patternId);
            } else {
                switch (instanceDisableMode) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        try {
                            IMetricIdentity metricId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
                            IMetricIdentity[] instancePatterns = (IMetricIdentity[])this.m_connector.invoke(this.m_componentName, "getEnabledMetrics", new Object[]{new IMetricIdentity[]{metricId}}, METRIC_IDS_SIGNATURE);
                            for (int i = 0; i < instancePatterns.length; ++i) {
                                identities.add(instancePatterns[i]);
                            }
                            break;
                        }
                        catch (Exception e) {
                            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                            break;
                        }
                    }
                    default: {
                        IMetricIdentity parentId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
                        IMetricIdentity patternId = MetricsFactory.createMetricIdentity((IMetricIdentity)parentId, (String)"*");
                        identities.add(patternId);
                        break;
                    }
                }
            }
        } else if (node instanceof InstanceNode) {
            InstanceParentNode parent = (InstanceParentNode)node.getParent();
            IMetricIdentity parentId = ((IMetricInfo)parent.getUserObject()).getMetricIdentity();
            IMetricIdentity patternId = MetricsFactory.createMetricIdentity((IMetricIdentity)parentId, (String)node.toString());
            identities.add(patternId);
        }
    }

    public void enableAlerts(AbstractNode node, Long[] highThresholdAlerts, Long[] lowThresholdAlerts) throws Exception {
        int i;
        IMetricIdentity metricId = node instanceof InstanceNode ? (IMetricIdentity)node.getUserObject() : ((IMetricInfo)node.getUserObject()).getMetricIdentity();
        Object[] params = new Object[]{this.createAlertArray(metricId, highThresholdAlerts, lowThresholdAlerts)};
        this.m_connector.invoke(this.m_componentName, "enableAlerts", params, ALERTS_SIGNATURE);
        HashSet alerts = ((IAlertsProvider)((Object)node)).getAlertsModel().getAlerts();
        for (i = 0; i < highThresholdAlerts.length; ++i) {
            alerts.add(MetricsFactory.createAlert((IMetricIdentity)metricId, (boolean)true, (long)highThresholdAlerts[i]));
        }
        for (i = 0; i < lowThresholdAlerts.length; ++i) {
            alerts.add(MetricsFactory.createAlert((IMetricIdentity)metricId, (boolean)false, (long)lowThresholdAlerts[i]));
        }
        super.nodeChanged(node);
    }

    public void disableAlerts(AbstractNode node, Long[] highThresholdAlerts, Long[] lowThresholdAlerts) throws Exception {
        int i;
        IMetricIdentity metricId = node instanceof InstanceNode ? (IMetricIdentity)node.getUserObject() : ((IMetricInfo)node.getUserObject()).getMetricIdentity();
        Object[] params = new Object[]{this.createAlertArray(metricId, highThresholdAlerts, lowThresholdAlerts)};
        this.m_connector.invoke(this.m_componentName, "disableAlerts", params, ALERTS_SIGNATURE);
        HashSet alerts = ((IAlertsProvider)((Object)node)).getAlertsModel().getAlerts();
        for (i = 0; i < highThresholdAlerts.length; ++i) {
            this.removeAlert(alerts, true, highThresholdAlerts[i]);
        }
        for (i = 0; i < lowThresholdAlerts.length; ++i) {
            this.removeAlert(alerts, false, lowThresholdAlerts[i]);
        }
        super.nodeChanged(node);
    }

    private IAlert[] createAlertArray(IMetricIdentity metricId, Long[] highThresholdAlerts, Long[] lowThresholdAlerts) {
        int i;
        int alertCount = (highThresholdAlerts == null ? 0 : highThresholdAlerts.length) + (lowThresholdAlerts == null ? 0 : lowThresholdAlerts.length);
        IAlert[] alerts = new IAlert[alertCount];
        if (lowThresholdAlerts != null) {
            for (i = lowThresholdAlerts.length - 1; i >= 0; --i) {
                alerts[--alertCount] = MetricsFactory.createAlert((IMetricIdentity)metricId, (boolean)false, (long)lowThresholdAlerts[i]);
            }
        }
        if (highThresholdAlerts != null) {
            for (i = highThresholdAlerts.length - 1; i >= 0; --i) {
                alerts[--alertCount] = MetricsFactory.createAlert((IMetricIdentity)metricId, (boolean)true, (long)highThresholdAlerts[i]);
            }
        }
        return alerts;
    }

    private void removeAlert(HashSet alerts, boolean isHighThreshold, long threshold) {
        for (IAlert alert : alerts) {
            if (alert.isHighThreshold() != isHighThreshold || alert.getThresholdValue() != threshold) continue;
            alerts.remove(alert);
            return;
        }
    }

    private void setLeafNodeStates(AbstractNode node, HashSet enabledExactPatterns, HashSet activeMetrics, HashMap enabledAlertsSets) {
        if (node instanceof Node) {
            IMetricIdentity metricId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
            boolean enabled = activeMetrics.remove(metricId);
            ((Node)node).setEnabled(enabled);
            this.addAlerts(node, metricId, enabledAlertsSets);
        } else if (node instanceof ParentNode) {
            Enumeration<TreeNode> en = ((ParentNode)node).children();
            while (en.hasMoreElements()) {
                this.setLeafNodeStates((AbstractNode)en.nextElement(), enabledExactPatterns, activeMetrics, enabledAlertsSets);
            }
        } else if (node instanceof InstanceNode) {
            if (!activeMetrics.remove(node.getUserObject()) && !enabledExactPatterns.remove(node.getUserObject())) {
                node.removeFromParent();
            }
        } else if (node instanceof InstanceParentNode) {
            node.removeAllChildren();
            IMetricIdentity parentId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
            this.addAlerts(node, parentId, enabledAlertsSets);
            HashMap children = new HashMap();
            this.buildInstanceNodes(node, parentId, children, enabledExactPatterns, false);
            this.buildInstanceNodes(node, parentId, children, activeMetrics, true);
            if (!children.isEmpty()) {
                Object[] nodes = Sorter.sort((Object[])children.values().toArray(), (ICollationKeyProvider)this, (int)children.size());
                for (int i = 0; i < nodes.length; ++i) {
                    node.add((InstanceNode)nodes[i]);
                    this.addAlerts((InstanceNode)nodes[i], (IMetricIdentity)((InstanceNode)nodes[i]).getUserObject(), enabledAlertsSets);
                }
            }
            this.nodeStructureChanged(node);
        }
    }

    private void buildInstanceNodes(AbstractNode parentNode, IMetricIdentity parent, HashMap children, Set ids, boolean enabled) {
        IMetricIdentity[] metricsIds = ids.toArray(IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY);
        for (int i = 0; i < metricsIds.length; ++i) {
            if (!metricsIds[i].isInstanceOf(parent)) continue;
            if (this.containsWildcard(metricsIds[i])) {
                parentNode.setEnabled(true);
                parentNode.setParentEnabled();
                continue;
            }
            ids.remove(metricsIds[i]);
            String[] nameComponents = metricsIds[i].getNameComponents();
            InstanceNode newChild = new InstanceNode(metricsIds[i], nameComponents[nameComponents.length - 1]);
            newChild.setEnabled(enabled);
            children.put(metricsIds[i], newChild);
        }
    }

    private boolean containsWildcard(IMetricIdentity metricID) {
        String wildcard = "*";
        String metricName = metricID.getAbsoluteName();
        int index = metricName.indexOf(wildcard);
        if (index == -1) {
            return false;
        }
        String[] nameComponents = metricID.getNameComponents();
        if (!"queue".equals(nameComponents[0])) {
            return true;
        }
        if (metricName.indexOf("%.*%.*") > 0) {
            String modifiedStr = metricName.replaceAll("%\\.\\*%\\.\\*", "_");
            index = modifiedStr.indexOf(wildcard);
        }
        return index != -1;
    }

    private void addAlerts(AbstractNode node, IMetricIdentity metricId, HashMap enabledAlertsSets) {
        HashSet alerts;
        if (node instanceof IAlertsProvider && (alerts = (HashSet)enabledAlertsSets.remove(metricId)) != null) {
            ((IAlertsProvider)((Object)node)).getAlertsModel().setAlerts(alerts);
        }
    }

    @Override
    public void refreshMetricValues(IMetricIdentity[] id) {
        if (id != null && id.length > 0) {
            if (this.m_pollTimer == null) {
                this.m_pollTimer = new Timer(true);
            }
            this.m_pollTimer.schedule((TimerTask)new ValueUpdater(id), new Date(System.currentTimeMillis()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addValueListener(IMetricIdentity metricId, IValueListener listener) {
        Hashtable hashtable = this.m_valueListeners;
        synchronized (hashtable) {
            HashSet<IValueListener> listeners = (HashSet<IValueListener>)this.m_valueListeners.get(metricId);
            if (listeners == null) {
                listeners = new HashSet<IValueListener>();
                this.m_valueListeners.put(metricId, listeners);
            }
            listeners.add(listener);
            this.updateNode(metricId);
            if (this.m_pollTimer == null) {
                this.m_pollTimer = new Timer(true);
                this.m_pollTimer.schedule((TimerTask)new ValueUpdater(), new Date(System.currentTimeMillis()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeValueListener(IMetricIdentity metricId, IValueListener listener) {
        Hashtable hashtable = this.m_valueListeners;
        synchronized (hashtable) {
            HashSet listeners = (HashSet)this.m_valueListeners.get(metricId);
            if (listeners != null) {
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    this.m_valueListeners.remove(metricId);
                }
                this.updateNode(metricId);
            }
            if (this.m_valueListeners.isEmpty() && this.m_pollTimer != null) {
                this.m_pollTimer.cancel();
                this.m_pollTimer = null;
            }
        }
    }

    private class ValueUpdater
    extends TimerTask {
        private IMetricIdentity[] m_id;
        private boolean m_oneoff;

        public ValueUpdater() {
            this(null, false);
        }

        public ValueUpdater(IMetricIdentity[] id) {
            this(id, true);
        }

        protected ValueUpdater(IMetricIdentity[] id, boolean oneoff) {
            this.m_id = id;
            this.m_oneoff = oneoff;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: {
                if (MetricsModel.this.m_pollTimer == null) {
                    return;
                }
                ((MetricsModel)MetricsModel.this).m_pollParams[0] = this.m_id == null ? MetricsModel.this.m_valueListeners.keySet().toArray(IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY) : this.m_id;
                try {
                    IMetricsData metricsData = (IMetricsData)MetricsModel.this.m_connector.invoke(MetricsModel.this.m_componentName, "getMetricsData", MetricsModel.this.m_pollParams, POLL_SIGNATURE);
                    if (MetricsModel.this.m_pollTimer == null) {
                        return;
                    }
                    IMetric[] metrics = metricsData.getMetrics();
                    for (int i = 0; i < metrics.length; ++i) {
                        HashSet listeners = null;
                        Hashtable hashtable = MetricsModel.this.m_valueListeners;
                        synchronized (hashtable) {
                            listeners = (HashSet)MetricsModel.this.m_valueListeners.get(metrics[i].getMetricIdentity());
                        }
                        if (listeners == null) continue;
                        Iterator iterator = listeners.iterator();
                        ValueUpdatedEvent vue = new ValueUpdatedEvent(MetricsModel.this.m_componentName, metrics[i]);
                        while (MetricsModel.this.m_pollTimer != null && iterator.hasNext()) {
                            if (MetricsModel.this.m_pollTimer == null) {
                                return;
                            }
                            ((IValueListener)iterator.next()).valueUpdated(vue);
                        }
                    }
                    MetricsModel.this.m_pollFailures.remove(MetricsModel.this.m_canonicalName);
                }
                catch (Exception e) {
                    Exception lastException = (Exception)MetricsModel.this.m_pollFailures.get(MetricsModel.this.m_canonicalName);
                    if (lastException != null && e.getClass() == lastException.getClass()) break block12;
                    MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to collect metrics from " + MetricsModel.this.m_componentName, e, false);
                    MetricsModel.this.m_pollFailures.put(MetricsModel.this.m_canonicalName, e);
                }
            }
            if (!this.m_oneoff) {
                long nextTime;
                long pollInterval = 1000 * PreferenceManager.getInstance().getInt("preferences.metrics", "pollFrequencySecs", 30);
                for (nextTime = this.scheduledExecutionTime() + pollInterval; nextTime <= System.currentTimeMillis(); nextTime += pollInterval) {
                }
                MetricsModel.this.m_pollTimer.schedule((TimerTask)new ValueUpdater(), new Date(nextTime));
            }
            this.m_id = null;
        }
    }
}

