/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.notifications;

import com.sonicsw.ma.gui.IWorkspaceWindow;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.PreferenceManager;
import com.sonicsw.ma.gui.runtime.notifications.NotificationAttributesSheet;
import com.sonicsw.ma.gui.runtime.notifications.NotificationValue;
import com.sonicsw.ma.gui.runtime.notifications.WatchPropSheet;
import com.sonicsw.ma.gui.runtime.notifications.model.AbstractNotificationsModel;
import com.sonicsw.ma.gui.runtime.notifications.model.ForwardedNotificationsModel;
import com.sonicsw.ma.gui.runtime.notifications.model.INotificationWatcher;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.RowTableColumn;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JBasicMenu;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JMAInternalFrame;
import com.sonicsw.ma.gui.util.JRowTable;
import com.sonicsw.ma.gui.util.PopupMenuShower;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mf.jmx.client.MFNotification;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;

class ForwardedNotificationsWatchWindow
extends JMAInternalFrame
implements INotificationWatcher,
NotificationListener,
IWorkspaceWindow {
    private static final HashMap m_watchWindows = new HashMap();
    private short m_scope = 0;
    private String m_scopeID;
    private JRowTable m_table;
    private HashMap m_subscriptions = new HashMap();
    private HashMap m_modelMap = new HashMap();
    private int m_maxNotifications = 10;
    private static final int PREFERRED_HEIGHT = 300;

    static ForwardedNotificationsWatchWindow getWatchWindow(ObjectName scopeName) {
        String name = null;
        CanonicalName cName = new CanonicalName(scopeName.toString());
        name = cName.getCanonicalName();
        ForwardedNotificationsWatchWindow window = (ForwardedNotificationsWatchWindow)m_watchWindows.get(name);
        if (window == null) {
            window = new ForwardedNotificationsWatchWindow(name);
            m_watchWindows.put(name, window);
        }
        return window;
    }

    private ForwardedNotificationsWatchWindow(String scopeID) {
        super("notifications.watcher");
        this.setProperties(scopeID);
        this.m_scopeID = scopeID;
    }

    private void setProperties(String scopeID) {
        this.setTitle("Forwarded " + this.getTitle() + " - " + scopeID);
        this.setFrameIcon(ResourceManager.getIcon(this.getClass(), "Alert"));
    }

    @Override
    protected void maInitialize() {
        PreferenceManager pManager = PreferenceManager.getInstance();
        this.m_maxNotifications = pManager.getInt("preferences.notifications", "maxNotifications", 200);
        this.initPanels();
    }

    @Override
    protected void maCleanup() {
        for (Map.Entry entry : this.m_subscriptions.entrySet()) {
            String collectionID = (String)entry.getKey();
            ForwardedNotificationsModel model = (ForwardedNotificationsModel)((Object[])this.m_modelMap.get(collectionID))[0];
            HashMap map = (HashMap)entry.getValue();
            Iterator notifications = map.keySet().iterator();
            try {
                while (notifications.hasNext()) {
                    model.removeNotificationListener((String)notifications.next(), this);
                }
                map.clear();
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to remove notification subscriptions", e, true);
            }
        }
        this.m_subscriptions.clear();
        this.m_modelMap.clear();
        m_watchWindows.remove(this.m_scopeID);
        if (this.m_table != null) {
            this.m_table.cleanup();
        }
    }

    @Override
    public boolean canClose() {
        boolean res = true;
        if (this.m_subscriptions != null && !this.m_subscriptions.isEmpty()) {
            res = JOptionPane.showConfirmDialog(this, "Are you sure you want to close watcher:\n" + this.m_scopeID, "Close Notifications Watcher", 0) == 0;
        }
        return res;
    }

    @Override
    public JComponent[] getSelectedMenuItems(int type) {
        JComponent[] menuItems = null;
        if (type == 2) {
            JBasicMenu clearMenu = new JBasicMenu(new ClearAction());
            clearMenu.add(new JBasicMenuItem(new ClearSelectedAction()));
            clearMenu.add(new JBasicMenuItem(new ClearSelectedTypeAction()));
            clearMenu.add(new JBasicMenuItem(new ClearAllAction()));
            menuItems = new JComponent[]{new JBasicMenuItem(new OptionsAction()), new JSeparator(), clearMenu, new JBasicMenuItem(new RemoveWatchAction()), new JSeparator(), new JBasicMenuItem(new PropertiesAction())};
        }
        return menuItems;
    }

    @Override
    public int getMaxNotifications() {
        return this.m_maxNotifications;
    }

    @Override
    public void setMaxNotifications(int maxNotifications) {
        this.m_maxNotifications = maxNotifications;
        this.enforceMaxNotifications(this.m_maxNotifications);
    }

    private void initPanels() {
        super.getContentPane().setLayout(new BorderLayout());
        super.getContentPane().add((Component)this.makeTablePanel(), "Center");
    }

    private JPanel makeTablePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.makeTable(), "Center");
        return panel;
    }

    private JComponent makeTable() {
        TableColumn[] tableColumnAdapters = new TableColumn[]{new SourceColumn(), new HostnameColumn(), new NotificationColumn(), new SeverityColumn(), new LogTypeColumn(), new SequenceColumn(), new TimeColumn()};
        this.m_table = new JRowTable(tableColumnAdapters, this.getClass().getName());
        this.m_table.setSelectionMode(0);
        ExtendedJScrollPane ret = new ExtendedJScrollPane(this.m_table);
        JPopupMenu popup = new JPopupMenu();
        JComponent[] menuItems = this.getSelectedMenuItems(2);
        for (int i = 0; i < menuItems.length; ++i) {
            popup.add(menuItems[i]);
        }
        this.m_table.addMouseListener(new LocalMenuShower(this.m_table, popup));
        return ret;
    }

    @Override
    public synchronized void addWatch(MBeanNotificationInfo info, AbstractNotificationsModel model) {
        this.addWatch(new MBeanNotificationInfo[]{info}, model);
    }

    @Override
    public synchronized void addWatch(MBeanNotificationInfo[] info, AbstractNotificationsModel model) {
        String componentName = model.getComponentName().getCanonicalName();
        String collectionID = ((ForwardedNotificationsModel)model).getCollectionID();
        Object[] modelUsage = (Object[])this.m_modelMap.get(collectionID);
        HashMap<String, MBeanNotificationInfo> subscriptions = (HashMap<String, MBeanNotificationInfo>)this.m_subscriptions.get(collectionID);
        if (subscriptions == null) {
            subscriptions = new HashMap<String, MBeanNotificationInfo>();
            this.m_subscriptions.put(collectionID, subscriptions);
        }
        try {
            for (int i = info.length - 1; i >= 0; --i) {
                String prefix = AbstractNotificationsModel.getTypePrefix(info[i].getNotifTypes());
                if (subscriptions.containsKey(prefix)) continue;
                subscriptions.put(prefix, info[i]);
                if (modelUsage == null) {
                    modelUsage = new Object[]{model, new int[]{0}};
                    this.m_modelMap.put(collectionID, modelUsage);
                }
                int[] nArray = (int[])modelUsage[1];
                nArray[0] = nArray[0] + 1;
                model.addNotificationListener(prefix, this);
            }
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to create notification subscription(s)", e, true);
        }
    }

    private synchronized void removeWatch(NotificationValue notificationValue) {
        Object[] modelUsage;
        Notification notification = notificationValue.getValue();
        String collectionID = notificationValue.getCollectionID();
        boolean alreadyRemoved = false;
        HashMap subscriptions = (HashMap)this.m_subscriptions.get(collectionID);
        if (subscriptions != null) {
            if (subscriptions.remove(notification.getType()) == null) {
                alreadyRemoved = true;
            }
            if (subscriptions.isEmpty()) {
                this.m_subscriptions.remove(collectionID);
            }
        }
        if ((modelUsage = (Object[])this.m_modelMap.get(collectionID)) != null) {
            ForwardedNotificationsModel notificationsModel = (ForwardedNotificationsModel)modelUsage[0];
            if (!alreadyRemoved) {
                int[] nArray = (int[])modelUsage[1];
                nArray[0] = nArray[0] - 1;
                if (((int[])modelUsage[1])[0] == 0) {
                    this.m_modelMap.remove(collectionID);
                }
            }
            try {
                notificationsModel.removeNotificationListener(notification.getType(), this);
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to remove notification subscriptions", e, true);
            }
        }
    }

    private synchronized void clearSelectedNotification(NotificationValue notificationValue) {
        ((IModelTableModel)this.m_table.getModel()).delete(notificationValue);
    }

    private synchronized void clearSelectedTypeNotifications(NotificationValue notificationValue) {
        IModelTableModel tableModel = (IModelTableModel)this.m_table.getModel();
        String notificationType = notificationValue.getValue().getType();
        for (int i = tableModel.getRowCount() - 1; i >= 0; --i) {
            NotificationValue rowValue = (NotificationValue)tableModel.getRowModel(i);
            if (!rowValue.getValue().getType().equals(notificationType)) continue;
            tableModel.deleteRow(i);
        }
    }

    private synchronized void clearAllNotifications() {
        ((IModelTableModel)this.m_table.getModel()).clear();
    }

    @Override
    public short getWatchScope() {
        return this.m_scope;
    }

    @Override
    public synchronized void handleNotification(Notification notification, Object handback) {
        HashMap subscriptions = (HashMap)this.m_subscriptions.get(handback);
        if (subscriptions == null) {
            return;
        }
        if (!subscriptions.containsKey(notification.getType())) {
            return;
        }
        NotificationValue notificationValue = new NotificationValue(notification, (String)handback);
        this.enforceMaxNotifications(this.m_maxNotifications - 1);
        ((IModelTableModel)this.m_table.getModel()).addRow(notificationValue);
    }

    private NotificationValue getSelectedRowValue() {
        int row = this.m_table.getSelectedRow();
        if (row == -1) {
            return null;
        }
        return (NotificationValue)((IModelTableModel)this.m_table.getModel()).getRowModel(row);
    }

    private synchronized void enforceMaxNotifications(int maxNotifications) {
        IModelTableModel tableModel = (IModelTableModel)this.m_table.getModel();
        while (tableModel.getRowCount() > maxNotifications) {
            NotificationValue oldest = null;
            for (NotificationValue current : tableModel.getContents()) {
                if (oldest != null && oldest.getValue().getTimeStamp() <= current.getValue().getTimeStamp()) continue;
                oldest = current;
            }
            tableModel.delete(oldest);
        }
    }

    private void showPropertiesDialog() {
        try {
            JMAFrame parent = (JMAFrame)SwingUtilities.getAncestorOfClass(JMAFrame.class, this);
            NotificationAttributesSheet dialog = new NotificationAttributesSheet(parent, this.getSelectedRowValue().getValue(), this.m_scope, this.m_table);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to show notification properties", e, true);
        }
    }

    private class LocalMenuShower
    extends PopupMenuShower {
        LocalMenuShower(JTable table, JPopupMenu popup) {
            super(table, popup);
        }

        @Override
        protected void showMenuIfPopupTrigger(MouseEvent evt) {
            JPopupMenu popup = this.getPopupMenu();
            if (popup != null && popup.isPopupTrigger(evt)) {
                Component comp = evt.getComponent();
                if (comp instanceof JTable) {
                    int row;
                    JTable table = (JTable)comp;
                    Point pt = new Point(evt.getX(), evt.getY());
                    if (table.getSelectedRowCount() == 0 && (row = table.rowAtPoint(pt)) >= 0) {
                        table.setRowSelectionInterval(row, row);
                    }
                    if (!table.isRowSelected(table.rowAtPoint(pt))) {
                        return;
                    }
                } else if (comp instanceof JViewport) {
                    this.getTable().clearSelection();
                }
                for (int i = 0; i < popup.getComponentCount(); ++i) {
                    Action action;
                    Component item = popup.getComponent(i);
                    if (!(item instanceof AbstractButton) || (action = ((AbstractButton)item).getAction()) == null) continue;
                    item.setEnabled(action.isEnabled());
                }
                if (popup.getComponentCount() > 0) {
                    popup.show(evt.getComponent(), evt.getX(), evt.getY());
                    this.ensurePopupFullyOnScreen(evt);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() == 2 && event.getComponent() instanceof JTable && this.getTable().getSelectedRowCount() == 1) {
                ForwardedNotificationsWatchWindow.this.showPropertiesDialog();
            }
        }
    }

    private class OptionsAction
    extends BasicGuiAction {
        public OptionsAction() {
            super("NotificationsWatchWindow.options");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                WatchPropSheet dialog;
                JMAFrame parent = (JMAFrame)SwingUtilities.getAncestorOfClass(JMAFrame.class, ForwardedNotificationsWatchWindow.this);
                WatchPropSheet watchPropSheet = dialog = new WatchPropSheet(parent);
                watchPropSheet.getClass();
                dialog.editInstance(null, new WatchPropSheet.Model(watchPropSheet, ForwardedNotificationsWatchWindow.this), false);
                dialog.setVisible(true);
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to edit notification watch properties", e, true);
            }
        }
    }

    private class ClearAllAction
    extends BasicGuiAction {
        public ClearAllAction() {
            super("NotificationsWatchWindow.clearAll");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ForwardedNotificationsWatchWindow.this.clearAllNotifications();
        }

        @Override
        public boolean isEnabled() {
            return ForwardedNotificationsWatchWindow.this.m_table.getRowCount() > 0;
        }
    }

    private class ClearSelectedTypeAction
    extends BasicGuiAction {
        public ClearSelectedTypeAction() {
            super("NotificationsWatchWindow.clearSelectedType");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ForwardedNotificationsWatchWindow.this.clearSelectedTypeNotifications(ForwardedNotificationsWatchWindow.this.getSelectedRowValue());
        }

        @Override
        public boolean isEnabled() {
            return ForwardedNotificationsWatchWindow.this.getSelectedRowValue() != null;
        }
    }

    private class ClearSelectedAction
    extends BasicGuiAction {
        public ClearSelectedAction() {
            super("NotificationsWatchWindow.clearSelected");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ForwardedNotificationsWatchWindow.this.clearSelectedNotification(ForwardedNotificationsWatchWindow.this.getSelectedRowValue());
        }

        @Override
        public boolean isEnabled() {
            return ForwardedNotificationsWatchWindow.this.getSelectedRowValue() != null;
        }
    }

    private class RemoveWatchAction
    extends BasicGuiAction {
        public RemoveWatchAction() {
            super("NotificationsWatchWindow.remove");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ForwardedNotificationsWatchWindow.this.removeWatch(ForwardedNotificationsWatchWindow.this.getSelectedRowValue());
        }

        @Override
        public boolean isEnabled() {
            NotificationValue notificationValue = ForwardedNotificationsWatchWindow.this.getSelectedRowValue();
            if (notificationValue != null) {
                Notification notification = notificationValue.getValue();
                String collectionID = notificationValue.getCollectionID();
                HashMap subscriptions = (HashMap)ForwardedNotificationsWatchWindow.this.m_subscriptions.get(collectionID);
                if (subscriptions != null && subscriptions.get(notification.getType()) != null) {
                    return true;
                }
            }
            return false;
        }
    }

    private class ClearAction
    extends BasicGuiAction {
        public ClearAction() {
            super("NotificationsWatchWindow.clear");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
        }

        @Override
        public boolean isEnabled() {
            return ForwardedNotificationsWatchWindow.this.m_table.getRowCount() > 0;
        }
    }

    private class PropertiesAction
    extends BasicGuiAction {
        public PropertiesAction() {
            super("NotificationsWatchWindow.properties");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ForwardedNotificationsWatchWindow.this.showPropertiesDialog();
        }

        @Override
        public boolean isEnabled() {
            NotificationValue notificationValue = ForwardedNotificationsWatchWindow.this.getSelectedRowValue();
            return notificationValue != null && notificationValue.getValue() instanceof MFNotification;
        }
    }

    private static class TimeColumn
    extends RowTableColumn {
        TimeColumn() {
            super(6, "Date & Time", 15);
            this.setCellRenderer();
        }

        private void setCellRenderer() {
            this.setCellRenderer(Helper.getDateTimeTableCellRenderer());
        }

        @Override
        public Object getColumnValue(Object rowModel) {
            return ((NotificationValue)rowModel).getTime();
        }
    }

    private static class SequenceColumn
    extends RowTableColumn {
        SequenceColumn() {
            super(5, "Sequence", 10);
        }

        @Override
        public Object getColumnValue(Object rowModel) {
            return ((NotificationValue)rowModel).getSequence();
        }
    }

    private static class LogTypeColumn
    extends RowTableColumn {
        LogTypeColumn() {
            super(4, "Log Type", 10);
        }

        @Override
        public Object getColumnValue(Object rowModel) {
            return ((NotificationValue)rowModel).getLogType();
        }
    }

    private static class SeverityColumn
    extends RowTableColumn {
        SeverityColumn() {
            super(3, "Severity", 10);
        }

        @Override
        public Object getColumnValue(Object rowModel) {
            return ((NotificationValue)rowModel).getSeverity();
        }
    }

    private static class NotificationColumn
    extends RowTableColumn {
        NotificationColumn() {
            super(2, "Notification", 15);
        }

        @Override
        public Object getColumnValue(Object rowModel) {
            return ((NotificationValue)rowModel).getNotification();
        }
    }

    private static class HostnameColumn
    extends RowTableColumn {
        HostnameColumn() {
            super(1, "Hostname", 15);
        }

        @Override
        public Object getColumnValue(Object rowModel) {
            return ((NotificationValue)rowModel).getHost();
        }
    }

    private static class SourceColumn
    extends RowTableColumn {
        SourceColumn() {
            super(0, "Source", 15);
        }

        @Override
        public Object getColumnValue(Object rowModel) {
            return ((NotificationValue)rowModel).getSource();
        }
    }
}

