/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.notifications;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.WorkspaceWindow;
import com.sonicsw.ma.gui.runtime.JAbstractMonitorPanel;
import com.sonicsw.ma.gui.runtime.JMonitorDialog;
import com.sonicsw.ma.gui.runtime.notifications.ForwardedNotificationsWatchWindow;
import com.sonicsw.ma.gui.runtime.notifications.NotificationsTreeCellRenderer;
import com.sonicsw.ma.gui.runtime.notifications.model.AbstractNotificationsModel;
import com.sonicsw.ma.gui.runtime.notifications.model.ForwardedNotificationsModel;
import com.sonicsw.ma.gui.runtime.notifications.model.ParentNode;
import com.sonicsw.ma.gui.runtime.util.AbstractNode;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JBasicMenu;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.gui.util.PopupMenuShower;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IMonitorPlugin;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class JForwardedNotificationsPanel
extends JAbstractMonitorPanel
implements TreeModelListener {
    public static final String MONITOR_ID_FORWARDED_NOTIFICATIONS = "_ForwardedNotifications";
    private BasicAction m_watchAction = new WatchButtonAction();
    private BasicAction m_refreshAction = new RefreshAction();
    private JTree m_tree = new JTree(null){

        @Override
        public String getToolTipText(MouseEvent event) {
            TreePath path = this.getPathForLocation(event.getX(), event.getY());
            if (path == null) {
                return null;
            }
            return ((AbstractNode)path.getLastPathComponent()).getDescription();
        }
    };

    public JForwardedNotificationsPanel() {
        this.m_tree.setRootVisible(false);
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setCellRenderer(new NotificationsTreeCellRenderer());
        this.m_tree.setVisibleRowCount(10);
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.addMouseListener(new PopupMenuShower(this.m_tree, this.buildPopupMenu()));
        this.m_tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                JForwardedNotificationsPanel.this.enableButtons();
            }
        });
        this.addProperties();
        this.enableButtons();
        this.expandTree();
    }

    private void addProperties() {
        ExtendedJScrollPane scrollPane = new ExtendedJScrollPane(this.m_tree);
        JToolBar tb = new JToolBar(0);
        tb.setFloatable(false);
        tb.setRollover(true);
        tb.add(new JWatchButton(this.m_watchAction));
        tb.addSeparator();
        tb.add(this.m_refreshAction);
        this.add((Component)tb, "North");
        this.add((Component)scrollPane, "Center");
    }

    @Override
    public Icon getIcon() {
        return ResourceManager.getIcon(this.getClass(), "Alert");
    }

    @Override
    public void maInitialize() {
        ToolTipManager.sharedInstance().registerComponent(this.m_tree);
    }

    @Override
    public void maCleanup() {
        ToolTipManager.sharedInstance().unregisterComponent(this.m_tree);
    }

    @Override
    public String getTabTitle() {
        return "Forwarded Notifications";
    }

    @Override
    public String getMonitorId() {
        return MONITOR_ID_FORWARDED_NOTIFICATIONS;
    }

    protected void refresh() {
        ForwardedNotificationsModel model = (ForwardedNotificationsModel)this.m_tree.getModel();
        try {
            model.refreshTree();
            this.expandTree();
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to refresh", e, true);
            return;
        }
    }

    @Override
    public void changeModel(IMonitorPlugin plugin) {
        ForwardedNotificationsModel newModel = (ForwardedNotificationsModel)plugin.getMonitorModel(MONITOR_ID_FORWARDED_NOTIFICATIONS);
        ForwardedNotificationsModel oldModel = (ForwardedNotificationsModel)this.m_tree.getModel();
        if (oldModel != null) {
            oldModel.removeTreeModelListener(this);
        }
        this.m_tree.setModel(newModel);
        if (newModel != null) {
            newModel.addTreeModelListener(this);
        }
        this.expandTree();
    }

    private void expandTree() {
        for (int row = 0; row < this.m_tree.getRowCount(); ++row) {
            if (!(this.m_tree.getPathForRow(row).getLastPathComponent() instanceof ParentNode)) continue;
            this.m_tree.expandRow(row);
        }
    }

    final JPopupMenu buildPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JBasicMenu watchMenu = new JBasicMenu(this.m_watchAction);
        watchMenu.add(new JBasicMenuItem(new WatchAction("NotificationsSheet.watch.domain", 0)));
        menu.add(watchMenu);
        return menu;
    }

    private void enableButtons() {
        TreePath path = this.m_tree.getSelectionPath();
        this.m_watchAction.setEnabled(path != null);
        this.m_refreshAction.setEnabled(true);
    }

    private AbstractNode getCurrentNode() {
        TreePath path = this.m_tree.getSelectionPath();
        return (AbstractNode)path.getLastPathComponent();
    }

    private void setCurrentNode(AbstractNode node) {
        ArrayList<AbstractNode> path = new ArrayList<AbstractNode>();
        while (node != null) {
            path.add(0, node);
            node = (AbstractNode)node.getParent();
        }
        this.m_tree.setSelectionPath(new TreePath(path.toArray()));
        this.enableButtons();
    }

    @Override
    public void treeNodesChanged(TreeModelEvent evt) {
        this.enableButtons();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent evt) {
        this.enableButtons();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent evt) {
        this.enableButtons();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent evt) {
        this.enableButtons();
    }

    private class RefreshAction
    extends BasicGuiAction {
        public RefreshAction() {
            super("NotificationsSheet.refresh");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                JForwardedNotificationsPanel.this.refresh();
            }
            catch (Throwable e) {
                MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to refresh", e, true);
            }
        }
    }

    private class WatchAction
    extends BasicGuiAction {
        private short m_scope;

        public WatchAction(String resource, short scope) {
            super(resource);
            this.m_scope = scope;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JMonitorDialog parent;
            WorkspaceWindow domainParent;
            AbstractNode node = JForwardedNotificationsPanel.this.getCurrentNode();
            ForwardedNotificationsModel model = (ForwardedNotificationsModel)JForwardedNotificationsPanel.this.m_tree.getModel();
            ForwardedNotificationsWatchWindow watcher = ForwardedNotificationsWatchWindow.getWatchWindow(model.getComponentName());
            if (!((JInternalFrame)watcher).isVisible() && (domainParent = (parent = (JMonitorDialog)SwingUtilities.getAncestorOfClass(JMonitorDialog.class, JForwardedNotificationsPanel.this)).getWorkspaceWindow()) != null) {
                domainParent.addDependantFrame(watcher);
                MgmtConsole.getMgmtConsole().showInternalFrame(watcher, true);
            }
            try {
                model.subscribeNotification(node);
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to subscribe to notifications", e, true);
                return;
            }
            watcher.addWatch(model.getChildNotifications(node), (AbstractNotificationsModel)model);
        }
    }

    private class WatchButtonAction
    extends BasicGuiAction {
        public WatchButtonAction() {
            super("NotificationsSheet.watch");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JPopupMenu pm = new JPopupMenu("-");
            pm.add(new JBasicMenuItem(new WatchAction("NotificationsSheet.watch.domain", 0)));
            pm.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent evt) {
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                    JForwardedNotificationsPanel.this.m_watchAction.setSelected(false);
                }
            });
            if (pm.getComponentCount() > 0) {
                JButton src = (JButton)evt.getSource();
                Point pt = Helper.getPopupMenuOrigin(src, pm);
                pm.show(src, pt.x, pt.y);
            }
        }
    }

    class JWatchButton
    extends JButton {
        public JWatchButton(Action action) {
            super(action);
        }

        @Override
        protected void configurePropertiesFromAction(Action a) {
            String[] types = new String[]{"SmallIcon", "ShortDescription", "LongDescription", "enabled"};
            Helper.configurePropertiesFromAction(this, a, types);
        }
    }
}

