/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.notifications;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.runtime.notifications.NotificationValue;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.ModelListTableModel;
import com.sonicsw.ma.gui.table.RowTableColumn;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JButtonPanel;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.JRowTable;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.common.runtime.Level;
import com.sonicsw.mf.jmx.client.MFNotification;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Set;
import javax.management.Notification;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public final class NotificationAttributesSheet
extends JMADialog
implements ListSelectionListener {
    private static final String NA = "n/a";
    private static final String RES_PREVIOUS = "notification.previous";
    private static final String RES_NEXT = "notification.next";
    private Notification m_notification;
    private int m_scope;
    private JRowTable m_parentTable;
    private JTabbedPane m_tab;
    private JRowTable m_attrTable;
    private JTextArea m_attrDetail;
    JTextField m_tfSource = new JTextField();
    JTextField m_tfHost = new JTextField();
    JTextArea m_taNotification = new JTextArea("");
    JTextField m_tfSeverity = new JTextField();
    JTextField m_tfType = new JTextField();
    JTextField m_tfSequence = new JTextField();
    JTextField m_tfDateTime = new JTextField();

    public NotificationAttributesSheet(JMAFrame parent, Notification notification, int scope, JRowTable parentTable) {
        super(parent, "notifications.attributes");
        this.m_notification = notification;
        this.m_scope = scope;
        this.m_parentTable = parentTable;
    }

    @Override
    public void maInitialize() {
        this.m_tab = new JTabbedPane(1);
        this.getContentPane().add(this.m_tab);
        this.m_tab.add((Component)JPartitionPanel.wrap(this.makeGeneralPanel()), "General");
        this.m_tab.add((Component)this.makeAttributesPanel(), "Attributes");
        this.setNotification(this.m_notification);
        this.m_parentTable.getSelectionModel().addListSelectionListener(this);
        this.updatePreviousNextButtons();
    }

    @Override
    public void maCleanup() {
        if (this.m_parentTable != null) {
            this.m_parentTable.getSelectionModel().removeListSelectionListener(this);
            this.m_parentTable.cleanup();
            this.m_parentTable = null;
        }
        this.m_notification = null;
        if (this.m_attrTable != null) {
            this.m_attrTable.cleanup();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        int sel = this.m_parentTable.getSelectedRow();
        NotificationValue value = (NotificationValue)((IModelTableModel)this.m_parentTable.getModel()).getRowModel(sel);
        if (value != null && value.getNotification() != null) {
            this.setNotification(value.getValue());
        }
    }

    protected void updatePreviousNextButtons() {
        this.m_buttonPanel.getAction(RES_PREVIOUS).setEnabled(this.m_parentTable.getSelectedRow() > 0);
        this.m_buttonPanel.getAction(RES_NEXT).setEnabled(this.m_parentTable.getSelectedRow() < this.m_parentTable.getRowCount() - 1);
    }

    @Override
    protected JPanel createButtonPanel(Action[] action) {
        this.m_buttonPanel = new JButtonPanel(false);
        JButton btnPrevious = new JButton(new PreviousAction());
        btnPrevious.setMargin(new Insets(0, 0, 0, 0));
        JButton btnNext = new JButton(new NextAction());
        btnNext.setMargin(new Insets(0, 0, 0, 0));
        this.m_buttonPanel.add(btnPrevious);
        this.m_buttonPanel.add(btnNext);
        this.m_buttonPanel.addRemainder();
        this.m_buttonPanel.add(new JButton(new CloseAction((Action)this.getDefaultCancelAction())));
        return this.m_buttonPanel;
    }

    private JPanel makeGeneralPanel() {
        JPartitionPanel panel = new JPartitionPanel("");
        this.m_tfSource.setEditable(false);
        this.m_tfHost.setEditable(false);
        this.m_taNotification.setEditable(false);
        this.m_taNotification.setLineWrap(true);
        this.m_taNotification.setWrapStyleWord(true);
        this.m_taNotification.setRows(3);
        this.m_taNotification.setBackground(UIManager.getColor("Panel.background"));
        this.m_tfSeverity.setEditable(false);
        this.m_tfType.setEditable(false);
        this.m_tfSequence.setEditable(false);
        this.m_tfDateTime.setEditable(false);
        panel.addRow("Source", (JComponent)this.m_tfSource);
        panel.addRow("Hostname", (JComponent)this.m_tfHost);
        panel.addRow("Notification", (JComponent)new JScrollPane(this.m_taNotification));
        panel.addRow("Severity", (JComponent)this.m_tfSeverity);
        panel.addRow("Log Type", (JComponent)this.m_tfType);
        panel.addRow("Sequence", (JComponent)this.m_tfSequence);
        panel.addRow("Date & Time", (JComponent)this.m_tfDateTime);
        return panel;
    }

    private void setNotification(Notification newNotification) {
        try {
            boolean isMF = newNotification instanceof MFNotification;
            String source = newNotification.getSource().toString();
            String host = isMF ? ((MFNotification)newNotification).getSourceHost() : NA;
            String text = newNotification.getType();
            String severity = this.getSeverity(newNotification);
            String logType = this.getLogType(newNotification);
            String sequence = this.getSequence(newNotification);
            String dateTime = Helper.getDateTimeString(new Long(newNotification.getTimeStamp()));
            this.m_tfSource.setText(source);
            this.m_tfHost.setText(host);
            this.m_taNotification.setText(text);
            this.m_tfSeverity.setText(severity);
            this.m_tfType.setText(logType);
            this.m_tfSequence.setText(sequence);
            this.m_tfDateTime.setText(dateTime);
            this.m_attrDetail.setText("");
            if (newNotification instanceof MFNotification) {
                Set attr = ((MFNotification)newNotification).getAttributes().entrySet();
                ((IModelTableModel)this.m_attrTable.getModel()).setContents(new ArrayList(attr));
            } else {
                ((IModelTableModel)this.m_attrTable.getModel()).clear();
            }
            this.m_attrTable.clearSelection();
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to set notification in dialog view", e, false);
        }
    }

    private JComponent makeAttributesPanel() {
        TableColumn[] tableColumns = new TableColumn[]{new NameColumn(0, "Attribute Name", 30), new ValueColumn(1, "Value", 70)};
        this.m_attrTable = new JRowTable(tableColumns, this.getClass().getName());
        this.m_attrTable.setSelectionMode(0);
        this.m_attrTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (evt.getValueIsAdjusting()) {
                    return;
                }
                int sel = NotificationAttributesSheet.this.m_attrTable.getSelectedRow();
                Map.Entry entry = (Map.Entry)((ModelListTableModel)NotificationAttributesSheet.this.m_attrTable.getModel()).getRowModel(sel);
                if (entry == null) {
                    NotificationAttributesSheet.this.m_attrDetail.setText(" ");
                } else if (entry.getValue() == null) {
                    NotificationAttributesSheet.this.m_attrDetail.setText("<null>");
                } else {
                    boolean isArray = entry.getValue().getClass().isArray();
                    NotificationAttributesSheet.this.m_attrDetail.setLineWrap(!isArray);
                    NotificationAttributesSheet.this.m_attrDetail.setWrapStyleWord(!isArray);
                    NotificationAttributesSheet.this.m_attrDetail.setText(NotificationAttributesSheet.getAttributeValue(entry.getValue(), true));
                }
            }
        });
        this.m_attrDetail = new JTextArea(" ");
        this.m_attrDetail.setEditable(false);
        this.m_attrDetail.setBackground(UIManager.getColor("Panel.background"));
        JPanel preview = new JPanel(new BorderLayout());
        preview.add((Component)new JLabel("Value:"), "North");
        preview.add((Component)new ExtendedJScrollPane(this.m_attrDetail), "Center");
        JSplitPane sp = new JSplitPane(0, new ExtendedJScrollPane(this.m_attrTable), preview);
        sp.setOneTouchExpandable(true);
        sp.setResizeWeight(0.6);
        return sp;
    }

    private static String getAttributeValue(Object object, boolean preview) {
        if (object == null) {
            return "<null>";
        }
        if (object instanceof Date) {
            return Helper.getDateTimeString(new Long(((Date)object).getTime()));
        }
        if (object instanceof GregorianCalendar) {
            GregorianCalendar calendar = (GregorianCalendar)object;
            return Helper.getDateTimeString(calendar.getTimeInMillis()) + " " + calendar.getTimeZone().getDisplayName();
        }
        if (!object.getClass().isArray()) {
            return object.toString();
        }
        StringBuffer buffer = new StringBuffer();
        Object[] array = (Object[])object;
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                if (preview) {
                    buffer.append('\n');
                } else {
                    buffer.append(", ");
                }
            }
            buffer.append('[').append(i).append(']').append(' ').append(array[i].toString());
        }
        return buffer.toString();
    }

    private String getSeverity(Notification notification) {
        if (!(notification instanceof INotification)) {
            return NA;
        }
        return Level.LEVEL_TEXT[((INotification)notification).getSeverity()];
    }

    private String getLogType(Notification notification) {
        if (!(notification instanceof INotification)) {
            return NA;
        }
        return INotification.LOGTYPE_TEXT[((INotification)notification).getLogType()];
    }

    private String getSequence(Notification notification) {
        String res = NA;
        if (notification instanceof INotification) {
            res = Long.toString(((INotification)notification).getSequenceNumber());
        }
        return res;
    }

    private static class ValueColumn
    extends RowTableColumn {
        ValueColumn(int modelIndex, String name, int width) {
            super(modelIndex, name, width);
            this.setSortable(false);
        }

        @Override
        public Object getColumnValue(Object rowModel) {
            Object object = ((Map.Entry)rowModel).getValue();
            return NotificationAttributesSheet.getAttributeValue(object, false);
        }
    }

    private static class NameColumn
    extends RowTableColumn {
        NameColumn(int modelIndex, String name, int width) {
            super(modelIndex, name, width);
        }

        @Override
        public Object getColumnValue(Object rowModel) {
            return ((Map.Entry)rowModel).getKey();
        }
    }

    class NextAction
    extends BasicGuiAction {
        public NextAction() {
            super(NotificationAttributesSheet.RES_NEXT);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int curSel = NotificationAttributesSheet.this.m_parentTable.getSelectedRow();
            NotificationAttributesSheet.this.m_parentTable.setRowSelectionInterval(curSel + 1, curSel + 1);
            NotificationAttributesSheet.this.updatePreviousNextButtons();
        }
    }

    class PreviousAction
    extends BasicGuiAction {
        public PreviousAction() {
            super(NotificationAttributesSheet.RES_PREVIOUS);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int curSel = NotificationAttributesSheet.this.m_parentTable.getSelectedRow();
            NotificationAttributesSheet.this.m_parentTable.setRowSelectionInterval(curSel - 1, curSel - 1);
            NotificationAttributesSheet.this.updatePreviousNextButtons();
        }
    }

    class CloseAction
    extends BasicGuiAction {
        public CloseAction(Action targetAction) {
            super("dialog.close", targetAction);
        }
    }
}

