/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.notifications;

import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.common.runtime.Level;
import javax.management.Notification;

public class NotificationValue {
    private Notification m_value;
    private String m_collectionID;

    public NotificationValue(Notification value) {
        this(value, null);
    }

    public NotificationValue(Notification value, String collectionID) {
        this.m_value = value;
        this.m_collectionID = collectionID;
    }

    public Notification getValue() {
        return this.m_value;
    }

    public String getSource() {
        return this.m_value.getSource().toString();
    }

    public String getHost() {
        if (!(this.m_value instanceof INotification)) {
            return "n/a";
        }
        return ((INotification)this.m_value).getSourceHost();
    }

    public String getNotification() {
        return this.m_value.getType();
    }

    public String getSeverity() {
        if (!(this.m_value instanceof INotification)) {
            return "n/a";
        }
        return Level.LEVEL_TEXT[((INotification)this.m_value).getSeverity()];
    }

    public String getLogType() {
        if (!(this.m_value instanceof INotification)) {
            return "n/a";
        }
        return INotification.LOGTYPE_TEXT[((INotification)this.m_value).getLogType()];
    }

    public Long getSequence() {
        if (!(this.m_value instanceof INotification)) {
            return new Long(0L);
        }
        return new Long(((INotification)this.m_value).getSequenceNumber());
    }

    public Long getTime() {
        return new Long(this.m_value.getTimeStamp());
    }

    public String getCollectionID() {
        return this.m_collectionID;
    }
}

