/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.notifications;

import com.sonicsw.ma.gui.runtime.notifications.model.Node;
import com.sonicsw.ma.gui.runtime.util.AbstractNode;
import com.sonicsw.ma.gui.runtime.util.AbstractParentNode;
import com.sonicsw.ma.gui.util.ExtendedImageIcon;
import com.sonicsw.ma.gui.util.ResourceManager;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public final class NotificationsTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Icon ALERT_ICON = ResourceManager.getIcon(NotificationsTreeCellRenderer.class, "Alert");
    private static final Icon WATCH_ICON = ResourceManager.getIcon(NotificationsTreeCellRenderer.class, "watchoverlay");
    private static final Icon GREENPLUS_ICON = ResourceManager.getIcon(NotificationsTreeCellRenderer.class, "GreenPlus");
    private static final Icon AMBERPLUS_ICON = ResourceManager.getIcon(NotificationsTreeCellRenderer.class, "AmberPlus");

    NotificationsTreeCellRenderer() {
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object node, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component c = super.getTreeCellRendererComponent(tree, node, selected, expanded, leaf, row, hasFocus);
        ExtendedImageIcon iconStack = new ExtendedImageIcon(ALERT_ICON);
        if (node instanceof Node) {
            ((JLabel)c).setIcon(iconStack);
        }
        if (((AbstractNode)node).isEnabled()) {
            if (node instanceof Node) {
                iconStack.addOverlay(WATCH_ICON);
            } else {
                iconStack.addOverlay(GREENPLUS_ICON);
            }
        } else if (node instanceof AbstractParentNode && ((AbstractParentNode)node).isAncestorEnabled()) {
            iconStack.addOverlay(AMBERPLUS_ICON);
        }
        return c;
    }
}

