/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.notifications;

import com.sonicsw.ma.gui.IWorkspaceWindow;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.PreferenceManager;
import com.sonicsw.ma.gui.runtime.notifications.NotificationAttributesSheet;
import com.sonicsw.ma.gui.runtime.notifications.NotificationValue;
import com.sonicsw.ma.gui.runtime.notifications.WatchPropSheet;
import com.sonicsw.ma.gui.runtime.notifications.model.AbstractNotificationsModel;
import com.sonicsw.ma.gui.runtime.notifications.model.INotificationWatcher;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.RowTableColumn;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JBasicMenu;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JMAInternalFrame;
import com.sonicsw.ma.gui.util.JRowTable;
import com.sonicsw.ma.gui.util.PopupMenuShower;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mf.jmx.client.MFNotification;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;

public class NotificationsWatchWindow
extends JMAInternalFrame
implements INotificationWatcher,
NotificationListener,
IWorkspaceWindow {
    private static final Map m_watchWindows = new HashMap();
    private int m_maxNotifications = 10;
    private short m_scope;
    private String m_scopeID;
    private JRowTable m_table;
    private Map m_data = new HashMap();

    static NotificationsWatchWindow getWatchWindow(short scope, ObjectName scopeName) {
        String name = null;
        CanonicalName cName = new CanonicalName(scopeName.toString());
        switch (scope) {
            case 0: {
                name = cName.getDomainName();
                break;
            }
            case 1: {
                name = cName.getDomainName() + "." + cName.getContainerName();
                break;
            }
            default: {
                name = cName.getCanonicalName();
            }
        }
        NotificationsWatchWindow window = (NotificationsWatchWindow)m_watchWindows.get(scope + name);
        if (window == null) {
            window = new NotificationsWatchWindow(scope, name);
            m_watchWindows.put(scope + name, window);
        }
        return window;
    }

    public static void removeAllNotifications(String componentName) {
        for (Map.Entry entry : m_watchWindows.entrySet()) {
            NotificationsWatchWindow window = (NotificationsWatchWindow)entry.getValue();
            window.removeAllWatches(componentName);
        }
    }

    private NotificationsWatchWindow(short scope, String scopeID) {
        super("notifications.watcher");
        this.setProperties(scopeID);
        this.m_scope = scope;
        this.m_scopeID = scopeID;
    }

    private void setProperties(String scopeID) {
        this.setTitle(this.getTitle() + " - " + scopeID);
        this.setFrameIcon(ResourceManager.getIcon(this.getClass(), "Alert"));
    }

    @Override
    protected void maInitialize() {
        PreferenceManager pManager = PreferenceManager.getInstance();
        this.m_maxNotifications = pManager.getInt("preferences.notifications", "maxNotifications", 200);
        this.initPanels();
    }

    @Override
    protected void maCleanup() {
        for (WatchModel dataModel : this.m_data.values()) {
            try {
                dataModel.removeAllSubscriptions(this);
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to remove notification subscriptions", e, true);
            }
        }
        this.m_data.clear();
        m_watchWindows.remove(this.m_scope + this.m_scopeID);
        if (this.m_table != null) {
            this.m_table.cleanup();
        }
    }

    @Override
    public boolean canClose() {
        boolean res = true;
        if (this.m_data != null && !this.m_data.isEmpty()) {
            res = JOptionPane.showConfirmDialog(this, "Are you sure you want to close watcher:\n" + this.m_scopeID, "Close Notifications Watcher", 0) == 0;
        }
        return res;
    }

    @Override
    public JComponent[] getSelectedMenuItems(int type) {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        if (type == 2) {
            JBasicMenu clearMenu = new JBasicMenu(new ClearAction());
            clearMenu.add(new JBasicMenuItem(new ClearSelectedAction()));
            clearMenu.add(new JBasicMenuItem(new ClearSelectedTypeAction()));
            clearMenu.add(new JBasicMenuItem(new ClearAllAction()));
            menuItems.add(new JBasicMenuItem(new OptionsAction()));
            menuItems.add(new JSeparator());
            menuItems.add(clearMenu);
            menuItems.add(new JBasicMenuItem(new RemoveWatchAction()));
            menuItems.add(new JSeparator());
            menuItems.add(new JBasicMenuItem(new PropertiesAction()));
            if (MgmtConsole.DEVELOPER_MODE) {
                menuItems.add(new JBasicMenuItem(new DebugAction()));
            }
        }
        return menuItems.toArray(new JComponent[0]);
    }

    @Override
    public int getMaxNotifications() {
        return this.m_maxNotifications;
    }

    @Override
    public void setMaxNotifications(int maxNotifications) {
        this.m_maxNotifications = maxNotifications;
        this.enforceMaxNotifications(this.m_maxNotifications);
    }

    private void initPanels() {
        super.getContentPane().setLayout(new BorderLayout());
        super.getContentPane().add((Component)this.makeTablePanel(), "Center");
    }

    private JPanel makeTablePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.makeTable(), "Center");
        return panel;
    }

    private JComponent makeTable() {
        TableColumn[] tableColumns = null;
        tableColumns = this.m_scope < 2 ? new TableColumn[]{new SourceColumn(0, "Source", 15), new HostnameColumn(1, "Hostname", 15), new NotificationColumn(2, "Notification", 15), new SeverityColumn(3, "Severity", 15), new LogTypeColumn(4, "Log Type", 15), new SequenceColumn(5, "Sequence", 10), new TimeColumn(6, "Date & Time", 15)} : new TableColumn[]{new NotificationColumn(0, "Notification", 30), new SeverityColumn(1, "Severity", 15), new LogTypeColumn(2, "Log Type", 15), new SequenceColumn(3, "Sequence", 20), new TimeColumn(4, "Date & Time", 20)};
        this.m_table = new JRowTable(tableColumns, this.getClass().getName());
        this.m_table.setSelectionMode(0);
        ExtendedJScrollPane ret = new ExtendedJScrollPane(this.m_table);
        JPopupMenu popup = new JPopupMenu();
        JComponent[] menuItems = this.getSelectedMenuItems(2);
        for (int i = 0; i < menuItems.length; ++i) {
            popup.add(menuItems[i]);
        }
        this.m_table.addMouseListener(new LocalMenuShower(this.m_table, popup));
        return ret;
    }

    @Override
    public synchronized void addWatch(MBeanNotificationInfo info, AbstractNotificationsModel model) {
        this.addWatch(new MBeanNotificationInfo[]{info}, model);
    }

    @Override
    public synchronized void addWatch(MBeanNotificationInfo[] info, AbstractNotificationsModel model) {
        String componentName = model.getComponentName().getCanonicalName();
        WatchModel dataModel = (WatchModel)this.m_data.get(componentName);
        if (dataModel == null) {
            dataModel = new WatchModel(model);
            this.m_data.put(componentName, dataModel);
        }
        try {
            dataModel.addSubscriptions(info, this);
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to create notification subscription(s)", e, true);
        }
    }

    private void debug() {
        for (WatchModel dataModel : this.m_data.values()) {
            System.err.println("Subscription to '" + dataModel.getComponentName() + "'");
            for (String eN : dataModel.getSubscriptions().keySet()) {
                System.err.println("  " + eN);
            }
        }
    }

    private synchronized void removeWatch(NotificationValue notificationValue) {
        Notification notification = notificationValue.getValue();
        String componentName = notification.getSource().toString();
        WatchModel dataModel = (WatchModel)this.m_data.get(componentName);
        if (dataModel != null) {
            try {
                dataModel.removeSubscription(notification.getType(), this);
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to remove notification subscriptions", e, true);
            }
            if (!dataModel.isUsed()) {
                this.m_data.remove(componentName);
            }
        }
    }

    private synchronized void removeAllWatches(String componentName) {
        WatchModel dataModel = (WatchModel)this.m_data.get(componentName);
        try {
            dataModel.removeAllSubscriptions(this);
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to remove all notification subscriptions", e, true);
        }
        this.m_data.remove(componentName);
    }

    private synchronized void clearSelectedNotification(NotificationValue notificationValue) {
        ((IModelTableModel)this.m_table.getModel()).delete(notificationValue);
    }

    private synchronized void clearSelectedTypeNotifications(NotificationValue notificationValue) {
        IModelTableModel tableModel = (IModelTableModel)this.m_table.getModel();
        String notificationType = notificationValue.getValue().getType();
        for (int i = tableModel.getRowCount() - 1; i >= 0; --i) {
            NotificationValue rowValue = (NotificationValue)tableModel.getRowModel(i);
            if (!rowValue.getValue().getType().equals(notificationType)) continue;
            tableModel.deleteRow(i);
        }
    }

    private synchronized void clearAllNotifications() {
        ((IModelTableModel)this.m_table.getModel()).clear();
    }

    @Override
    public short getWatchScope() {
        return this.m_scope;
    }

    @Override
    public synchronized void handleNotification(Notification notification, Object handback) {
        String componentName = notification.getSource().toString();
        String type = notification.getType();
        WatchModel dataModel = (WatchModel)this.m_data.get(componentName);
        if (dataModel == null || !dataModel.getSubscriptions().containsKey(type)) {
            return;
        }
        NotificationValue notificationValue = new NotificationValue(notification);
        this.enforceMaxNotifications(this.m_maxNotifications - 1);
        ((IModelTableModel)this.m_table.getModel()).addRow(notificationValue);
    }

    private NotificationValue getSelectedRowValue() {
        int row = this.m_table.getSelectedRow();
        if (row == -1) {
            return null;
        }
        return (NotificationValue)((IModelTableModel)this.m_table.getModel()).getRowModel(row);
    }

    private synchronized void enforceMaxNotifications(int maxNotifications) {
        IModelTableModel tableModel = (IModelTableModel)this.m_table.getModel();
        while (tableModel.getRowCount() > maxNotifications) {
            NotificationValue oldest = null;
            for (NotificationValue current : tableModel.getContents()) {
                if (oldest != null && oldest.getValue().getTimeStamp() <= current.getValue().getTimeStamp()) continue;
                oldest = current;
            }
            tableModel.delete(oldest);
        }
    }

    private void showPropertiesDialog() {
        try {
            JMAFrame parent = (JMAFrame)SwingUtilities.getAncestorOfClass(JMAFrame.class, this);
            NotificationAttributesSheet dialog = new NotificationAttributesSheet(parent, this.getSelectedRowValue().getValue(), this.m_scope, this.m_table);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to show notification properties", e, true);
        }
    }

    private class LocalMenuShower
    extends PopupMenuShower {
        LocalMenuShower(JTable table, JPopupMenu popup) {
            super(table, popup);
        }

        @Override
        protected void showMenuIfPopupTrigger(MouseEvent evt) {
            JPopupMenu popup = this.getPopupMenu();
            if (popup != null && popup.isPopupTrigger(evt)) {
                for (int i = 0; i < popup.getComponentCount(); ++i) {
                    Action action;
                    Component item = popup.getComponent(i);
                    if (!(item instanceof AbstractButton) || (action = ((AbstractButton)item).getAction()) == null) continue;
                    item.setEnabled(action.isEnabled());
                }
            }
            super.showMenuIfPopupTrigger(evt);
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() == 2 && event.getComponent() instanceof JTable && this.getTable().getSelectedRowCount() == 1) {
                NotificationsWatchWindow.this.showPropertiesDialog();
            }
        }
    }

    private class WatchModel {
        public AbstractNotificationsModel m_model;
        private Map m_subscriptions;

        public WatchModel(AbstractNotificationsModel model) {
            this.m_model = model;
            this.m_subscriptions = null;
        }

        public String getComponentName() {
            return this.m_model.getComponentName().toString();
        }

        public Map getSubscriptions() {
            return this.m_subscriptions != null ? this.m_subscriptions : Collections.EMPTY_MAP;
        }

        public void addSubscriptions(MBeanNotificationInfo[] info, NotificationListener listener) throws Exception {
            if (this.m_subscriptions == null) {
                this.m_subscriptions = new HashMap();
            }
            for (int i = info.length - 1; i >= 0; --i) {
                String type = AbstractNotificationsModel.getTypePrefix(info[i].getNotifTypes());
                if (this.m_subscriptions.containsKey(type)) continue;
                this.m_subscriptions.put(type, info[i]);
                MgmtConsole.displayMessage(2, "Adding Notification '" + type + "' from " + this.m_model.getComponentName().toString(), false);
                this.m_model.addNotificationListener(type, listener);
            }
        }

        public MBeanNotificationInfo removeSubscription(String type, NotificationListener listener) throws Exception {
            MBeanNotificationInfo res = (MBeanNotificationInfo)this.getSubscriptions().remove(type);
            if (this.getSubscriptions().isEmpty()) {
                this.m_subscriptions = null;
            }
            Helper.logDebugMessage("Removing Notification '" + type + "' from " + this.m_model.getComponentName().toString());
            this.m_model.removeNotificationListener(type, listener);
            return res;
        }

        public void removeAllSubscriptions(NotificationListener listener) throws Exception {
            String[] types = this.getSubscriptions().keySet().toArray(new String[0]);
            for (int i = 0; i < types.length; ++i) {
                this.removeSubscription(types[i], listener);
            }
        }

        public boolean isSubscriptionInUse(String type) {
            return this.getSubscriptions().get(type) != null;
        }

        public boolean isUsed() {
            return !this.getSubscriptions().isEmpty();
        }
    }

    private class DebugAction
    extends BasicGuiAction {
        public DebugAction() {
            super("NotificationsWatchWindow.options");
            this.putNameValue();
        }

        private void putNameValue() {
            this.putValue("Name", "Debug");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            NotificationsWatchWindow.this.debug();
        }
    }

    private class OptionsAction
    extends BasicGuiAction {
        public OptionsAction() {
            super("NotificationsWatchWindow.options");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                WatchPropSheet dialog;
                JMAFrame parent = (JMAFrame)SwingUtilities.getAncestorOfClass(JMAFrame.class, NotificationsWatchWindow.this);
                WatchPropSheet watchPropSheet = dialog = new WatchPropSheet(parent);
                watchPropSheet.getClass();
                dialog.editInstance(null, new WatchPropSheet.Model(watchPropSheet, NotificationsWatchWindow.this), false);
                dialog.setVisible(true);
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(3, "Failed to edit notification watch properties", e, true);
            }
        }
    }

    private class ClearAllAction
    extends BasicGuiAction {
        public ClearAllAction() {
            super("NotificationsWatchWindow.clearAll");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            NotificationsWatchWindow.this.clearAllNotifications();
        }

        @Override
        public boolean isEnabled() {
            return NotificationsWatchWindow.this.m_table.getRowCount() > 0;
        }
    }

    private class ClearSelectedTypeAction
    extends BasicGuiAction {
        public ClearSelectedTypeAction() {
            super("NotificationsWatchWindow.clearSelectedType");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            NotificationsWatchWindow.this.clearSelectedTypeNotifications(NotificationsWatchWindow.this.getSelectedRowValue());
        }

        @Override
        public boolean isEnabled() {
            return NotificationsWatchWindow.this.getSelectedRowValue() != null;
        }
    }

    private class ClearSelectedAction
    extends BasicGuiAction {
        public ClearSelectedAction() {
            super("NotificationsWatchWindow.clearSelected");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            NotificationsWatchWindow.this.clearSelectedNotification(NotificationsWatchWindow.this.getSelectedRowValue());
        }

        @Override
        public boolean isEnabled() {
            return NotificationsWatchWindow.this.getSelectedRowValue() != null;
        }
    }

    private class ClearAction
    extends BasicGuiAction {
        public ClearAction() {
            super("NotificationsWatchWindow.clear");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
        }

        @Override
        public boolean isEnabled() {
            return NotificationsWatchWindow.this.m_table.getRowCount() > 0;
        }
    }

    private class RemoveWatchAction
    extends BasicGuiAction {
        public RemoveWatchAction() {
            super("NotificationsWatchWindow.remove");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            NotificationsWatchWindow.this.removeWatch(NotificationsWatchWindow.this.getSelectedRowValue());
        }

        @Override
        public boolean isEnabled() {
            NotificationValue notificationValue = NotificationsWatchWindow.this.getSelectedRowValue();
            if (notificationValue != null) {
                Notification notification = notificationValue.getValue();
                String componentName = notification.getSource().toString();
                WatchModel dataModel = (WatchModel)NotificationsWatchWindow.this.m_data.get(componentName);
                if (dataModel != null && dataModel.isSubscriptionInUse(notification.getType())) {
                    return true;
                }
            }
            return false;
        }
    }

    private class PropertiesAction
    extends BasicGuiAction {
        public PropertiesAction() {
            super("NotificationsWatchWindow.properties");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            NotificationsWatchWindow.this.showPropertiesDialog();
        }

        @Override
        public boolean isEnabled() {
            NotificationValue notificationValue = NotificationsWatchWindow.this.getSelectedRowValue();
            return notificationValue != null && notificationValue.getValue() instanceof MFNotification;
        }
    }

    private static class TimeColumn
    extends RowTableColumn {
        TimeColumn(int modelIndex, String name, int width) {
            super(modelIndex, name, width);
            this.setCellRenderer();
        }

        private void setCellRenderer() {
            this.setCellRenderer(Helper.getDateTimeTableCellRenderer());
        }

        @Override
        public Object getColumnValue(Object rowModel) {
            return ((NotificationValue)rowModel).getTime();
        }
    }

    private static class SequenceColumn
    extends RowTableColumn {
        SequenceColumn(int modelIndex, String name, int width) {
            super(modelIndex, name, width);
            this.setColumnClass(Long.class);
        }

        @Override
        public Object getColumnValue(Object rowModel) {
            return ((NotificationValue)rowModel).getSequence();
        }
    }

    private static class LogTypeColumn
    extends RowTableColumn {
        LogTypeColumn(int modelIndex, String name, int width) {
            super(modelIndex, name, width);
        }

        @Override
        public Object getColumnValue(Object rowModel) {
            return ((NotificationValue)rowModel).getLogType();
        }
    }

    private static class SeverityColumn
    extends RowTableColumn {
        SeverityColumn(int modelIndex, String name, int width) {
            super(modelIndex, name, width);
        }

        @Override
        public Object getColumnValue(Object rowModel) {
            return ((NotificationValue)rowModel).getSeverity();
        }
    }

    private static class NotificationColumn
    extends RowTableColumn {
        NotificationColumn(int modelIndex, String name, int width) {
            super(modelIndex, name, width);
        }

        @Override
        public Object getColumnValue(Object rowModel) {
            return ((NotificationValue)rowModel).getNotification();
        }
    }

    private static class HostnameColumn
    extends RowTableColumn {
        HostnameColumn(int modelIndex, String name, int width) {
            super(modelIndex, name, width);
        }

        @Override
        public Object getColumnValue(Object rowModel) {
            return ((NotificationValue)rowModel).getHost();
        }
    }

    private static class SourceColumn
    extends RowTableColumn {
        SourceColumn(int modelIndex, String name, int width) {
            super(modelIndex, name, width);
        }

        @Override
        public Object getColumnValue(Object rowModel) {
            return ((NotificationValue)rowModel).getSource();
        }
    }
}

