/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.notifications;

import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.runtime.notifications.model.INotificationWatcher;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import modelobjects.framework.EditRule;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.model.ModelObjectAdapter;
import modelobjects.framework.model.ModelObjectPropagator;
import modelobjects.framework.model.ModelObjectValidator;
import modelobjects.framework.model.ModelPropagationException;
import modelobjects.framework.model.ModelValidationException;
import modelobjects.framework.swing.JTextFieldAdapter;

class WatchPropSheet
extends JPropSheetDialog {
    private JTextField m_maxNotificationsField;

    public WatchPropSheet(JMAFrame parent) {
        super(parent, "notifications.watcher", Model.class);
        this.setValidator(new Validator());
        this.setPropagator(new Propagator());
    }

    @Override
    public void initUI() throws Exception {
        this.getContentPane().add(this.createMainPanel());
    }

    @Override
    public void initForm() throws Exception {
        new JTextFieldAdapter(ModelAspectId.forName("maxNotifications"), this.m_maxNotificationsField, EditRule.ALWAYS, null, this.getMediator());
    }

    private JPanel createMainPanel() {
        this.m_maxNotificationsField = new JTextField(5);
        JPartitionPanel panel = new JPartitionPanel(false, "p,r", "Watch Data");
        panel.addRow("Max Notifications", (JComponent)this.m_maxNotificationsField);
        return JPartitionPanel.wrap(panel);
    }

    private static class Propagator
    implements ModelObjectPropagator {
        private Propagator() {
        }

        @Override
        public void propagateModelEdit(ModelObjectAdapter adapter) throws ModelPropagationException {
            Model model = (Model)adapter.getModelObject();
            model.watcher.setMaxNotifications(Integer.parseInt(model.getMaxNotifications()));
        }

        @Override
        public void propagateModelCreation(ModelObjectAdapter modelObjectAdapter) throws ModelPropagationException {
        }

        @Override
        public void propagateModelDeletion(ModelObjectAdapter modelObjectAdapter) throws ModelPropagationException {
        }
    }

    private static class Validator
    implements ModelObjectValidator {
        private Validator() {
        }

        @Override
        public void validateModelEdit(ModelObjectAdapter adapter) throws ModelValidationException {
            Model model = (Model)adapter.getModelObject();
            int maxNotifications = Integer.parseInt(model.getMaxNotifications());
            if (maxNotifications < 1) {
                throw new ModelValidationException("The maximum number of notifications per watch window must be > 0");
            }
            if (maxNotifications > 1000) {
                throw new ModelValidationException("The maximum number of notifications per watch window must be <= 1000");
            }
        }

        @Override
        public void validateModelCreation(ModelObjectAdapter adapter) throws ModelValidationException {
            throw new ModelValidationException("Create invalid");
        }

        @Override
        public void validateModelDeletion(ModelObjectAdapter adapter) throws ModelValidationException {
            throw new ModelValidationException("Delete invalid");
        }
    }

    public class Model {
        private String maxNotifications;
        INotificationWatcher watcher;

        public Model(INotificationWatcher watcher) {
            this.watcher = watcher;
            this.maxNotifications = Integer.toString(watcher.getMaxNotifications());
        }

        public String getMaxNotifications() {
            return this.maxNotifications;
        }

        public void setMaxNotifications(String maxNotifications) {
            this.maxNotifications = maxNotifications;
        }
    }
}

