/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.notifications.model;

import com.sonicsw.ma.gui.runtime.notifications.model.Node;
import com.sonicsw.ma.gui.runtime.notifications.model.ParentNode;
import com.sonicsw.ma.gui.runtime.util.AbstractNode;
import com.sonicsw.ma.gui.runtime.util.AbstractParentNode;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mx.util.ICollationKeyProvider;
import com.sonicsw.mx.util.IEmptyArray;
import com.sonicsw.mx.util.Sorter;
import java.text.CollationKey;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public abstract class AbstractNotificationsModel
extends DefaultTreeModel
implements IEmptyArray,
ICollationKeyProvider {
    public static final boolean DEBUG = false;
    protected IRemoteMBeanServer m_connector;
    protected ObjectName m_componentName;
    protected NotificationFilterSupport m_notificationFilter = new NotificationFilterSupport();
    protected ParentNode m_treeRootNode;
    protected HashSet m_subscriptions = new HashSet();
    protected Hashtable m_notificationListeners = new Hashtable();

    public AbstractNotificationsModel(IRemoteMBeanServer connector, ObjectName componentName, MBeanNotificationInfo[] infos) {
        super(new ParentNode("", ""));
        this.m_connector = connector;
        this.m_componentName = componentName;
        this.m_treeRootNode = this.getTreeRootNode();
        Sorter.sort((Object[])infos, (ICollationKeyProvider)this, (int)infos.length);
    }

    private ParentNode getTreeRootNode() {
        return (ParentNode)super.getRoot();
    }

    public static String getTypePrefix(String[] notificationTypes) {
        StringBuffer sb = new StringBuffer(notificationTypes[0]);
        if (notificationTypes.length > 1) {
            for (int i = 1; i < notificationTypes.length; ++i) {
                sb.append('.').append(notificationTypes[i]);
            }
        }
        return sb.toString();
    }

    public CollationKey getCollationKey(Object object) {
        if (object instanceof MBeanNotificationInfo) {
            return Sorter.COLLATOR.getCollationKey(AbstractNotificationsModel.getTypePrefix(((MBeanNotificationInfo)object).getNotifTypes()));
        }
        throw new IllegalArgumentException("Expected instance of MBeanNotificationInfo");
    }

    public ObjectName getComponentName() {
        return this.m_componentName;
    }

    public abstract void unsubscribeNotification(AbstractNode var1) throws Exception;

    public abstract void subscribeNotification(AbstractNode var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(String prefix, NotificationListener listener) throws Exception {
        Hashtable hashtable = this.m_notificationListeners;
        synchronized (hashtable) {
            HashSet<NotificationListener> listeners = (HashSet<NotificationListener>)this.m_notificationListeners.get(prefix);
            if (listeners == null) {
                listeners = new HashSet<NotificationListener>();
                this.m_notificationListeners.put(prefix, listeners);
                this.setNodeEnabled(prefix, true);
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(String prefix, NotificationListener listener) throws Exception {
        Hashtable hashtable = this.m_notificationListeners;
        synchronized (hashtable) {
            HashSet listeners = (HashSet)this.m_notificationListeners.get(prefix);
            if (listeners != null) {
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    this.m_notificationListeners.remove(prefix);
                    this.setNodeEnabled(prefix, false);
                }
            }
        }
    }

    public MBeanNotificationInfo[] getChildNotifications(AbstractNode node) {
        ArrayList<Object> res = new ArrayList<Object>();
        if (node instanceof Node) {
            res.add(node.getUserObject());
        } else {
            Enumeration<TreeNode> en = ((AbstractParentNode)node).depthFirstEnumeration();
            while (en.hasMoreElements()) {
                node = (AbstractNode)en.nextElement();
                if (!(node instanceof Node)) continue;
                res.add(node.getUserObject());
            }
        }
        return res.toArray(new MBeanNotificationInfo[res.size()]);
    }

    void setNodeEnabled(String prefix, boolean enabled) throws Exception {
        Enumeration<TreeNode> en = this.m_treeRootNode.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            AbstractNode node = (AbstractNode)en.nextElement();
            if (!(node instanceof Node) || !AbstractNotificationsModel.getTypePrefix(((MBeanNotificationInfo)((Node)node).getUserObject()).getNotifTypes()).equals(prefix)) continue;
            node.setEnabled(enabled);
            if (enabled) continue;
            this.unsubscribeNotification(node);
        }
    }

    public AbstractNode findBranchRoot(AbstractNode node) {
        while (node != this.m_treeRootNode) {
            node = (AbstractNode)node.getParent();
        }
        return node;
    }

    void fireNodeChanged(AbstractNode node) {
        if (node == null) {
            return;
        }
        if (node == this.m_treeRootNode) {
            return;
        }
        super.nodeChanged(node);
        this.fireNodeChanged((AbstractNode)node.getParent());
    }
}

