/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.notifications.model;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.runtime.notifications.model.AbstractNotificationsModel;
import com.sonicsw.ma.gui.runtime.notifications.model.Node;
import com.sonicsw.ma.gui.runtime.notifications.model.ParentNode;
import com.sonicsw.ma.gui.runtime.util.AbstractNode;
import com.sonicsw.ma.gui.runtime.util.AbstractParentNode;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mf.jmx.client.MFNotification;
import java.rmi.dgc.VMID;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.swing.tree.TreeNode;

public class ForwardedNotificationsModel
extends AbstractNotificationsModel
implements NotificationListener {
    public static final boolean DEBUG = false;
    private String m_handback = new VMID().toString();
    private String m_collectionName = null;
    private ObjectName m_objComponentName = null;

    public ForwardedNotificationsModel(IRemoteMBeanServer connector, ObjectName componentName, MBeanNotificationInfo[] infos, String collectionName) throws Exception {
        super(connector, componentName, infos);
        this.m_collectionName = collectionName;
        this.m_objComponentName = componentName;
        this.constructTree(infos, false);
    }

    public String getCollectionID() {
        return this.m_collectionName;
    }

    @Override
    public void subscribeNotification(AbstractNode node) throws Exception {
        MBeanNotificationInfo[] notifications = this.getChildNotifications(node);
        Vector<String> subscribedPrefixes = this.m_notificationFilter.getEnabledTypes();
        boolean foundNewSubscription = false;
        for (int i = notifications.length - 1; i >= 0; --i) {
            String prefix = ForwardedNotificationsModel.getTypePrefix(notifications[i].getNotifTypes());
            if (subscribedPrefixes.contains(prefix)) continue;
            foundNewSubscription = true;
            this.m_notificationFilter.enableType(prefix);
        }
        if (foundNewSubscription) {
            this.m_connector.addNotificationListener(this.m_componentName, (NotificationListener)this, (NotificationFilter)this.m_notificationFilter, (Object)this.m_handback);
        }
        node.setEnabled(true);
        node.setParentEnabled();
        this.fireNodeChanged(node);
    }

    @Override
    public void unsubscribeNotification(AbstractNode node) throws Exception {
        MBeanNotificationInfo[] notifications = this.getChildNotifications(node);
        Vector<String> subscribedPrefixes = this.m_notificationFilter.getEnabledTypes();
        for (int i = notifications.length - 1; i >= 0; --i) {
            String prefix = ForwardedNotificationsModel.getTypePrefix(notifications[i].getNotifTypes());
            if (!subscribedPrefixes.contains(prefix)) continue;
            this.m_notificationFilter.disableType(prefix);
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    if (ForwardedNotificationsModel.this.m_notificationFilter.getEnabledTypes().size() == 0) {
                        ForwardedNotificationsModel.this.m_connector.removeNotificationListener(ForwardedNotificationsModel.this.m_componentName, (NotificationListener)ForwardedNotificationsModel.this);
                    } else {
                        ForwardedNotificationsModel.this.m_connector.addNotificationListener(ForwardedNotificationsModel.this.m_componentName, (NotificationListener)ForwardedNotificationsModel.this, (NotificationFilter)ForwardedNotificationsModel.this.m_notificationFilter, (Object)ForwardedNotificationsModel.this.m_handback);
                    }
                }
                catch (Exception e) {
                    MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                }
            }
        }.start();
        node.setEnabled(false);
        node.setParentEnabled();
        this.fireNodeChanged(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification notification, Object handback) {
        Object[] listeners = null;
        if (!handback.equals(this.m_handback)) {
            return;
        }
        Hashtable hashtable = this.m_notificationListeners;
        synchronized (hashtable) {
            HashMap attrs = ((MFNotification)notification).getAttributes();
            String forwardedBy = (String)attrs.get("ForwardedBy");
            if (forwardedBy == null) {
                return;
            }
            if (!forwardedBy.equals(this.m_componentName.getCanonicalName())) {
                return;
            }
            handback = this.m_collectionName;
            HashSet listenerSet = (HashSet)this.m_notificationListeners.get(notification.getType());
            if (listenerSet == null) {
                return;
            }
            listeners = listenerSet.toArray();
        }
        for (int i = 0; i < listeners.length; ++i) {
            ((NotificationListener)listeners[i]).handleNotification(notification, handback);
        }
    }

    public void refreshTree() throws Exception {
        Object[] parameters = new Object[]{this.m_collectionName};
        String[] signatures = new String[]{String.class.getName()};
        MBeanNotificationInfo[] info = (MBeanNotificationInfo[])this.m_connector.invoke(this.m_objComponentName, "getForwardedNotificationsInfo", parameters, signatures);
        this.refreshTree(info);
        super.nodeStructureChanged(this.m_treeRootNode);
    }

    public void refreshTree(MBeanNotificationInfo[] infos) throws Exception {
        Enumeration<TreeNode> en = this.m_treeRootNode.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            AbstractNode node = (AbstractNode)en.nextElement();
            if (node == this.m_treeRootNode) continue;
            if (node instanceof Node) {
                MBeanNotificationInfo info = (MBeanNotificationInfo)node.getUserObject();
                if (this.inNewList(info, infos)) continue;
                ParentNode parent = (ParentNode)node.getParent();
                this.deleteNotificationListener(node);
                parent.remove(node);
                this.updateEnabledState(parent);
                super.nodeChanged(parent);
                continue;
            }
            if (!(node instanceof ParentNode) || node.getChildCount() != 0) continue;
            ParentNode parent = (ParentNode)node.getParent();
            parent.remove(node);
            super.nodeChanged(parent);
        }
        this.constructTree(infos, true);
    }

    private void updateEnabledState(AbstractParentNode parent) {
        Enumeration<TreeNode> en = parent.children();
        while (en.hasMoreElements()) {
            AbstractNode child = (AbstractNode)en.nextElement();
            if (!child.isEnabled()) continue;
            child.setParentEnabled();
            break;
        }
    }

    private boolean inNewList(MBeanNotificationInfo info, MBeanNotificationInfo[] newList) {
        boolean result = false;
        for (int i = 0; i < newList.length; ++i) {
            if (!info.equals(newList[i])) continue;
            return true;
        }
        return result;
    }

    private void constructTree(MBeanNotificationInfo[] infos, boolean refresh) {
        for (int i = 0; i < infos.length; ++i) {
            AbstractParentNode parent = this.m_treeRootNode;
            String[] nameTokens = infos[i].getNotifTypes();
            StringBuffer prefix = new StringBuffer();
            for (int j = 0; j < nameTokens.length; ++j) {
                if (j == nameTokens.length - 1) {
                    if (parent.getChild(nameTokens[j]) != null) continue;
                    parent.add(new Node(infos[i], nameTokens[j]));
                    if (!refresh) continue;
                    this.updateEnabledState(parent);
                    continue;
                }
                if (j > 0) {
                    prefix.append('.');
                }
                prefix.append(nameTokens[j]);
                AbstractParentNode childNode = (AbstractParentNode)parent.getChild(nameTokens[j]);
                if (childNode == null) {
                    childNode = new ParentNode(prefix.toString(), nameTokens[j]);
                    parent.add(childNode);
                }
                parent = childNode;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteNotificationListener(AbstractNode node) {
        MBeanNotificationInfo info = (MBeanNotificationInfo)node.getUserObject();
        String prefix = ForwardedNotificationsModel.getTypePrefix(info.getNotifTypes());
        Hashtable hashtable = this.m_notificationListeners;
        synchronized (hashtable) {
            HashSet listeners = (HashSet)this.m_notificationListeners.get(prefix);
            if (listeners != null) {
                listeners.clear();
                if (listeners.isEmpty()) {
                    this.m_notificationListeners.remove(prefix);
                }
            }
        }
        Vector<String> subscribedPrefixes = this.m_notificationFilter.getEnabledTypes();
        if (subscribedPrefixes.contains(prefix)) {
            this.m_notificationFilter.disableType(prefix);
            new Thread(){

                @Override
                public void run() {
                    try {
                        if (ForwardedNotificationsModel.this.m_notificationFilter.getEnabledTypes().size() == 0) {
                            ForwardedNotificationsModel.this.m_connector.removeNotificationListener(ForwardedNotificationsModel.this.m_componentName, (NotificationListener)ForwardedNotificationsModel.this);
                        } else {
                            ForwardedNotificationsModel.this.m_connector.addNotificationListener(ForwardedNotificationsModel.this.m_componentName, (NotificationListener)ForwardedNotificationsModel.this, (NotificationFilter)ForwardedNotificationsModel.this.m_notificationFilter, (Object)ForwardedNotificationsModel.this.m_handback);
                        }
                    }
                    catch (Exception e) {
                        MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                    }
                }
            }.start();
        }
    }
}

