/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.notifications.model;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.runtime.notifications.model.AbstractNotificationsModel;
import com.sonicsw.ma.gui.runtime.notifications.model.Node;
import com.sonicsw.ma.gui.runtime.notifications.model.ParentNode;
import com.sonicsw.ma.gui.runtime.util.AbstractNode;
import com.sonicsw.ma.gui.runtime.util.AbstractParentNode;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import java.rmi.dgc.VMID;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class NotificationsModel
extends AbstractNotificationsModel
implements NotificationListener {
    public static final boolean DEBUG = false;
    private String m_handback = new VMID().toString();

    public NotificationsModel(IRemoteMBeanServer connector, ObjectName componentName, MBeanNotificationInfo[] infos) throws Exception {
        super(connector, componentName, infos);
        this.constructTree(infos);
    }

    @Override
    public void subscribeNotification(AbstractNode node) throws Exception {
        MBeanNotificationInfo[] notifications = this.getChildNotifications(node);
        Vector<String> subscribedPrefixes = this.m_notificationFilter.getEnabledTypes();
        boolean foundNewSubscription = false;
        for (int i = notifications.length - 1; i >= 0; --i) {
            String prefix = NotificationsModel.getTypePrefix(notifications[i].getNotifTypes());
            if (subscribedPrefixes.contains(prefix)) continue;
            foundNewSubscription = true;
            this.m_notificationFilter.enableType(prefix);
        }
        if (foundNewSubscription) {
            this.m_connector.addNotificationListener(this.m_componentName, (NotificationListener)this, (NotificationFilter)this.m_notificationFilter, (Object)this.m_handback);
        }
        node.setEnabled(true);
        node.setParentEnabled();
        this.fireNodeChanged(node);
    }

    @Override
    public void unsubscribeNotification(AbstractNode node) throws Exception {
        MBeanNotificationInfo[] notifications = this.getChildNotifications(node);
        Vector<String> subscribedPrefixes = this.m_notificationFilter.getEnabledTypes();
        for (int i = notifications.length - 1; i >= 0; --i) {
            String prefix = NotificationsModel.getTypePrefix(notifications[i].getNotifTypes());
            if (!subscribedPrefixes.contains(prefix)) continue;
            this.m_notificationFilter.disableType(prefix);
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    if (NotificationsModel.this.m_notificationFilter.getEnabledTypes().size() == 0) {
                        NotificationsModel.this.m_connector.removeNotificationListener(NotificationsModel.this.m_componentName, (NotificationListener)NotificationsModel.this);
                    } else {
                        NotificationsModel.this.m_connector.addNotificationListener(NotificationsModel.this.m_componentName, (NotificationListener)NotificationsModel.this, (NotificationFilter)NotificationsModel.this.m_notificationFilter, (Object)NotificationsModel.this.m_handback);
                    }
                }
                catch (Exception e) {
                    MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                }
            }
        }.start();
        node.setEnabled(false);
        node.setParentEnabled();
        this.fireNodeChanged(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (!handback.equals(this.m_handback)) {
            return;
        }
        Object[] listeners = null;
        Hashtable hashtable = this.m_notificationListeners;
        synchronized (hashtable) {
            HashSet listenerSet = (HashSet)this.m_notificationListeners.get(notification.getType());
            if (listenerSet == null) {
                return;
            }
            listeners = listenerSet.toArray();
        }
        for (int i = 0; i < listeners.length; ++i) {
            ((NotificationListener)listeners[i]).handleNotification(notification, handback);
        }
    }

    private void constructTree(MBeanNotificationInfo[] infos) {
        for (int i = 0; i < infos.length; ++i) {
            AbstractParentNode parent = this.m_treeRootNode;
            String[] nameTokens = infos[i].getNotifTypes();
            StringBuffer prefix = new StringBuffer();
            for (int j = 0; j < nameTokens.length; ++j) {
                if (j == nameTokens.length - 1) {
                    if (parent.getChild(nameTokens[j]) != null) continue;
                    parent.add(new Node(infos[i], nameTokens[j]));
                    continue;
                }
                if (j > 0) {
                    prefix.append('.');
                }
                prefix.append(nameTokens[j]);
                AbstractParentNode childNode = (AbstractParentNode)parent.getChild(nameTokens[j]);
                if (childNode == null) {
                    childNode = new ParentNode(prefix.toString(), nameTokens[j]);
                    parent.add(childNode);
                }
                parent = childNode;
            }
        }
    }
}

