/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.propsheets;

import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.runtime.propsheets.RuntimeBean;
import com.sonicsw.ma.gui.runtime.propsheets.RuntimeModelDescriptor;
import com.sonicsw.ma.gui.util.GUIException;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IRuntimePlugin;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import javax.management.ObjectName;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import modelobjects.framework.EditRule;
import modelobjects.framework.ViewValueConverter;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.model.ModelDescriptor;
import modelobjects.framework.swing.JCheckBoxAdapter;
import modelobjects.framework.swing.JComboBoxAdapter;
import modelobjects.framework.swing.JLabelAdapter;
import modelobjects.framework.swing.JTextAreaAdapter;
import modelobjects.framework.swing.JTextFieldAdapter;

public abstract class JRuntimeDialog
extends JPropSheetDialog {
    public JRuntimeDialog(JMAFrame parent, String name) {
        super(parent, name, RuntimeBean.class);
    }

    public JRuntimeDialog(JRuntimeDialog parent, String name) {
        super(parent, name, RuntimeBean.class);
    }

    @Override
    protected ModelDescriptor makeModelDescriptor() {
        return new RuntimeModelDescriptor();
    }

    @Override
    public void editInstance(IPlugin plugin, Object model, boolean isNew) throws Exception {
        RuntimeBean bean = (RuntimeBean)model;
        IRemoteMBeanServer server = bean.getServer();
        RuntimeModelDescriptor desc = (RuntimeModelDescriptor)this.getDescriptor();
        ObjectName objName = bean.getName();
        String name = ((IRuntimePlugin)plugin).getPluginName();
        if (objName == null) {
            throw new GUIException("Management information is not available.\nMake sure '" + name + "' has a host.");
        }
        bean.cacheAllAttributes();
        desc.addModelAspectAdapters(server.getMBeanInfo(objName).getAttributes());
        super.editInstance(plugin, model, isNew);
        String titlePrefix = "";
        String title = "";
        String titleSuffix = "";
        if (isNew) {
            titlePrefix = ResourceManager.getString(this.getClass(), "JMADialog.newTitlePrefix");
            title = titlePrefix + " " + this.getTitle();
        } else {
            titlePrefix = ResourceManager.getString(this.getClass(), "JMADialog.editTitlePrefix");
            titleSuffix = ResourceManager.getString(this.getClass(), "JMADialog.editTitleSuffix");
            title = titlePrefix + " " + this.getTitle() + " " + titleSuffix;
        }
        this.setTitle(title);
    }

    public String getResourceLabel(String key) {
        return ResourceManager.getString(this.getClass(), new Object[]{"runtime", key, "label"});
    }

    public String getResourceUnit(String key) {
        return ResourceManager.getString(this.getClass(), new Object[]{"unit", key});
    }

    public JLabelAdapter createJLabelAdapter(String attributeName, JLabel viewComponent, ViewValueConverter converter) {
        return new JLabelAdapter(ModelAspectId.forName(attributeName), viewComponent, converter, this.getEditForm().getModelEditMediator());
    }

    public JTextFieldAdapter createJTextFieldAdapter(String attributeName, JTextField field, ViewValueConverter converter) {
        return new JTextFieldAdapter(ModelAspectId.forName(attributeName), field, EditRule.ALWAYS, converter, this.getEditForm().getModelEditMediator());
    }

    public JTextAreaAdapter createJTextAreaAdapter(String attributeName, JTextArea field, ViewValueConverter converter) {
        return new JTextAreaAdapter(ModelAspectId.forName(attributeName), field, EditRule.ALWAYS, converter, this.getEditForm().getModelEditMediator());
    }

    public JComboBoxAdapter createJComboBoxAdapter(String attributeName, JComboBox field, ViewValueConverter converter) {
        return new JComboBoxAdapter(ModelAspectId.forName(attributeName), field, EditRule.ALWAYS, converter, this.getEditForm().getModelEditMediator());
    }

    public JCheckBoxAdapter createJCheckBoxAdapter(String attributeName, JCheckBox field, ViewValueConverter converter) {
        return new JCheckBoxAdapter(ModelAspectId.forName(attributeName), field, EditRule.ALWAYS, converter, this.getEditForm().getModelEditMediator());
    }
}

