/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.propsheets;

import com.sonicsw.mf.common.runtime.IIdentity;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class RuntimeBean {
    private IRemoteMBeanServer m_server;
    private ObjectName m_name;
    private IIdentity m_identity;
    private HashMap m_attributes = new HashMap();

    public RuntimeBean(IRemoteMBeanServer server, ObjectName name, IIdentity identity) {
        this.m_server = server;
        this.m_name = name;
        this.m_identity = identity;
    }

    public IRemoteMBeanServer getServer() {
        return this.m_server;
    }

    public ObjectName getName() {
        return this.m_name;
    }

    public IIdentity getIdentity() {
        return this.m_identity;
    }

    public void cacheAllAttributes() throws IllegalArgumentException {
        this.m_attributes.clear();
        try {
            MBeanInfo info = this.m_server.getMBeanInfo(this.m_name);
            if (info != null) {
                MBeanAttributeInfo[] attributes = info.getAttributes();
                String[] names = new String[attributes.length];
                for (int i = 0; i < attributes.length; ++i) {
                    names[i] = attributes[i].getName();
                }
                AttributeList list = this.m_server.getAttributes(this.m_name, names);
                for (int i = 0; i < list.size(); ++i) {
                    Attribute attrib = (Attribute)list.get(i);
                    this.m_attributes.put(attrib.getName(), attrib.getValue());
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to get all runtime attributes", e);
        }
    }

    public Object getCachedAttribute(String attributeName) throws IllegalArgumentException {
        Object ret = this.m_attributes.get(attributeName);
        if (ret == null) {
            ret = this.getAttribute(attributeName);
        }
        return ret;
    }

    public Object getAttribute(String attributeName) throws IllegalArgumentException {
        Object res = null;
        try {
            res = this.m_server.getAttribute(this.m_name, attributeName);
        }
        catch (MBeanException e) {
            throw new IllegalArgumentException("MBean exception getting atribute <" + attributeName + ">", e);
        }
        catch (ReflectionException e) {
            throw new IllegalArgumentException("MBean reflection exception getting attribute <" + attributeName + ">", e);
        }
        catch (AttributeNotFoundException e) {
            throw new IllegalArgumentException("MBean <" + this.m_name + "> has no attribute <" + attributeName + ">", e);
        }
        catch (InstanceNotFoundException e) {
            throw new IllegalArgumentException("MBean <" + this.m_name + "> does not exist in the repository", e);
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e;
            }
            IllegalArgumentException th = new IllegalArgumentException("Failed to get attribute <" + attributeName + "> - " + e.getMessage());
            th.initCause(e);
            throw th;
        }
        return res;
    }

    protected void setAttribute(String attributeName, Object newValue) throws IllegalArgumentException {
        try {
            this.m_server.setAttribute(this.m_name, new Attribute(attributeName, newValue));
            if (this.m_attributes.containsKey(attributeName)) {
                this.m_attributes.put(attributeName, newValue);
            }
        }
        catch (MBeanException e) {
            throw new IllegalArgumentException("MBean exception setting attribute <" + attributeName + ">", e);
        }
        catch (InvalidAttributeValueException e) {
            throw new IllegalArgumentException("<" + newValue + "> is not a valid value for attribute <" + attributeName + "> in MBean <" + this.m_name + ">", e);
        }
        catch (ReflectionException e) {
            throw new IllegalArgumentException("MBean reflection exception setting attribute <" + attributeName + ">", e);
        }
        catch (AttributeNotFoundException e) {
            throw new IllegalArgumentException("MBean <" + this.m_name + "> has no attribute <" + attributeName + ">", e);
        }
        catch (InstanceNotFoundException e) {
            throw new IllegalArgumentException("MBean <" + this.m_name + "> not found", e);
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e;
            }
            IllegalArgumentException th = new IllegalArgumentException("Failed to set attribute <" + attributeName + "> - " + e.getMessage());
            th.initCause(e);
            throw th;
        }
    }

    public Object invoke(String methodName, Object[] params, String[] signature) throws IllegalArgumentException {
        Object res = null;
        ClassLoader loader = this.getClass().getClassLoader();
        try {
            res = ((JMSConnectorClient)this.m_server).invoke(this.m_name, methodName, params, signature, loader);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to invoke method <" + methodName + "> - " + e.getMessage(), e);
        }
        return res;
    }

    public String toString() {
        return this.m_server.toString() + "; " + this.m_name + "; " + this.m_identity;
    }
}

