/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.runtime.propsheets;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.runtime.propsheets.RuntimeBean;
import com.sonicsw.ma.gui.runtime.propsheets.RuntimeModelAspectAdapter;
import java.beans.PropertyVetoException;
import javax.management.MBeanAttributeInfo;
import modelobjects.framework.model.ModelAspectAdapter;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.model.ModelDescriptor;
import modelobjects.framework.model.ModelObjectAdapter;

public class RuntimeModelDescriptor
extends ModelDescriptor {
    public static final String ATTRIBUTE_NAME = "_NAME";

    public RuntimeModelDescriptor() {
        super(RuntimeBean.class);
        this.addModelAspectAdapter(new RuntimeNameAspectAdapter());
    }

    public void addModelAspectAdapters(MBeanAttributeInfo[] attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            try {
                RuntimeModelAspectAdapter adapter = new RuntimeModelAspectAdapter(attributes[i].getName(), Class.forName(attributes[i].getType()), !attributes[i].isWritable());
                this.addModelAspectAdapter(adapter);
                continue;
            }
            catch (ClassNotFoundException e) {
                System.err.println("Failed to find class (" + attributes[i].getType() + ") for runtime attribute <" + attributes[i].getName() + ">");
                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            }
        }
    }

    public class RuntimeNameAspectAdapter
    extends ModelAspectAdapter {
        public RuntimeNameAspectAdapter() {
            super(ModelAspectId.forName(RuntimeModelDescriptor.ATTRIBUTE_NAME), String.class);
        }

        @Override
        public boolean isReadonlyAspect() {
            return true;
        }

        @Override
        protected Object getAspectValue(Object modelObject, ModelObjectAdapter modelObjectAdapter) {
            String res = null;
            RuntimeBean bean = (RuntimeBean)modelObject;
            res = bean.getName().toString();
            return res;
        }

        @Override
        protected void setAspectValue(Object modelObject, Object newAspectValue, ModelObjectAdapter modelObjectAdapter) throws PropertyVetoException, IllegalArgumentException, UnsupportedOperationException {
        }
    }
}

