/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.table;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.ITableContentPane;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.FilterTableModel;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JRowTable;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.gui.util.PluginMouseClickListener;
import com.sonicsw.ma.plugin.IPlugin;
import java.awt.BorderLayout;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public abstract class AbstractTableContentPane
extends JPanel
implements ITableContentPane {
    protected ExtendedJScrollPane m_scroller;
    protected JRowTable m_table;
    private IPlugin m_plugin;
    private Object m_refreshSync = new Object();

    public AbstractTableContentPane(IPlugin plugin) throws IllegalArgumentException {
        if (plugin == null) {
            throw new IllegalArgumentException("Content Pane must have a plugin (plugin = null)");
        }
        this.setPluginProperty(plugin);
        this.initializaUI();
    }

    private void setPluginProperty(IPlugin plugin) {
        this.setPlugin(plugin);
    }

    private void initializaUI() {
        this.initUI();
    }

    public void activateFilter(boolean bActivateFilter) {
        TableModel model = this.m_table.getModel();
        if (model instanceof FilterTableModel) {
            ((FilterTableModel)model).activateFilter(bActivateFilter);
        }
    }

    public boolean isFilterActivated() {
        boolean bIsFilterActivated = false;
        TableModel model = this.m_table.getModel();
        if (model instanceof FilterTableModel) {
            bIsFilterActivated = ((FilterTableModel)model).isFilterActivated();
        }
        return bIsFilterActivated;
    }

    public void filterData(boolean bFilter) {
        TableModel model = this.m_table.getModel();
        if (model instanceof FilterTableModel) {
            ((FilterTableModel)model).filterData(bFilter);
        }
    }

    @Override
    public IPlugin getPlugin() {
        return this.m_plugin;
    }

    protected void setPlugin(IPlugin plugin) {
        this.m_plugin = plugin;
    }

    @Override
    public Object[] getSelectedItems() {
        int[] sel = this.m_table.getSelectedRows();
        Object[] res = new Object[sel.length];
        IModelTableModel model = (IModelTableModel)this.m_table.getModel();
        for (int i = 0; i < res.length; ++i) {
            res[i] = model.getRowModel(sel[i]);
        }
        return res;
    }

    @Override
    public Object getSelectedItem() {
        Object[] res = this.getSelectedItems();
        return res != null && res.length > 0 ? res[0] : null;
    }

    @Override
    public void addRowModel(Object object) {
        ((IModelTableModel)this.m_table.getModel()).addRow(object);
    }

    @Override
    public void removeRowModel(Object object) {
        ((IModelTableModel)this.m_table.getModel()).delete(object);
    }

    @Override
    public void refreshRowModel(Object object) {
        IModelTableModel model = (IModelTableModel)this.m_table.getModel();
        int contentIndex = model.getContents().indexOf(object);
        int modelIndex = model.getIndexOf(object);
        if (contentIndex >= 0) {
            if (contentIndex != modelIndex) {
                model.deleteRow(contentIndex);
                model.addRow(object);
            } else {
                model.rowChanged(modelIndex);
            }
        }
    }

    @Override
    public void refresh() {
        Helper.logDebugMessage("refresh content pane - " + this.getClass().getName());
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = AbstractTableContentPane.this.m_refreshSync;
                synchronized (object) {
                    JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());
                    MgmtConsole.getMgmtConsole().getStatusBar().setPersistentMessage("Adding elements to view...");
                    try {
                        AbstractTableContentPane.this.setTableData(AbstractTableContentPane.this.getPlugin());
                    }
                    catch (Exception e) {
                        MgmtConsole.getMgmtConsole().notifyMessage(4, "Failed to refresh content pane", e, false);
                    }
                    finally {
                        MgmtConsole.getMgmtConsole().getStatusBar().showStatusMessage(null);
                        wc.release();
                    }
                }
            }
        });
        t.start();
    }

    @Override
    public AbstractButton[] getToolbarItems() {
        return null;
    }

    @Override
    public JComponent[] getMenuItems(int type) {
        return null;
    }

    @Override
    public BasicAction getDefaultAction() {
        Object sel = this.getSelectedItem();
        if (sel == null || !(sel instanceof IPlugin)) {
            return null;
        }
        return ((IPlugin)sel).getDefaultAction();
    }

    protected void initUI() {
        this.setLayout(new BorderLayout());
        this.m_table = new JRowTable(new FilterTableModel(this.getColumns()), this.getClass().getName());
        this.m_scroller = new ExtendedJScrollPane();
        this.add(this.m_scroller);
        this.m_scroller.setViewportView(this.m_table);
        this.m_table.setRowHeight(this.m_table.getRowHeight() + 2);
        this.m_table.addMouseListener(new PluginMouseClickListener(this));
    }

    @Override
    public final JRowTable getTable() {
        return this.m_table;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public JScrollPane getScroller() {
        return this.m_scroller;
    }

    @Override
    public abstract TableColumn[] getColumns();

    @Override
    public abstract void setTableData(IPlugin var1);
}

