/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.table;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.table.RowTableColumn;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;

public class BeanPropertyTableColumn
extends RowTableColumn {
    private Method m_readMethod;
    private Method m_writeMethod;

    public BeanPropertyTableColumn(int modelIndex, PropertyDescriptor propDesc, int width) {
        super(modelIndex, BeanPropertyTableColumn.capitalize(propDesc.getName()), width);
        this.setEditable(propDesc.getWriteMethod() != null);
        this.m_readMethod = propDesc.getReadMethod();
        this.m_writeMethod = propDesc.getWriteMethod();
    }

    @Override
    public Object getColumnValue(Object rowModel) {
        Object value = null;
        try {
            Object v = this.m_readMethod.invoke(rowModel, null);
            value = v == null || v instanceof Number || v instanceof Boolean ? v : v.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
        return value;
    }

    @Override
    public void setColumnValue(Object rowModel, Object columnValue) {
        try {
            this.m_writeMethod.invoke(rowModel, columnValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0 || !Character.isLowerCase(name.charAt(0))) {
            return name;
        }
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private static Class getColumnType(Class propType) {
        if (propType.isPrimitive()) {
            if (propType == Boolean.TYPE) {
                return Boolean.class;
            }
            if (propType == Byte.TYPE) {
                return Byte.class;
            }
            if (propType == Character.TYPE) {
                return Character.class;
            }
            if (propType == Short.TYPE) {
                return Short.class;
            }
            if (propType == Integer.TYPE) {
                return Integer.class;
            }
            if (propType == Long.TYPE) {
                return Long.class;
            }
            if (propType == Float.TYPE) {
                return Float.class;
            }
            if (propType == Double.TYPE) {
                return Double.class;
            }
        } else if (Number.class.isAssignableFrom(propType)) {
            return propType;
        }
        return String.class;
    }
}

