/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.table;

import com.sonicsw.ma.gui.table.DSToViewPathStringTableColumn;
import com.sonicsw.ma.gui.util.ExtendedJTable;
import com.sonicsw.ma.gui.util.ImageOverlayIcon;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.gui.util.Utils;
import com.sonicsw.ma.plugin.IConfigPluginFactory;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IdentityOnlyConfigBean;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTable;

public class ConfigBeanTableCellRenderer
extends ExtendedJTable.ExtendedTableCellRenderer {
    protected IPlugin m_plugin;
    protected static Map typeVsOverLayIconMap = new HashMap();

    public ConfigBeanTableCellRenderer(IPlugin plugin) {
        this.setHorizontalAlignment();
        this.m_plugin = plugin;
    }

    private void setHorizontalAlignment() {
        this.setHorizontalAlignment(2);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        String type = null;
        String version = null;
        if (value instanceof IConfigBean) {
            IConfigBean bean = (IConfigBean)value;
            type = bean.getConfigType().getName();
            version = bean.getConfigType().getVersion();
        }
        IConfigPluginFactory pf = this.m_plugin.getPluginContext().getConfigContext().getPluginFactory(type, version, null);
        if (value instanceof IdentityOnlyConfigBean) {
            if (IdentityOnlyConfigBean.isUnidentifiable((IConfigBean)((IConfigBean)value)) || pf == null) {
                this.setIcon(ConfigBeanTableCellRenderer.getNoPermsIconFor(this.getClass(), null));
            } else if (pf != null) {
                this.setIcon(ConfigBeanTableCellRenderer.getNoPermsIconFor(pf.getClass(), type));
            }
        } else if (pf != null) {
            this.setIcon(ResourceManager.getTypeIcon(pf.getClass(), type));
        } else {
            this.setIcon(ResourceManager.getTypeIcon(this.getClass(), null));
        }
        String text = ConfigBeanTableCellRenderer.getCaptionText(value);
        this.setText(text);
        this.setToolTipText(result, table, text, column);
        return result;
    }

    protected static String getCaptionText(Object value) {
        String ret = "";
        if (value instanceof IConfigBean) {
            String configBeanName = Utils.getConfigBeanIdentifierName((IConfigBean)value);
            ret = DSToViewPathStringTableColumn.formatPath(configBeanName);
        }
        return ret;
    }

    protected static Icon getNoPermsIconFor(Class clazz, String type) {
        String typeKey = type == null ? "unknown.Type" : type;
        Icon icon = (Icon)typeVsOverLayIconMap.get(typeKey);
        if (icon != null) {
            return icon;
        }
        Icon noPerms = ResourceManager.getIcon(clazz, "lock3");
        Icon typeIcon = ResourceManager.getTypeIcon(clazz, type);
        icon = new ImageOverlayIcon(typeIcon, noPerms);
        typeVsOverLayIconMap.put(typeKey, icon);
        return icon;
    }
}

