/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.table;

import com.sonicsw.ma.gui.table.ModelListTableModel;
import com.sonicsw.ma.gui.util.ExtendedJTable;
import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.IConfigPrototype;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;

public class ConfigElementTableCellRenderer
extends ExtendedJTable.ExtendedTableCellRenderer {
    protected Font m_plainFont;
    protected Font m_italicFont;
    protected String m_typeTip;
    protected IConfigPath m_namePath;

    public ConfigElementTableCellRenderer(IConfigPath name) {
        this(null, name);
    }

    public ConfigElementTableCellRenderer(String typeTip, IConfigPath name) {
        this.setHorizontalAlignment();
        this.m_typeTip = typeTip;
        this.m_namePath = name;
    }

    private void setHorizontalAlignment() {
        this.setHorizontalAlignment(2);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (table.getModel() instanceof ModelListTableModel) {
            Object rowModel = ((ModelListTableModel)table.getModel()).getRowModel(row);
            if (rowModel instanceof ConfigBeanModel) {
                rowModel = ((ConfigBeanModel)rowModel).getData();
            }
            if (rowModel instanceof IConfigElement) {
                String viewName;
                IConfigElement ce = (IConfigElement)rowModel;
                String string = viewName = this.m_namePath != null ? (String)ce.getAttribute(this.m_namePath) : null;
                if (ce instanceof IConfigPrototype) {
                    if (this.m_italicFont == null) {
                        this.m_italicFont = result.getFont().deriveFont(3);
                    }
                    result.setFont(this.m_italicFont);
                } else {
                    if (this.m_plainFont == null) {
                        this.m_plainFont = result.getFont().deriveFont(0);
                    }
                    result.setFont(this.m_plainFont);
                }
                this.setToolTipText(this.buildToolTipText(ce, viewName));
            } else {
                this.setToolTipText(null);
            }
        } else {
            this.setToolTipText(null);
        }
        this.setText((String)value);
        return this;
    }

    private String buildToolTipText(IConfigElement ce, String viewName) {
        String path;
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        if (this.m_typeTip != null) {
            buffer.append("Type: " + this.m_typeTip).append("<br>");
        }
        if (viewName != null) {
            buffer.append("Name: " + viewName).append("<br>");
        }
        if ((path = ce.getName()).endsWith("_Default")) {
            path = path.substring(0, path.lastIndexOf(47));
        }
        buffer.append("Configuration: " + path);
        if (ce instanceof IConfigPrototype) {
            buffer.append("<br>").append("Template: yes");
        }
        if (ce.isPrototypeInstance()) {
            buffer.append("<br>");
            buffer.append("Linked to template: ");
            buffer.append(ce.getPrototype().getName());
        }
        buffer.append("</html>");
        return buffer.toString();
    }
}

