/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.table;

import com.sonicsw.ma.gui.table.ConfigBeanTableCellRenderer;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.RowTableColumn;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ModelListTableModel
extends AbstractTableModel
implements IModelTableModel,
TableColumnModelListener {
    private static final boolean DEBUG = false;
    protected int m_columnCount;
    protected TableColumn[] m_tableColumns;
    protected List m_listView;
    protected Comparator sortComparator;
    protected int sortColumn;
    protected boolean sortedAscending = true;
    protected int lastRow = -1;
    protected int lastCol = -1;
    protected Object lastVal = null;
    protected boolean m_bSortIsActive = false;

    public ModelListTableModel(TableColumn[] tableColumns) {
        this(tableColumns, new ArrayList());
    }

    public ModelListTableModel(TableColumn[] tableColumns, List contents) {
        this(tableColumns, new ArrayList(), true);
    }

    public ModelListTableModel(TableColumn[] tableColumns, List contents, boolean bSortIsActive) {
        this.m_tableColumns = tableColumns;
        this.m_columnCount = tableColumns.length;
        this.m_bSortIsActive = bSortIsActive;
        this.setContents(contents);
    }

    @Override
    public void activateSort(boolean bSortIsActive) {
        this.m_bSortIsActive = bSortIsActive;
    }

    @Override
    public boolean isSortActivated() {
        return this.m_bSortIsActive;
    }

    @Override
    public List getContents() {
        return this.m_listView;
    }

    @Override
    public final void setContents(List contents) {
        this.m_listView = contents;
        this.invalidateCellCache();
        this.sortByColumn(this.getSortColumn(), this.isSortedInAscendingOrder());
        this.fireTableStructureChanged();
    }

    @Override
    public TableColumn[] getColumns() {
        return this.m_tableColumns;
    }

    @Override
    public TableColumn getColumn(int modelColumnIndex) {
        return this.m_tableColumns[modelColumnIndex];
    }

    @Override
    public void fireTableChanged(TableModelEvent event) {
        this.invalidateCellCache();
        super.fireTableChanged(event);
    }

    @Override
    public int getRowCount() {
        return this.m_listView.size();
    }

    @Override
    public int getColumnCount() {
        return this.m_tableColumns.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        Object value = this.getColumn(columnIndex).getHeaderValue();
        return value != null ? value.toString() : "";
    }

    @Override
    public Object getRowModel(int row) {
        return row >= 0 && row < this.m_listView.size() ? this.m_listView.get(row) : null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return ((RowTableColumn)this.getColumn(column)).isEditable();
    }

    @Override
    public int findCell(int startRow, int columnIndex, Object value) {
        for (int rowIndex = startRow; rowIndex < this.getRowCount(); ++rowIndex) {
            Object cellValue = this.getValueAt(rowIndex, columnIndex);
            if (cellValue == null && value == null) {
                return rowIndex;
            }
            if (cellValue == null || value == null || !value.equals(cellValue)) continue;
            return rowIndex;
        }
        return -1;
    }

    private int binarySearch(Object[] a, Object key, Comparator c) {
        int i;
        int mid = Arrays.binarySearch(a, key, c);
        if (mid < 0) {
            return mid;
        }
        if (a[mid].equals(key)) {
            return mid;
        }
        for (i = mid - 1; i >= 0 && c.compare(key, a[i]) == 0; --i) {
            if (!key.equals(a[i])) continue;
            return i;
        }
        for (i = mid + 1; i < a.length && c.compare(key, a[i]) == 0; ++i) {
            if (!key.equals(a[i])) continue;
            return i;
        }
        return -(mid + 1);
    }

    @Override
    public int getIndexOf(Object obj) {
        if (!this.isSortActivated() || this.sortComparator == null) {
            return this.m_listView.indexOf(obj);
        }
        return this.binarySearch(this.m_listView.toArray(), obj, this.sortComparator);
    }

    @Override
    public void insertRow(Object rowModel, int index) {
        this.debugPrintln("insertRow " + index);
        this.m_listView.add(index, rowModel);
        this.fireTableRowsInserted(index, index);
        this.recheckSortedOrder(index);
    }

    @Override
    public int addRow(Object rowModel) {
        int insertIndex = this.getRowCount();
        if (!this.isSortActivated()) {
            this.insertRow(rowModel, insertIndex);
        } else {
            int index = this.getIndexOf(rowModel);
            if (index < 0) {
                if ((index = -1 - index) < insertIndex) {
                    insertIndex = index;
                }
                this.m_listView.add(insertIndex, rowModel);
                this.fireTableRowsInserted(insertIndex, insertIndex);
            } else {
                insertIndex = -1;
                this.fireTableRowsUpdated(index, index);
            }
        }
        this.debugPrintln("addRow " + insertIndex);
        return insertIndex;
    }

    @Override
    public void insertRowMaintainSort(Object rowModel) {
        this.addRow(rowModel);
    }

    @Override
    public void deleteRow(int index) {
        this.m_listView.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    @Override
    public void delete(Object obj) {
        int row = this.getIndexOf(obj);
        if (row >= 0) {
            this.deleteRow(row);
        }
    }

    protected void debugPrintln(String str) {
    }

    @Override
    public void clear() {
        if (this.getRowCount() == 0) {
            return;
        }
        this.debugPrintln("clear");
        this.m_listView.clear();
        this.fireTableStructureChanged();
    }

    @Override
    public void rowChanged(int index) {
        this.fireTableRowsUpdated(index, index);
        this.recheckSortedOrder(index);
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row == this.lastRow && column == this.lastCol) {
            return this.lastVal;
        }
        Object value = ((RowTableColumn)this.m_tableColumns[column]).getColumnValue(this.getRowModel(row));
        this.lastRow = row;
        this.lastCol = column;
        this.lastVal = value;
        return value;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        this.invalidateCellCache();
        ((RowTableColumn)this.m_tableColumns[column]).setColumnValue(this.getRowModel(row), value);
        this.recheckSortedOrder(row);
    }

    public TableCellRenderer getColumnCellRenderer(int columnIndex) {
        return this.m_tableColumns[columnIndex].getCellRenderer();
    }

    public void setColumnCellRenderer(int columnIndex, TableCellRenderer cellRenderer) {
        this.m_tableColumns[columnIndex].setCellRenderer(cellRenderer);
    }

    public TableCellEditor getColumnCellEditor(int columnIndex) {
        return this.m_tableColumns[columnIndex].getCellEditor();
    }

    public void setColumnCellEditor(int columnIndex, TableCellEditor cellEditor) {
        this.m_tableColumns[columnIndex].setCellEditor(cellEditor);
    }

    public Class getColumnClass(int columnIndex) {
        return ((RowTableColumn)this.m_tableColumns[columnIndex]).getColumnClass();
    }

    private void invalidateCellCache() {
        this.lastRow = -1;
        this.lastCol = -1;
        this.lastVal = null;
    }

    @Override
    public void sortByColumn(int modelColumnIndex) {
        if (this.isSortActivated()) {
            this.sortByColumn(modelColumnIndex, this.sortColumn != modelColumnIndex || !this.sortedAscending);
        }
    }

    @Override
    public void sortByColumn(int modelColumnIndex, boolean ascending) {
        if (this.isSortActivated()) {
            this.debugPrintln("sortByColumn " + modelColumnIndex + " " + (ascending ? "ASCENDING" : "DESCENDING"));
            if (modelColumnIndex == -1) {
                return;
            }
            RowTableColumn column = (RowTableColumn)this.m_tableColumns[modelColumnIndex];
            if (!column.isSortable()) {
                return;
            }
            Comparator comparator = this.getComparator(column, ascending);
            Object[] modelArray = this.m_listView.toArray();
            Arrays.sort(modelArray, comparator);
            this.m_listView.clear();
            int n = modelArray.length;
            for (int i = 0; i < n; ++i) {
                this.m_listView.add(i, modelArray[i]);
            }
            this.setSortedByColumn(modelColumnIndex, ascending);
            this.fireTableDataChanged();
        }
    }

    protected Comparator getComparator(RowTableColumn column, boolean ascending) {
        return new DefaultComparator(column, ascending);
    }

    @Override
    public void setSortedByColumn(int modelColumnIndex, boolean ascending) {
        if (this.isSortActivated()) {
            if (modelColumnIndex >= this.m_tableColumns.length) {
                modelColumnIndex = 0;
            }
            Comparator oldComparator = this.sortComparator;
            int oldSortColumn = this.sortColumn;
            this.sortColumn = modelColumnIndex;
            this.sortedAscending = ascending;
            this.sortComparator = modelColumnIndex == -1 ? null : new DefaultComparator((RowTableColumn)this.m_tableColumns[modelColumnIndex], ascending);
            if (oldSortColumn != this.sortColumn || oldComparator != this.sortComparator) {
                this.fireTableStructureChanged();
            }
        }
    }

    @Override
    public boolean isSorted() {
        return this.sortComparator != null;
    }

    void recheckSortedOrder(int rowNumber) {
        if (this.isSortActivated() && this.sortComparator != null && rowNumber >= 0) {
            Object nextRowModel;
            Object prevRowModel;
            this.debugPrintln("recheckSortedOrder " + rowNumber);
            Object rowModel = this.getRowModel(rowNumber);
            boolean sorted = true;
            if (rowNumber > 0 && this.sortComparator.compare(prevRowModel = this.getRowModel(rowNumber - 1), rowModel) > 0) {
                sorted = false;
            }
            if (sorted && rowNumber + 1 < this.m_listView.size() && this.sortComparator.compare(rowModel, nextRowModel = this.getRowModel(rowNumber + 1)) > 0) {
                sorted = false;
            }
            if (!sorted) {
                this.setSortedByColumn(-1, false);
            }
        }
    }

    @Override
    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public boolean isSortedInAscendingOrder() {
        return this.sortedAscending;
    }

    @Override
    public void columnAdded(TableColumnModelEvent evt) {
        ++this.m_columnCount;
    }

    @Override
    public void columnRemoved(TableColumnModelEvent evt) {
        --this.m_columnCount;
        if (this.sortColumn >= this.m_columnCount) {
            this.sortColumn = -1;
        }
    }

    @Override
    public void columnMoved(TableColumnModelEvent evt) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent evt) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent evt) {
    }

    class DefaultComparator
    implements Comparator {
        private RowTableColumn m_tableColumn;
        private boolean m_ascending;

        public DefaultComparator(RowTableColumn tableColumn, boolean ascending) {
            this.m_tableColumn = tableColumn;
            this.m_ascending = ascending;
        }

        public int compare(Object row1, Object row2) {
            Object cell1 = this.m_tableColumn.getColumnValue(row1);
            Object cell2 = this.m_tableColumn.getColumnValue(row2);
            if (this.m_tableColumn.getCellRenderer() instanceof ConfigBeanTableCellRenderer) {
                cell1 = ConfigBeanTableCellRenderer.getCaptionText(cell1);
                cell2 = ConfigBeanTableCellRenderer.getCaptionText(cell2);
            }
            int res = this.doCompare(cell1, cell2);
            return this.m_ascending ? res : -res;
        }

        private int doCompare(Object a, Object b) {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            Collator collator = Collator.getInstance();
            if (a instanceof String && b instanceof String) {
                return collator.compare(a, b);
            }
            if (a instanceof Comparable) {
                return ((Comparable)a).compareTo(b);
            }
            if (b instanceof Comparable) {
                return -((Comparable)b).compareTo(a);
            }
            return collator.compare(a.toString(), b.toString());
        }
    }
}

