/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.table;

import com.sonicsw.ma.gui.dev.DevElementPlugin;
import com.sonicsw.ma.gui.dev.DevModel;
import com.sonicsw.ma.gui.file.FileElementModel;
import com.sonicsw.ma.gui.file.FileElementPlugin;
import com.sonicsw.ma.gui.table.RowTableColumn;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.PluginAttributes;
import javax.swing.table.TableCellRenderer;

public class ObjectColumn
extends RowTableColumn {
    public static final String NAME_STR = "Name";
    public static final String SIZE_STR = "Size";
    public static final String TYPE_STR = "Type";
    public static final String DATEMODIFIED_STR = "Date Modified";
    public static final String DATECREATED_STR = "Date Created";
    public static final String ATTRIBUTES_STR = "Attributes";
    public static final String VERSION_STR = "Version";

    public ObjectColumn(int modelIndex, String name, int initialWidth) {
        this(modelIndex, name, initialWidth, null);
    }

    public ObjectColumn(int modelIndex, String name, int initialWidth, TableCellRenderer renderer) {
        super(modelIndex, name, initialWidth);
        if (renderer != null) {
            this.setColumnCellRenderer(renderer);
        }
    }

    private void setColumnCellRenderer(TableCellRenderer renderer) {
        this.setCellRenderer(renderer);
    }

    @Override
    public Object getColumnValue(Object rowModel) {
        if (rowModel instanceof IPlugin) {
            IPlugin plugin = (IPlugin)rowModel;
            if (NAME_STR.equalsIgnoreCase((String)this.getHeaderValue())) {
                return plugin.toString();
            }
            if (SIZE_STR.equalsIgnoreCase((String)this.getHeaderValue())) {
                if (plugin instanceof FileElementPlugin) {
                    FileElementModel model = (FileElementModel)plugin.getModel();
                    return model.getSize();
                }
                if (plugin instanceof DevElementPlugin) {
                    DevModel model = (DevModel)plugin.getModel();
                    return model.getSize();
                }
                return new Long(-1L);
            }
            if (TYPE_STR.equalsIgnoreCase((String)this.getHeaderValue())) {
                if (plugin instanceof DevElementPlugin) {
                    return ((DevModel)plugin.getModel()).getType();
                }
                if (plugin instanceof FileElementPlugin) {
                    return ((FileElementModel)plugin.getModel()).getType();
                }
                return plugin.getAttributes().getDisplayType();
            }
            if (DATEMODIFIED_STR.equalsIgnoreCase((String)this.getHeaderValue())) {
                if (plugin instanceof FileElementPlugin) {
                    FileElementModel model = (FileElementModel)plugin.getModel();
                    return model.getLastModifiedTime();
                }
                if (plugin instanceof DevElementPlugin) {
                    DevModel model = (DevModel)plugin.getModel();
                    return model.getLastModifiedTime();
                }
                return "";
            }
            if (DATECREATED_STR.equalsIgnoreCase((String)this.getHeaderValue())) {
                if (plugin instanceof FileElementPlugin) {
                    FileElementModel model = (FileElementModel)plugin.getModel();
                    return model.getCreationTime();
                }
                if (plugin instanceof DevElementPlugin) {
                    DevModel model = (DevModel)plugin.getModel();
                    return model.getCreationTime();
                }
                return "";
            }
            if (ATTRIBUTES_STR.equalsIgnoreCase((String)this.getHeaderValue())) {
                StringBuffer sb = new StringBuffer();
                if (plugin.getAttributes().isSystem()) {
                    sb.append("S");
                }
                return sb.toString();
            }
            if (VERSION_STR.equalsIgnoreCase((String)this.getHeaderValue())) {
                PluginAttributes attributes = ((IPlugin)rowModel).getAttributes();
                return attributes.getProductVersion();
            }
            return plugin;
        }
        if (rowModel instanceof String) {
            return rowModel;
        }
        return null;
    }
}

