/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.table;

import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.ObjectColumn;
import com.sonicsw.ma.gui.table.ObjectListContentPane;
import com.sonicsw.ma.gui.table.PluginNameTableCellRenderer;
import com.sonicsw.ma.gui.table.PluginTypeTableCellRenderer;
import com.sonicsw.ma.gui.table.PluginVersionTableCellRenderer;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginChangeListener;
import com.sonicsw.ma.plugin.PluginDnd;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeNode;

public class PluginContentPane
extends ObjectListContentPane
implements IPluginChangeListener {
    public PluginContentPane(IPlugin plugin) {
        super(plugin);
        new PluginDnd(this.getTable());
    }

    @Override
    public JComponent[] getMenuItems(int type) {
        if (this.getTable().getSelectedRowCount() == 1) {
            JComponent[] items;
            Object rowModel;
            IModelTableModel tableModel = (IModelTableModel)this.getTable().getModel();
            int nSelectedRow = this.getTable().getSelectedRow();
            if (nSelectedRow != -1 && (rowModel = tableModel.getRowModel(nSelectedRow)) != null && (items = ((IPlugin)rowModel).getMenuItems(type)) != null) {
                ArrayList<JComponent> list = new ArrayList<JComponent>();
                for (int i = 0; i < items.length; ++i) {
                    if (!(items[i] instanceof JMenuItem)) continue;
                    list.add(items[i]);
                }
                return list.toArray(new JComponent[list.size()]);
            }
        }
        return null;
    }

    @Override
    protected List getRowModel(IPlugin plugin) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        for (int i = 0; i < ((AbstractGUIPlugin)plugin).getChildCount(); ++i) {
            if (!(((AbstractGUIPlugin)plugin).getChildAt(i) instanceof IPlugin)) continue;
            list.add(((AbstractGUIPlugin)plugin).getChildAt(i));
        }
        return list;
    }

    @Override
    public TableColumn[] getColumns() {
        return new TableColumn[]{new ObjectColumn(0, "Name", 40, new PluginNameTableCellRenderer()), new ObjectColumn(1, "Type", 40, new PluginTypeTableCellRenderer()), new ObjectColumn(2, "Version", 20, new PluginVersionTableCellRenderer())};
    }

    @Override
    public void onAdded(IPlugin plugin) {
        this.addRowModel(plugin);
    }

    @Override
    public void onUpdated(IPlugin plugin) {
        this.refreshRowModel(plugin);
    }

    @Override
    public void onDeleted(IPlugin plugin) {
        IModelTableModel model = (IModelTableModel)this.m_table.getModel();
        int index = model.getIndexOf(plugin);
        boolean selected = this.m_table.isRowSelected(index);
        this.removeRowModel(plugin);
        if (selected && index > 0) {
            this.m_table.setRowSelectionInterval(--index, index);
        }
        if (selected && this.m_table.getRowCount() == 0) {
            this.m_table.clearSelection();
        }
    }

    @Override
    public void onRenamed(IPlugin plugin) {
        this.refreshRowModel(plugin);
    }
}

