/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.table;

import com.sonicsw.ma.gui.dev.AbstractDevPlugin;
import com.sonicsw.ma.gui.dev.DevModel;
import com.sonicsw.ma.gui.table.ModelListTableModel;
import com.sonicsw.ma.gui.util.ColorIcon;
import com.sonicsw.ma.gui.util.ExtendedImageIcon;
import com.sonicsw.ma.gui.util.ExtendedJTable;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.gui.util.StateHelper;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.PluginAttributes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;

public class PluginNameTableCellRenderer
extends ExtendedJTable.ExtendedTableCellRenderer {
    protected Font m_plainFont = null;
    protected Font m_italicFont = null;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Object rowModel;
        JLabel result = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (table.getModel() instanceof ModelListTableModel && (rowModel = ((ModelListTableModel)table.getModel()).getRowModel(row)) instanceof IPlugin) {
            IPlugin plugin = (IPlugin)rowModel;
            PluginAttributes attributes = plugin.getAttributes();
            String pluginType = attributes.getType();
            Icon icon = null;
            icon = plugin instanceof AbstractDevPlugin ? ((DevModel)plugin.getModel()).getTypeIcon() : (pluginType != null ? ResourceManager.getTypeIcon(plugin.getClass(), pluginType) : UIManager.getIcon("Tree.closedIcon"));
            if (attributes.isRuntimeRoot() || attributes.isStateable()) {
                Color backgroundColor = Color.blue;
                if (attributes.getState() != null) {
                    backgroundColor = StateHelper.componentStateToColor(attributes.getState());
                }
                icon = new ExtendedImageIcon(new ColorIcon(backgroundColor), icon);
            }
            result.setIcon(icon);
            if (plugin instanceof IConfigPlugin) {
                result.setFont(((IConfigPlugin)plugin).isTemplatePrototype() ? this.getItalicFont() : this.getPlainFont());
            }
        }
        return result;
    }

    private Font getPlainFont() {
        if (this.m_plainFont == null) {
            this.m_plainFont = this.getFont().deriveFont(0);
        }
        return this.m_plainFont;
    }

    private Font getItalicFont() {
        if (this.m_italicFont == null) {
            this.m_italicFont = this.getFont().deriveFont(3);
        }
        return this.m_italicFont;
    }
}

