/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.MgmtConsole;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class BasicAction
extends AbstractAction
implements PropertyChangeListener {
    public static final String LARGE_ICON = "LargeIcon";
    public static final String PROP_SELECTED_STATE = "PROP_SELECTED_STATE";
    private boolean m_selected = false;
    private boolean m_checkTargetValue = false;
    private Action m_targetAction;

    public BasicAction() {
        this((Action)null);
    }

    public BasicAction(Action targetAction) {
        this.setTargetAction(targetAction);
    }

    public final void setCheckTargetValue(boolean check) {
        this.m_checkTargetValue = check;
    }

    public boolean getCheckTargetValue() {
        return this.m_checkTargetValue;
    }

    public String getActionCommand() {
        return (String)this.getValue("ActionCommandKey");
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public String getShortDescription() {
        return (String)this.getValue("ShortDescription");
    }

    public String getLongDescription() {
        return (String)this.getValue("LongDescription");
    }

    public Integer getMnemonicKey() {
        return (Integer)this.getValue("MnemonicKey");
    }

    public Integer getAcceleratorKey() {
        return (Integer)this.getValue("AcceleratorKey");
    }

    public Icon getSmallIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    public Icon getLargeIcon() {
        return (Icon)this.getValue(LARGE_ICON);
    }

    protected Icon loadIcon(String iconResourceName) {
        ImageIcon icon = null;
        URL url = this.getClass().getClassLoader().getResource(iconResourceName);
        if (url != null) {
            icon = new ImageIcon(url);
            if (icon == null) {
                this.debugErrorOutput("Failed to load icon: " + url);
            }
        } else {
            this.debugErrorOutput("Failed to locate icon: " + iconResourceName);
        }
        return icon;
    }

    @Override
    public Object getValue(String key) {
        Object value = super.getValue(key);
        if (this.m_checkTargetValue && value == null && this.m_targetAction != null) {
            value = this.m_targetAction.getValue(key);
        }
        return value;
    }

    public Action getTargetAction() {
        return this.m_targetAction;
    }

    public final void setTargetAction(Action newTargetAction) {
        if (this.m_targetAction != null) {
            this.m_targetAction.removePropertyChangeListener(this);
        }
        this.m_targetAction = newTargetAction;
        if (this.m_targetAction != null) {
            this.m_targetAction.addPropertyChangeListener(this);
        }
        if (this.m_targetAction != null) {
            super.setEnabled(this.isEnabled());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.m_targetAction != null && evt.getSource() == this.m_targetAction && evt.getPropertyName().equals("enabled")) {
            super.setEnabled(this.isEnabled());
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.m_targetAction != null && this.m_targetAction.isEnabled()) {
            this.m_targetAction.actionPerformed(evt);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.m_targetAction != null ? this.m_targetAction.isEnabled() : super.isEnabled();
    }

    @Override
    public void setEnabled(boolean newValue) {
        if (this.m_targetAction != null) {
            this.m_targetAction.setEnabled(newValue);
        } else {
            super.setEnabled(newValue);
        }
    }

    public boolean isSelected() {
        return this.m_selected;
    }

    public void setSelected(boolean selected) {
        if (this.m_selected != selected) {
            boolean oldSelected = this.m_selected;
            this.m_selected = selected;
            this.firePropertyChange("selected", new Boolean(oldSelected), new Boolean(selected));
        }
    }

    public boolean canDisplay() {
        return true;
    }

    private void debugErrorOutput(String value) {
        if (MgmtConsole.DEVELOPER_MODE) {
            System.err.println(value);
        }
    }
}

