/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.ResourceManager;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.KeyStroke;

public class BasicResourceAction
extends BasicAction {
    private static final String ICON_LOCATION = "com/sonicsw/ma/gui/icons/";
    private static final String[] ACTION_KEYS = new String[]{"Name", "ShortDescription", "LongDescription", "MnemonicKey", "AcceleratorKey", "SmallIcon", "LargeIcon"};
    private static final String ACTION_PREFIX = "action";
    private static final String[] ACTION_KEY_TAGS = new String[]{"name", "short_description", "long_description", "mnemonic", "accelerator", "small_icon", "large_icon"};
    protected String m_resourceId = null;

    public BasicResourceAction() {
        this((String)null, (Action)null);
    }

    public BasicResourceAction(String resourceId, Action targetAction) {
        super(targetAction);
        this.m_resourceId = resourceId;
    }

    private Object getActionObject(String actionKey, String val) {
        Object res = val;
        if (actionKey.equals("AcceleratorKey")) {
            char accelerator = val.charAt(val.lastIndexOf("+") + 1);
            int modifiers = 0;
            StringTokenizer t = new StringTokenizer(val, "+");
            while (t.hasMoreTokens()) {
                String modifier = t.nextToken();
                if (modifier.equals("CTRL_MASK")) {
                    modifiers |= 2;
                    continue;
                }
                if (modifier.equals("SHIFT_MASK")) {
                    modifiers |= 1;
                    continue;
                }
                if (!modifier.equals("ALT_MASK")) continue;
                modifiers |= 8;
            }
            res = KeyStroke.getKeyStroke((int)accelerator, modifiers);
        } else if (actionKey.equals("MnemonicKey")) {
            res = new Integer(val.toCharArray()[0]);
        } else if (actionKey.equals("SmallIcon") || actionKey.equals("LargeIcon")) {
            res = ResourceManager.getIcon(this.getClass(), val);
        }
        return res;
    }

    @Override
    public Object getValue(String key) {
        Object res = null;
        if (key.equals("ActionCommandKey")) {
            if (this.m_resourceId != null) {
                return this.m_resourceId;
            }
            return super.getValue(key);
        }
        res = super.getValue(key);
        if (res == null && this.m_resourceId != null) {
            String tag = this.keyToTag(key);
            String id = new StringBuffer(ACTION_PREFIX).append('.').append(this.m_resourceId).append('.').append(tag).toString();
            String val = ResourceManager.getString(this.getClass(), id);
            if (val != null && val.length() > 0) {
                res = this.getActionObject(key, val);
            }
        }
        return res;
    }

    private String keyToTag(String key) {
        for (int i = 0; i < ACTION_KEYS.length; ++i) {
            if (!key.equals(ACTION_KEYS[i])) continue;
            return ACTION_KEY_TAGS[i];
        }
        return null;
    }
}

