/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;

public class ButtonActionPropertyChangeListener
implements PropertyChangeListener {
    private WeakReference target;
    private Action action;

    public ButtonActionPropertyChangeListener(JComponent c, Action a) {
        this.setTarget(c);
        this.action = a;
    }

    public final void setTarget(JComponent c) {
        OwnedWeakReference r;
        while ((r = (OwnedWeakReference)ReferenceQueueHolder.INSTANCE.poll()) != null) {
            ButtonActionPropertyChangeListener oldPCL = (ButtonActionPropertyChangeListener)r.getOwner();
            Action oldAction = oldPCL.getAction();
            if (oldAction == null) continue;
            oldAction.removePropertyChangeListener(oldPCL);
        }
        this.target = new OwnedWeakReference(c, ReferenceQueueHolder.INSTANCE, this);
    }

    public JComponent getTarget() {
        return (JComponent)this.target.get();
    }

    public Action getAction() {
        return this.action;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        AbstractButton button = (AbstractButton)this.getTarget();
        if (button == null) {
            Action action = (Action)e.getSource();
            action.removePropertyChangeListener(this);
        } else if (e.getPropertyName().equals("Name")) {
            Boolean hide = (Boolean)button.getClientProperty("hideActionText");
            if (hide == null || hide == Boolean.FALSE) {
                String text = (String)e.getNewValue();
                button.setText(text);
                button.repaint();
            }
        } else if (e.getPropertyName().equals("ShortDescription")) {
            String text = (String)e.getNewValue();
            button.setToolTipText(text);
        } else if (propertyName.equals("enabled")) {
            Boolean enabledState = (Boolean)e.getNewValue();
            button.setEnabled(enabledState);
            button.repaint();
        } else if (propertyName.equals("selected")) {
            Boolean selectedState = (Boolean)e.getNewValue();
            button.setSelected(selectedState);
            button.repaint();
        } else if (e.getPropertyName().equals("SmallIcon")) {
            Icon icon = (Icon)e.getNewValue();
            button.setIcon(icon);
            button.invalidate();
            button.repaint();
        } else if (e.getPropertyName().equals("MnemonicKey")) {
            Integer mn = (Integer)e.getNewValue();
            button.setMnemonic(mn);
            button.invalidate();
            button.repaint();
        } else if (e.getPropertyName().equals("ActionCommandKey")) {
            button.setActionCommand((String)e.getNewValue());
        }
    }

    private static class OwnedWeakReference
    extends WeakReference {
        private Object owner;

        OwnedWeakReference(Object target, ReferenceQueue queue, Object owner) {
            super(target, queue);
            this.owner = owner;
        }

        public Object getOwner() {
            return this.owner;
        }
    }

    private static class ReferenceQueueHolder {
        private static final ReferenceQueue INSTANCE = new ReferenceQueue();

        private ReferenceQueueHolder() {
        }
    }
}

