/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class ColorIcon
implements Icon {
    public static final ColorIcon GREEN = new ColorIcon(Color.green);
    public static final ColorIcon RED = new ColorIcon(Color.red);
    public static final ColorIcon BLUE = new ColorIcon(Color.blue);
    public static final ColorIcon YELLOW = new ColorIcon(Color.yellow);
    public static final ColorIcon ORANGE = new ColorIcon(Color.orange);
    private static final int BORDER = 0;
    private Color m_borderColor = Color.LIGHT_GRAY;
    private Color m_color;
    private int m_nWidth;
    private int m_nHeight;

    public ColorIcon(Color color) {
        this(color, 16);
    }

    public ColorIcon(Color color, int nSize) {
        this(color, nSize, nSize);
    }

    public ColorIcon(Color color, int nWidth, int nHeight) {
        this.setColor(color);
        this.m_nWidth = nWidth;
        this.m_nHeight = nHeight;
    }

    public Color getColor() {
        return this.m_color;
    }

    public final void setColor(Color color) {
        this.m_color = color;
    }

    public Color getBorderColor() {
        return this.m_borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.m_borderColor = borderColor;
    }

    @Override
    public int getIconHeight() {
        return this.m_nHeight;
    }

    @Override
    public int getIconWidth() {
        return this.m_nWidth;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.setColor(this.m_color);
        g.fillRect(x + 0, y + 0, this.getIconWidth() - 0, this.getIconHeight() - 0);
        g.setColor(this.m_borderColor);
        g.drawRect(x + 0, y + 0, this.getIconWidth() - 0, this.getIconHeight() - 0);
    }
}

