/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import java.awt.Color;
import java.text.MessageFormat;

public class ColorUtils {
    public static Color darken(int r, int g, int b, double percent) throws IllegalArgumentException {
        ColorUtils.checkValidPercent(percent);
        return new Color(Math.max((int)((double)r * (1.0 - percent)), 0), Math.max((int)((double)g * (1.0 - percent)), 0), Math.max((int)((double)b * (1.0 - percent)), 0));
    }

    public static Color darken(Color c, double percent) throws IllegalArgumentException {
        ColorUtils.checkValidPercent(percent);
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        return ColorUtils.darken(r, g, b, percent);
    }

    public static Color lighten(int r, int g, int b, double percent) throws IllegalArgumentException {
        ColorUtils.checkValidPercent(percent);
        int r2 = r + (int)((double)(255 - r) * percent);
        int g2 = g + (int)((double)(255 - g) * percent);
        int b2 = b + (int)((double)(255 - b) * percent);
        return new Color(r2, g2, b2);
    }

    public static Color lighten(Color c, double percent) throws IllegalArgumentException {
        ColorUtils.checkValidPercent(percent);
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        return ColorUtils.lighten(r, g, b, percent);
    }

    public static Color fade(Color from, Color to, double percent) throws IllegalArgumentException {
        ColorUtils.checkValidPercent(percent);
        int from_r = from.getRed();
        int from_g = from.getGreen();
        int from_b = from.getBlue();
        int to_r = to.getRed();
        int to_g = to.getGreen();
        int to_b = to.getBlue();
        int r = from_r > to_r ? to_r + (int)((double)(from_r - to_r) * (1.0 - percent)) : to_r - (int)((double)(to_r - from_r) * (1.0 - percent));
        int g = from_g > to_r ? to_g + (int)((double)(from_g - to_g) * (1.0 - percent)) : to_g - (int)((double)(to_g - from_g) * (1.0 - percent));
        int b = from_b > to_b ? to_b + (int)((double)(from_b - to_b) * (1.0 - percent)) : to_b - (int)((double)(to_b - from_b) * (1.0 - percent));
        return new Color(r, g, b);
    }

    public static double lightness(Color c) {
        if (c == null) {
            return 0.0;
        }
        double r = c.getRed();
        double g = c.getGreen();
        double b = c.getBlue();
        double max = Math.max(r, Math.max(g, b)) / 255.0 / 2.0;
        double min = Math.min(r, Math.min(g, b)) / 255.0 / 2.0;
        return max + min;
    }

    public static Color calculateHilightColor(Color c) {
        if (c == null) {
            return null;
        }
        double lightness = ColorUtils.lightness(c);
        if (lightness >= 0.9) {
            return ColorUtils.darken(c, 0.1);
        }
        if (lightness <= 0.2) {
            return ColorUtils.lighten(c, 0.6);
        }
        return ColorUtils.lighten(c, 0.6);
    }

    public static Color calculateShadowColor(Color c) {
        if (c == null) {
            return null;
        }
        double lightness = ColorUtils.lightness(c);
        if (lightness >= 0.9) {
            return ColorUtils.darken(c, 0.25);
        }
        if (lightness <= 0.2) {
            return ColorUtils.lighten(c, 0.2);
        }
        return ColorUtils.darken(c, 0.25);
    }

    private static void checkValidPercent(double percent) throws IllegalArgumentException {
        if (percent > 1.0 || percent < 0.0) {
            Object[] args = new Object[]{new Double(percent)};
            throw new IllegalArgumentException(MessageFormat.format("Invalid Percentage", args));
        }
    }
}

