/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.util.ComponentTrackerItem;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;

public class ComponentTracker {
    private static ComponentTracker instance = null;
    protected ArrayList m_list = new ArrayList();

    private ComponentTracker() {
    }

    protected ComponentTrackerItem findItem(Class componentClass, Object componentId) {
        ComponentTrackerItem item = null;
        Iterator i = this.m_list.iterator();
        while (i.hasNext() && item == null) {
            ComponentTrackerItem ctItem = (ComponentTrackerItem)i.next();
            if (!ctItem.getComponent().getClass().equals(componentClass) || !ctItem.getId().equals(componentId)) continue;
            item = ctItem;
        }
        return item;
    }

    protected ComponentTrackerItem setItem(Component component, Object id, Object data) {
        ComponentTrackerItem item = this.findItem(component.getClass(), id);
        if (item == null) {
            item = new ComponentTrackerItem(component, id, data);
            this.m_list.add(item);
        } else {
            item.setData(data);
        }
        return item;
    }

    protected ComponentTrackerItem removeItem(Class componentClass, Object componentId) {
        ComponentTrackerItem item = this.findItem(componentClass, componentId);
        if (item != null) {
            this.m_list.remove(item);
        }
        return item;
    }

    protected void removeAllItems(Class componentClass) {
        for (int i = this.m_list.size() - 1; i >= 0; --i) {
            ComponentTrackerItem item = (ComponentTrackerItem)this.m_list.get(i);
            Class<?> match = item.getComponent().getClass();
            if (componentClass != null && !componentClass.equals(match)) continue;
            this.m_list.remove(i);
        }
    }

    private static final synchronized ComponentTracker getInstance() {
        if (instance == null) {
            instance = new ComponentTracker();
        }
        return instance;
    }

    public static final ComponentTrackerItem find(Class componentClass, Object componentId) {
        return ComponentTracker.getInstance().findItem(componentClass, componentId);
    }

    public static final ComponentTrackerItem set(Component component, Object id, Object data) {
        return ComponentTracker.getInstance().setItem(component, id, data);
    }

    public static final ComponentTrackerItem set(Component component, Object id) {
        return ComponentTracker.set(component, id, null);
    }

    public static final ComponentTrackerItem remove(Class componentClass, Object componentId) {
        return ComponentTracker.getInstance().removeItem(componentClass, componentId);
    }

    protected void removeAll(Class componentClass) {
        ComponentTracker.getInstance().removeAllItems(componentClass);
    }

    protected void removeAll() {
        this.removeAll(null);
    }
}

