/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileFilter;

public class DefaultFileFilter
extends FileFilter {
    public static final DefaultFileFilter XML = new DefaultFileFilter("xml", "XML Files");
    private Set m_set;
    private String m_description;

    public DefaultFileFilter(String extension, String description) {
        this.m_set = new HashSet();
        StringTokenizer st = new StringTokenizer(extension, ";,");
        while (st.hasMoreTokens()) {
            this.m_set.add(st.nextToken());
        }
        this.m_description = st.countTokens() > 1 ? description + " (*." + extension + ")" : description;
    }

    public DefaultFileFilter(String[] extension, String description) {
        this.m_set = new HashSet();
        for (int i = 0; i < extension.length; ++i) {
            this.m_set.add(extension[i]);
        }
        this.m_description = description;
    }

    public DefaultFileFilter(Set set, String description) {
        this.m_set = Collections.unmodifiableSet(set);
        this.m_description = description;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String ext = f.toString().toLowerCase();
        int index = ext.lastIndexOf(46);
        if (index == -1) {
            return false;
        }
        ext = ext.substring(index + 1);
        return this.m_set.contains(ext);
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }
}

