/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.util.JPartitionPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class DescriptionPanel
extends JPanel {
    private static final String SEPARATOR = " - ";
    protected JLabel m_labelDescription = null;
    protected JLabel m_labelExtendedDescription = null;
    protected JLabel m_labelImage = null;
    protected Font m_fontDescription = new Font("Dialog", 1, 16);
    protected Font m_fontExtendedDescription = new Font("Dialog", 0, 16);

    public DescriptionPanel(String strDescription) {
        this(strDescription, Color.gray, Color.white);
    }

    public DescriptionPanel(String strDescription, Color color) {
        this(strDescription, color, Color.white);
    }

    public DescriptionPanel(String strDescription, Color color, Color colorText) {
        this.setupGUI(color, colorText);
        this.setText(strDescription);
    }

    public final void setText(String strDescription) {
        this.m_labelDescription.setText(strDescription);
    }

    public void setExtendedText(String strExtendedDescription) {
        if (strExtendedDescription != null && !strExtendedDescription.equals("")) {
            this.ensureDescriptionSeparator();
        } else {
            this.removeSeparator();
        }
        this.m_labelExtendedDescription.setText(strExtendedDescription);
        this.m_labelExtendedDescription.setToolTipText(strExtendedDescription);
    }

    public Font getDescriptionFont() {
        return this.m_fontDescription;
    }

    public void setDescriptionFont(Font fontDescription) {
        this.m_fontDescription = fontDescription;
    }

    public Font getExtendedDescriptionFont() {
        return this.m_fontExtendedDescription;
    }

    public void setExtendedDescriptionFont(Font fontExtendedDescription) {
        this.m_fontExtendedDescription = fontExtendedDescription;
    }

    public void setIcon(Icon icon) {
        this.m_labelImage.setIcon(icon);
    }

    public JLabel getDescriptionLabel() {
        return this.m_labelDescription;
    }

    protected void ensureDescriptionSeparator() {
        if (this.m_labelDescription != null && !this.m_labelDescription.getText().endsWith(SEPARATOR)) {
            this.m_labelDescription.setText(this.m_labelDescription.getText() + SEPARATOR);
        }
    }

    protected void removeSeparator() {
        if (this.m_labelDescription != null && this.m_labelDescription.getText().endsWith(SEPARATOR)) {
            String strText = this.m_labelDescription.getText().substring(0, this.m_labelDescription.getText().length() - SEPARATOR.length());
            this.m_labelDescription.setText(strText);
        }
    }

    private void setupGUI(Color color, Color colorText) {
        this.setLayout(new BorderLayout(0, 0));
        this.m_labelDescription = new JLabel();
        this.m_labelDescription.setFont(this.m_fontDescription);
        this.m_labelDescription.setBorder(new CompoundBorder(this.m_labelDescription.getBorder(), new EmptyBorder(0, JPartitionPanel.BORDER_SIZE, 0, 0)));
        this.m_labelDescription.setForeground(colorText);
        this.m_labelExtendedDescription = new JLabel();
        this.m_labelExtendedDescription.setFont(this.m_fontExtendedDescription);
        this.m_labelExtendedDescription.setBorder(new CompoundBorder(this.m_labelDescription.getBorder(), new EmptyBorder(0, 0, 0, JPartitionPanel.BORDER_SIZE)));
        this.m_labelExtendedDescription.setForeground(Color.white);
        this.m_labelExtendedDescription.setMinimumSize(new Dimension(0, this.m_labelExtendedDescription.getMinimumSize().height));
        JPanel panelLabel = new JPanel();
        panelLabel.setLayout(new BorderLayout(0, 0));
        panelLabel.add("West", this.m_labelDescription);
        panelLabel.add("Center", this.m_labelExtendedDescription);
        panelLabel.setBackground(color);
        panelLabel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.add("North", panelLabel);
        this.m_labelImage = new JLabel();
        this.m_labelImage.setBorder(new CompoundBorder(this.m_labelImage.getBorder(), new EmptyBorder(1, JPartitionPanel.BORDER_SIZE, 1, JPartitionPanel.BORDER_SIZE)));
        panelLabel.add("East", this.m_labelImage);
    }
}

