/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.BasicResourceAction;
import com.sonicsw.ma.gui.util.ExtendedImageIcon;
import com.sonicsw.ma.gui.util.ExtendedJButton;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;

public class EditableComponentPanel
extends JPanel {
    protected ExtendedJScrollPane m_scroller = null;
    protected JComponent m_component = null;
    protected JPanel m_panelButtons = null;
    protected JButton m_buttonAdd = null;
    protected JButton m_buttonRemove = null;
    protected JButton m_buttonEdit = null;
    protected Icon m_iconObject = null;
    protected boolean m_bAddAction = false;
    protected boolean m_bEditAction = false;
    protected boolean m_bRemoveAction = false;
    public static final int ICONS_AND_LABELS = 0;
    public static final int ICONS_ONLY = 1;
    public static final int LABELS_ONLY = 2;

    public EditableComponentPanel() {
        this(true, true, true);
    }

    public EditableComponentPanel(boolean bAdd, boolean bEdit, boolean bRemove) {
        this.m_bAddAction = bAdd;
        this.m_bEditAction = bEdit;
        this.m_bRemoveAction = bRemove;
    }

    public void setComponent(JComponent component) {
        this.m_component = component;
    }

    public final void setObjectIcon(Icon icon) {
        this.m_iconObject = icon;
    }

    @Override
    public void setEnabled(boolean bEnabled) {
        this.m_component.setEnabled(bEnabled);
        if (this.m_buttonAdd != null) {
            this.m_buttonAdd.setEnabled(bEnabled);
        }
        if (this.m_buttonRemove != null) {
            this.m_buttonRemove.setEnabled(bEnabled);
        }
        if (this.m_buttonEdit != null) {
            this.m_buttonEdit.setEnabled(bEnabled);
        }
        super.setEnabled(bEnabled);
    }

    protected void init(String nBorder, int nButtonStyle) {
        this.init(nBorder, true, nButtonStyle, true);
    }

    protected void init(String nBorder, boolean bCreateScroller, int nButtonStyle) {
        this.init(nBorder, bCreateScroller, nButtonStyle, true);
    }

    protected void init(String nBorder, int nButtonStyle, boolean bAutoEdit) {
        this.init(nBorder, true, nButtonStyle, bAutoEdit);
    }

    protected void init(String nBorder, boolean bCreateScroller, int nButtonStyle, boolean bAutoEdit) {
        this.setLayout(new BorderLayout());
        if (bCreateScroller) {
            this.m_scroller = new ExtendedJScrollPane(this.m_component);
            this.add((Component)this.m_scroller, "Center");
        } else {
            this.add((Component)this.m_component, "Center");
        }
        if (this.m_bAddAction || this.m_bEditAction || this.m_bRemoveAction) {
            if (this.m_bAddAction) {
                this.m_buttonAdd = this.addButton(new AddAction(), nBorder, nButtonStyle);
            }
            if (this.m_bEditAction) {
                this.m_buttonEdit = this.addButton(new EditAction(), nBorder, nButtonStyle);
            }
            if (this.m_bRemoveAction) {
                this.m_buttonRemove = this.addButton(new RemoveAction(), nBorder, nButtonStyle);
            }
            if (bAutoEdit && this.m_bEditAction) {
                this.m_component.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() == 2 && EditableComponentPanel.this.canEnableEdit()) {
                            EditableComponentPanel.this.onEdit();
                        }
                    }
                });
            }
            this.addButtons();
            Helper.equalize(this.m_panelButtons);
        }
    }

    protected void addButtons() {
    }

    protected void createButtonPanel(String nBorder) {
        if (this.m_panelButtons == null) {
            this.m_panelButtons = new JPanel();
            this.m_panelButtons.setBorder(new EmptyBorder(JPartitionPanel.BORDER_INSETS));
            this.add((Component)this.m_panelButtons, nBorder);
            if (nBorder == "East" || nBorder == "West") {
                this.m_panelButtons.setLayout(new BoxLayout(this.m_panelButtons, 1));
            } else {
                this.m_panelButtons.setLayout(new FlowLayout(2, 5, 5));
            }
        }
    }

    protected JButton addButton(BasicResourceAction a, String nBorder, int nButtonStyle) {
        this.createButtonPanel(nBorder);
        JButton button = null;
        if (a.canDisplay()) {
            button = this.addButton((Action)a, nBorder, nButtonStyle);
        }
        return button;
    }

    protected JButton addButton(Action a, String nBorder, int nButtonStyle) {
        this.createButtonPanel(nBorder);
        JButton button = this.createButton(a);
        this.addComponent(button, nBorder);
        if (nButtonStyle == 2) {
            button.setIcon(null);
        } else if (nButtonStyle == 1) {
            button.setText(null);
        }
        return button;
    }

    protected JButton createButton(Action a) {
        return new ExtendedJButton(a);
    }

    protected JToggleButton addToggleButton(Action a, String nBorder, int nButtonStyle) {
        JToggleButton button = new JToggleButton(a);
        this.addComponent(button, nBorder);
        if (nButtonStyle == 2) {
            button.setIcon(null);
        } else if (nButtonStyle == 1) {
            button.setText(null);
        }
        return button;
    }

    protected void addComponent(Component c, String nBorder) {
        if (this.m_panelButtons == null) {
            this.createButtonPanel(nBorder);
        }
        this.m_panelButtons.add(c);
        if (nBorder == "East" || nBorder == "West") {
            this.m_panelButtons.add(Box.createVerticalStrut(5));
        }
    }

    protected void setUIState() {
        if (this.m_bAddAction && this.m_buttonAdd != null) {
            if (this.m_buttonAdd.getAction() instanceof BasicResourceAction) {
                this.m_buttonAdd.setEnabled(((BasicResourceAction)this.m_buttonAdd.getAction()).isEnabled());
            } else {
                this.m_buttonAdd.setEnabled(this.canEnableAdd());
            }
        }
        if (this.m_bEditAction && this.m_buttonEdit != null) {
            if (this.m_buttonEdit.getAction() instanceof BasicResourceAction) {
                this.m_buttonEdit.setEnabled(((BasicResourceAction)this.m_buttonEdit.getAction()).isEnabled());
            } else {
                this.m_buttonEdit.setEnabled(this.canEnableEdit());
            }
        }
        if (this.m_bRemoveAction && this.m_buttonRemove != null) {
            if (this.m_buttonRemove.getAction() instanceof BasicResourceAction) {
                this.m_buttonRemove.setEnabled(((BasicResourceAction)this.m_buttonRemove.getAction()).isEnabled());
            } else {
                this.m_buttonRemove.setEnabled(this.canEnableRemove());
            }
        }
    }

    public JScrollPane getScroller() {
        return this.m_scroller;
    }

    public JComponent getComponent() {
        return this.m_component;
    }

    public JPanel getButtonPanel() {
        return this.m_panelButtons;
    }

    public JButton getAddButton() {
        return this.m_buttonAdd;
    }

    public JButton getEditButton() {
        return this.m_buttonEdit;
    }

    public JButton getRemoveButton() {
        return this.m_buttonRemove;
    }

    protected void onAdd() {
    }

    protected void onRemove() {
    }

    protected void onEdit() {
    }

    protected boolean canEnableAdd() {
        return true;
    }

    protected boolean canEnableEdit() {
        return true;
    }

    protected boolean canEnableRemove() {
        return true;
    }

    protected boolean canDisplayAdd() {
        return true;
    }

    protected boolean canDisplayEdit() {
        return true;
    }

    protected boolean canDisplayRemove() {
        return true;
    }

    class RemoveAction
    extends BasicGuiAction {
        public RemoveAction() {
            super("editable_component.remove");
            if (EditableComponentPanel.this.m_iconObject != null) {
                this.putSmallIconValue();
            }
        }

        private void putSmallIconValue() {
            this.putValue("SmallIcon", new ExtendedImageIcon(EditableComponentPanel.this.m_iconObject, ResourceManager.getIcon(this.getClass(), "deleteoverlay")));
        }

        @Override
        public boolean isEnabled() {
            return EditableComponentPanel.this.canEnableRemove();
        }

        @Override
        public boolean canDisplay() {
            return EditableComponentPanel.this.canDisplayRemove();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditableComponentPanel.this.onRemove();
            EditableComponentPanel.this.setUIState();
        }
    }

    class EditAction
    extends BasicGuiAction {
        public EditAction() {
            super("editable_component.edit");
            if (EditableComponentPanel.this.m_iconObject != null) {
                this.putSmallIconValue();
            }
        }

        private void putSmallIconValue() {
            this.putValue("SmallIcon", new ExtendedImageIcon(EditableComponentPanel.this.m_iconObject, ResourceManager.getIcon(this.getClass(), "editoverlay")));
        }

        @Override
        public boolean isEnabled() {
            return EditableComponentPanel.this.canEnableEdit();
        }

        @Override
        public boolean canDisplay() {
            return EditableComponentPanel.this.canDisplayEdit();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditableComponentPanel.this.onEdit();
            EditableComponentPanel.this.setUIState();
        }
    }

    class AddAction
    extends BasicGuiAction {
        public AddAction() {
            super("editable_component.add");
            if (EditableComponentPanel.this.m_iconObject != null) {
                this.putSmallIconValue();
            }
        }

        private void putSmallIconValue() {
            this.putValue("SmallIcon", new ExtendedImageIcon(EditableComponentPanel.this.m_iconObject, ResourceManager.getIcon(this.getClass(), "newoverlay")));
        }

        @Override
        public boolean isEnabled() {
            return EditableComponentPanel.this.canEnableAdd();
        }

        @Override
        public boolean canDisplay() {
            return EditableComponentPanel.this.canDisplayAdd();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditableComponentPanel.this.onAdd();
            EditableComponentPanel.this.setUIState();
        }
    }
}

