/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.Helper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ExtendedJTable
extends JTable {
    public ExtendedJTable() {
        this(null);
        this.commonInit();
    }

    public ExtendedJTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.commonInit();
    }

    public ExtendedJTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.commonInit();
    }

    public ExtendedJTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.commonInit();
    }

    public ExtendedJTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this.commonInit();
    }

    public ExtendedJTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.commonInit();
    }

    public ExtendedJTable(TableModel model) {
        super(model);
        this.commonInit();
    }

    public final void commonInit() {
        ToolTipManager.sharedInstance().registerComponent(this);
        this.getTableHeader().setDefaultRenderer(new ExtendedTableHeaderRenderer());
        this.setDefaultRenderer(Object.class, new ExtendedTableCellRenderer());
    }

    @Override
    public void setShowHorizontalLines(boolean state) {
        if (state) {
            this.setIntercellSpacing(new Dimension(1, this.getShowVerticalLines() ? 1 : 0));
        } else {
            this.setIntercellSpacing(new Dimension(0, this.getShowVerticalLines() ? 1 : 0));
        }
        super.setShowHorizontalLines(state);
    }

    @Override
    public void setShowVerticalLines(boolean state) {
        if (state) {
            this.setIntercellSpacing(new Dimension(this.getShowHorizontalLines() ? 1 : 0, 1));
        } else {
            this.setIntercellSpacing(new Dimension(this.getShowHorizontalLines() ? 1 : 0, 0));
        }
        super.setShowVerticalLines(state);
    }

    public void stopEditing() {
        if (this.getCellEditor() != null) {
            this.getCellEditor().stopCellEditing();
        }
    }

    public int getViewportWidth() {
        int nWidthTable = this.getSize().width;
        if (this.getScroller() != null) {
            nWidthTable = this.getScroller().getViewport().getWidth();
        }
        return nWidthTable;
    }

    public JScrollPane getScroller() {
        return (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
    }

    public void editingStarted() {
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if ((e == null || e.getFirstRow() == -1) && this.getAutoCreateColumnsFromModel()) {
            this.createDefaultColumnsFromModel();
            return;
        }
        this.resizeAndRepaint();
    }

    public boolean hasSelection() {
        return this.getSelectedRowCount() > 0 || this.getSelectedColumnCount() > 0;
    }

    public Color getBackgroundColorBySelectionState(boolean bSelected) {
        Color bg = UIManager.getColor("TextField.background");
        if (bSelected) {
            bg = !this.hasFocus() ? UIManager.getColor("ComboBox.disabledBackground") : UIManager.getColor("Tree.selectionBackground");
        }
        return bg;
    }

    public Color getForegroundColorBySelectionState(boolean bSelected) {
        Color fg = UIManager.getColor("Tree.textForeground");
        if (bSelected) {
            fg = !this.hasFocus() ? UIManager.getColor("Tree.textForeground") : UIManager.getColor("Tree.selectionForeground");
        }
        return fg;
    }

    @Override
    public boolean isEditing() {
        boolean bIsEditing = super.isEditing();
        return bIsEditing;
    }

    public int getNumberSelections() {
        int[] arRows = this.getSelectedRows();
        return arRows.length;
    }

    public static class ExtendedTableHeaderRenderer
    extends ExtendedTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (table != null && (header = table.getTableHeader()) != null) {
                ((JComponent)c).setForeground(header.getForeground());
                ((JComponent)c).setBackground(header.getBackground());
                ((JComponent)c).setFont(header.getFont());
            }
            this.setText(value == null ? "" : value.toString());
            ((JComponent)c).setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(10);
            return c;
        }
    }

    public static class ExtendedTableCellRenderer
    extends DefaultTableCellRenderer
    implements SwingConstants {
        private int m_gray = 0;

        public ExtendedTableCellRenderer(int nAlignment) {
            this.setCellHorizontalAlignment(nAlignment);
        }

        private void setCellHorizontalAlignment(int nAlignment) {
            this.setHorizontalAlignment(nAlignment);
        }

        public ExtendedTableCellRenderer() {
            this(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setGrayIcon(0);
            if (value != null) {
                Object clipboardObject;
                if (MgmtConsole.isInitialized() && MgmtConsole.getMgmtConsole().getClipboardAction() == 0 && (clipboardObject = MgmtConsole.getMgmtConsole().getClipboardObject()) != null && clipboardObject.equals(value)) {
                    this.setGrayIcon(40);
                }
                String strTip = null;
                strTip = value instanceof Date ? DateFormat.getDateTimeInstance().format((Date)value) : value.toString();
                this.setToolTipText(c, table, strTip, column);
            } else {
                ((JComponent)c).setToolTipText(null);
            }
            ((JComponent)c).setBackground(((ExtendedJTable)table).getBackgroundColorBySelectionState(table.isRowSelected(row)));
            ((JComponent)c).setForeground(((ExtendedJTable)table).getForegroundColorBySelectionState(table.isRowSelected(row)));
            return c;
        }

        public void setToolTipText(Component c, JTable table, String strText, int column) {
            int nIconWidth;
            int nStringWidth = SwingUtilities.computeStringWidth(table.getFontMetrics(table.getFont()), strText);
            int n = nIconWidth = this.getIcon() == null ? 0 : this.getIcon().getIconWidth();
            if (table.getColumnModel().getColumn(column).getWidth() < nStringWidth + nIconWidth) {
                if (strText != null && strText.length() > 0) {
                    ((JComponent)c).setToolTipText(Helper.formatToHTMLForWrapping(strText, 128));
                }
            } else {
                ((JComponent)c).setToolTipText(null);
            }
        }

        public void setGrayIcon(int percentage) {
            this.m_gray = percentage;
        }

        @Override
        public Icon getIcon() {
            try {
                Icon icon = super.getIcon();
                if (icon != null && this.m_gray > 0) {
                    icon = Helper.createDisabledIcon(icon, this.m_gray);
                }
                return icon;
            }
            catch (Exception e) {
                e.printStackTrace();
                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                return null;
            }
        }
    }
}

