/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.table.ModelListTableModel;
import com.sonicsw.ma.gui.util.IFilterable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.TableColumn;

public class FilterTableModel
extends ModelListTableModel {
    protected boolean m_bFilterIsActive;
    protected List m_listFilteredData = new ArrayList();

    public FilterTableModel(TableColumn[] tableColumns) {
        this(tableColumns, new ArrayList());
    }

    public FilterTableModel(TableColumn[] tableColumns, List contents) {
        this(tableColumns, contents, false);
    }

    public FilterTableModel(TableColumn[] tableColumns, List contents, boolean bFilterIsActive) {
        super(tableColumns, contents);
        this.m_bFilterIsActive = bFilterIsActive;
    }

    public void activateFilter(boolean bFilterIsActive) {
        this.m_bFilterIsActive = bFilterIsActive;
    }

    public boolean isFilterActivated() {
        return this.m_bFilterIsActive;
    }

    public boolean isFiltered(Object obj) {
        boolean bIsFilterable = obj instanceof IFilterable;
        return bIsFilterable ? !((IFilterable)obj).canDisplay(this) : false;
    }

    public void filterData(boolean bFilter) {
        if (this.isFilterActivated()) {
            if (bFilter) {
                for (Object obj : this.m_listView) {
                    if (!this.isFiltered(obj)) continue;
                    this.m_listFilteredData.add(obj);
                }
                Iterator iter = this.m_listFilteredData.iterator();
                while (iter.hasNext()) {
                    this.delete(iter.next());
                }
            } else {
                Iterator i = this.m_listFilteredData.iterator();
                while (i.hasNext()) {
                    this.addRow(i.next());
                }
                this.m_listFilteredData.clear();
            }
        }
        this.fireTableStructureChanged();
    }
}

