/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.FilterTreeNode;
import com.sonicsw.ma.gui.util.IFilterable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class FilterTreeModel
extends DefaultTreeModel {
    protected boolean m_bFilterIsActive;

    public FilterTreeModel(TreeNode root) {
        this(root, false);
    }

    public FilterTreeModel(TreeNode root, boolean asksAllowsChildren) {
        this(root, false, false);
    }

    public FilterTreeModel(TreeNode root, boolean asksAllowsChildren, boolean bFilterIsActive) {
        super(root, asksAllowsChildren);
        this.m_bFilterIsActive = bFilterIsActive;
    }

    public void activateFilter(boolean bFilterIsActive) {
        this.m_bFilterIsActive = bFilterIsActive;
    }

    public boolean isActivatedFilter() {
        return this.m_bFilterIsActive;
    }

    public boolean isNodeFiltered(Object node) {
        boolean bIsFilterable;
        boolean bl = bIsFilterable = node != null && node instanceof IFilterable;
        return bIsFilterable ? !((IFilterable)node).canDisplay(this) : false;
    }

    @Override
    public void nodeChanged(TreeNode node) {
        if (this.isActivatedFilter() && this.isNodeFiltered(node)) {
            return;
        }
        super.nodeChanged(node);
    }

    @Override
    public void nodesChanged(TreeNode node, int[] childIndices) {
        if (this.isActivatedFilter()) {
            if (this.isNodeFiltered(node)) {
                return;
            }
            super.nodesChanged(node, this.getUnfilteredChildInidicies(node, childIndices));
            return;
        }
        super.nodesChanged(node, childIndices);
    }

    @Override
    public void nodeStructureChanged(TreeNode node) {
        if (this.isActivatedFilter() && this.isNodeFiltered(node)) {
            return;
        }
        super.nodeStructureChanged(node);
    }

    @Override
    public void nodesWereInserted(TreeNode node, int[] childIndices) {
        if (this.isActivatedFilter()) {
            if (this.isNodeFiltered(node)) {
                return;
            }
            super.nodesWereInserted(node, this.getUnfilteredChildInidicies(node, childIndices));
            return;
        }
        super.nodesWereInserted(node, childIndices);
    }

    @Override
    public void nodesWereRemoved(TreeNode node, int[] childIndices, Object[] removedChildren) {
        if (this.isActivatedFilter() && this.isNodeFiltered(node)) {
            return;
        }
        super.nodesWereRemoved(node, childIndices, removedChildren);
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (this.isActivatedFilter() && parent instanceof FilterTreeNode) {
            return ((FilterTreeNode)parent).getChildAt(index, this.isActivatedFilter());
        }
        return ((TreeNode)parent).getChildAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        if (this.isActivatedFilter() && parent instanceof FilterTreeNode) {
            return ((FilterTreeNode)parent).getChildCount(this.isActivatedFilter());
        }
        return ((TreeNode)parent).getChildCount();
    }

    protected int[] getUnfilteredChildInidicies(TreeNode nodeParent, int[] childIndices) {
        ArrayList<Integer> listIndicies = new ArrayList<Integer>();
        for (int i = 0; i < childIndices.length; ++i) {
            TreeNode nodeChild = null;
            try {
                nodeChild = nodeParent instanceof FilterTreeNode ? ((FilterTreeNode)nodeParent).getChildAt(childIndices[i], this.isActivatedFilter()) : nodeParent.getChildAt(childIndices[i]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            }
            if (this.isNodeFiltered(nodeChild)) continue;
            listIndicies.add(new Integer(childIndices[i]));
        }
        int[] arIndicies = new int[listIndicies.size()];
        Iterator iter = listIndicies.iterator();
        int i = 0;
        while (iter.hasNext()) {
            arIndicies[i++] = (Integer)iter.next();
        }
        return arIndicies;
    }
}

