/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.util.IFilterable;
import java.text.Collator;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class FilterTreeNode
extends DefaultMutableTreeNode
implements IFilterable {
    protected boolean m_bCanDisplay;

    public FilterTreeNode() {
        this(null);
    }

    public FilterTreeNode(Object userObject) {
        this(userObject, true, true);
    }

    public FilterTreeNode(Object userObject, boolean allowsChildren, boolean bCanDisplay) {
        super(userObject, allowsChildren);
        this.m_bCanDisplay = bCanDisplay;
    }

    public int getInsertIndex(String childName) {
        for (int i = 0; i < super.getChildCount(); ++i) {
            TreeNode node = this.getChildAt(i);
            if (Collator.getInstance().compare(childName, node.toString()) > 0) continue;
            return i;
        }
        return super.getChildCount();
    }

    public TreeNode getChildAt(int nIndex, boolean bFilterIsActive) {
        if (!bFilterIsActive) {
            return super.getChildAt(nIndex);
        }
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }
        int nRealIndex = -1;
        int nVisibleIndex = -1;
        Enumeration en = this.children.elements();
        while (en.hasMoreElements()) {
            TreeNode node = (TreeNode)en.nextElement();
            if (node instanceof IFilterable) {
                IFilterable nodeFiltered = (IFilterable)((Object)node);
                if (nodeFiltered.canDisplay()) {
                    ++nVisibleIndex;
                }
            } else {
                ++nVisibleIndex;
            }
            ++nRealIndex;
            if (nVisibleIndex != nIndex) continue;
            return (TreeNode)this.children.elementAt(nRealIndex);
        }
        throw new ArrayIndexOutOfBoundsException("index unmatched: visible index = " + nVisibleIndex + ", index = " + nIndex);
    }

    public int getChildCount(boolean bFilterIsActive) {
        if (!bFilterIsActive) {
            return super.getChildCount();
        }
        if (this.children == null) {
            return 0;
        }
        int nCount = 0;
        Enumeration en = this.children.elements();
        while (en.hasMoreElements()) {
            TreeNode node = (TreeNode)en.nextElement();
            if (node instanceof IFilterable) {
                IFilterable nodeFiltered = (IFilterable)((Object)node);
                if (!nodeFiltered.canDisplay()) continue;
                ++nCount;
                continue;
            }
            ++nCount;
        }
        return nCount;
    }

    @Override
    public final void setDisplayable(boolean bCanDisplay) {
        this.m_bCanDisplay = bCanDisplay;
    }

    @Override
    public boolean canDisplay(Object objModel) {
        return this.m_bCanDisplay;
    }

    @Override
    public boolean canDisplay() {
        return this.m_bCanDisplay;
    }

    public int getVisibleChildIndex(TreeNode aNode) {
        int nRealIndex = -1;
        int nVisibleIndex = -1;
        Enumeration en = this.children.elements();
        while (en.hasMoreElements()) {
            TreeNode node = (TreeNode)en.nextElement();
            if (node instanceof IFilterable) {
                IFilterable nodeFiltered = (IFilterable)((Object)node);
                if (nodeFiltered.canDisplay()) {
                    ++nVisibleIndex;
                }
            } else {
                ++nVisibleIndex;
            }
            ++nRealIndex;
            if (!node.equals(aNode)) continue;
            return nVisibleIndex;
        }
        return -1;
    }
}

