/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.ExtendedJTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.FilteredImageSource;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;

public class Helper {
    private static final ThreadLocal<DateFormat> DATE_PARSER_THREAD_LOCAL = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return DateFormat.getDateTimeInstance();
        }
    };
    private static final String PROLOG = "<HTML>";
    private static final String EPILOG = "</HTML>";
    public static final String TIP_PROLOG = "<HTML><BODY><TABLE CELLPADDING=1>";
    public static final String TABLE_LEFT = "<tr><td><b>";
    public static final String TABLE_MID = "</b></td><td>";
    public static final String TABLE_RIGHT = "</td></tr>";
    public static final String FONT_STATUS_UP = "<FONT face=\"Arial\" SIZE=\"2\" color=\"#009966\">";
    public static final String FONT_STATUS_DOWN = "<FONT face=\"Arial\" SIZE=\"2\" color=\"#FF0000\">";
    public static final String FONT_END = "</font>";
    public static final String TIP_EPILOG = "</TABLE></BODY></HTML>";
    private static final ExecutorService threadPool = Executors.newCachedThreadPool();
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";

    public static final Icon createDisabledIcon(ImageIcon i, int percentage) {
        return Helper.createDisabledIcon((Icon)i, percentage);
    }

    public static final Icon createDisabledIcon(Icon i, int percentage) {
        Icon iconResult = i;
        if (i != null && i instanceof ImageIcon) {
            GrayFilter filter = new GrayFilter(true, percentage);
            FilteredImageSource prod = new FilteredImageSource(((ImageIcon)i).getImage().getSource(), filter);
            Image grayImage = Toolkit.getDefaultToolkit().createImage(prod);
            iconResult = new ImageIcon(grayImage);
        }
        return iconResult;
    }

    public static Logger getLogger() {
        return Logger.global;
    }

    public static void logDebugMessage(String strMessage) {
        if (Helper.getLogger().getLevel() == Level.ALL) {
            Helper.logInfoMessage(strMessage);
        }
    }

    public static void logInfoMessage(String strMessage) {
        Helper.getLogger().info(strMessage);
    }

    public static void logWarningMessage(String strMessage) {
        Helper.getLogger().warning(strMessage);
    }

    public static void logErrorMessage(String strMessage) {
        Helper.getLogger().severe(strMessage);
    }

    public static final AbstractButton getDescendentButtonWithAction(Container container, Action action) {
        AbstractButton res = null;
        if (container instanceof AbstractButton) {
            AbstractButton btn = (AbstractButton)container;
            if (btn.getAction() == action) {
                res = btn;
            }
        } else {
            for (int i = 0; i < container.getComponentCount() && (res = Helper.getDescendentButtonWithAction((Container)container.getComponent(i), action)) == null; ++i) {
            }
        }
        return res;
    }

    public static Container getDescendentNamed(String name, Container comp) {
        Container res = null;
        if (comp.getName() != null && comp.getName().equalsIgnoreCase(name)) {
            res = comp;
        } else {
            for (int i = 0; i < comp.getComponentCount() && (res = Helper.getDescendentNamed(name, (Container)comp.getComponent(i))) == null; ++i) {
            }
        }
        return res;
    }

    public static Container getDescendentClass(Class compClass, Container comp) {
        Container res = null;
        if (comp.getClass().equals(compClass)) {
            res = comp;
        } else {
            for (int i = 0; i < comp.getComponentCount() && (res = Helper.getDescendentClass(compClass, (Container)comp.getComponent(i))) == null; ++i) {
            }
        }
        return res;
    }

    public static final String arrayToString(String[] array) {
        StringBuffer sb = new StringBuffer();
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    sb.append(";");
                }
                sb.append(array[i]);
            }
        }
        return sb.toString();
    }

    public static final String[] stringToArray(String value) {
        StringTokenizer st = new StringTokenizer(value == null ? "" : value, ";");
        ArrayList<String> list = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    public static JComponent[] combineMenu(JComponent[] array1, JComponent[] array2, boolean useSeparator) {
        int i;
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        if (array1 != null) {
            for (i = 0; i < array1.length; ++i) {
                list.add(array1[i]);
            }
        }
        if (useSeparator) {
            list.add(new JSeparator());
        }
        if (array2 != null) {
            for (i = 0; i < array2.length; ++i) {
                list.add(array2[i]);
            }
        }
        return list.toArray(new JComponent[list.size()]);
    }

    public static Point getPopupMenuOrigin(JComponent origin, JComponent popupMenu) {
        Dimension screenSize;
        int x = 0;
        int y = 0;
        Dimension s = origin.getSize();
        Dimension pmSize = popupMenu.getSize();
        if (pmSize.width == 0) {
            pmSize = popupMenu.getPreferredSize();
        }
        Point position = origin.getLocationOnScreen();
        GraphicsConfiguration gc = origin.getGraphicsConfiguration();
        if (gc == null) {
            screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        } else {
            Rectangle sBounds = gc.getBounds();
            screenSize = sBounds.getSize();
            position.x -= sBounds.x;
            position.y -= sBounds.y;
        }
        Container parent = origin.getParent();
        if (parent instanceof JPopupMenu) {
            int xOffset = UIManager.getInt("Menu.submenuPopupOffsetX");
            int yOffset = UIManager.getInt("Menu.submenuPopupOffsetY");
            if (origin.getComponentOrientation().isLeftToRight()) {
                x = s.width + xOffset;
                if (position.x + x + pmSize.width >= screenSize.width && screenSize.width - s.width < 2 * position.x) {
                    x = 0 - xOffset - pmSize.width;
                }
            } else {
                x = 0 - xOffset - pmSize.width;
                if (position.x + x < 0 && screenSize.width - s.width > 2 * position.x) {
                    x = s.width + xOffset;
                }
            }
            if (position.y + (y = yOffset) + pmSize.height >= screenSize.height && screenSize.height - s.height < 2 * position.y) {
                y = s.height - yOffset - pmSize.height;
            }
        } else {
            int xOffset = UIManager.getInt("Menu.menuPopupOffsetX");
            int yOffset = UIManager.getInt("Menu.menuPopupOffsetY");
            if (origin.getComponentOrientation().isLeftToRight()) {
                x = xOffset;
                if (position.x + x + pmSize.width >= screenSize.width && screenSize.width - s.width < 2 * position.x) {
                    x = s.width - xOffset - pmSize.width;
                }
            } else {
                x = s.width - xOffset - pmSize.width;
                if (position.x + x < 0 && screenSize.width - s.width > 2 * position.x) {
                    x = xOffset;
                }
            }
            if (position.y + (y = s.height + yOffset) + pmSize.height >= screenSize.height && screenSize.height - s.height < 2 * position.y) {
                y = 0 - yOffset - pmSize.height;
            }
        }
        return new Point(x, y);
    }

    public static final void configurePropertiesFromAction(AbstractButton btn, Action a, String[] types) {
        if (types == null) {
            String[] alltypes = new String[]{"MnemonicKey", "Name", "ShortDescription", "SmallIcon", "ActionCommandKey", "enabled"};
            types = alltypes;
        }
        for (int i = 0; i < types.length; ++i) {
            String type = types[i];
            if (type == null) continue;
            if (type.equals("MnemonicKey")) {
                Integer n = a == null ? null : (Integer)a.getValue(type);
                btn.setMnemonic(n == null ? 0 : n);
                continue;
            }
            if (type.equals("Name")) {
                btn.setText(a != null ? (String)a.getValue(type) : null);
                continue;
            }
            if (type.equals("ShortDescription")) {
                btn.setToolTipText(a != null ? (String)a.getValue(type) : null);
                continue;
            }
            if (type.equals("SmallIcon")) {
                btn.setIcon(a != null ? (Icon)a.getValue(type) : null);
                continue;
            }
            if (type.equals("ActionCommandKey")) {
                btn.setActionCommand(a != null ? (String)a.getValue(type) : null);
                continue;
            }
            if (type.equals("AcceleratorKey")) {
                KeyStroke ks;
                KeyStroke keyStroke = ks = a == null ? null : (KeyStroke)a.getValue(type);
                if (!(btn instanceof JMenuItem) || btn instanceof JMenu) continue;
                ((JMenuItem)btn).setAccelerator(ks == null ? null : ks);
                continue;
            }
            if (!type.equals("enabled")) continue;
            btn.setEnabled(a != null ? a.isEnabled() : true);
        }
    }

    public static final String getDateTimeString(Long value) {
        return Helper.getDateTimeString(value, "n/a");
    }

    public static final String getDateTimeString(Long value, String defValue) {
        if (value == null || value == 0L || value == -1L) {
            return defValue;
        }
        return DATE_PARSER_THREAD_LOCAL.get().format(value);
    }

    public static final TableCellRenderer getDateTimeTableCellRenderer() {
        return TableCellRendererHolder.INSTANCE;
    }

    public static GridBagConstraints setConstraints(GridBagConstraints gbc, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill) {
        return Helper.setConstraints(gbc, gridx, gridy, gridwidth, gridheight, weightx, weighty, anchor, fill, gbc.insets, gbc.ipadx, gbc.ipady);
    }

    public static GridBagConstraints setConstraints(GridBagConstraints gbc, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets, int ipadx, int ipady) {
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridwidth = gridwidth;
        gbc.gridheight = gridheight;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.anchor = anchor;
        gbc.fill = fill;
        gbc.insets = insets;
        gbc.ipadx = ipadx;
        gbc.ipady = ipady;
        return gbc;
    }

    public static String toHtml(String sText) {
        StringBuffer sbValue = new StringBuffer();
        sbValue.append(PROLOG);
        sbValue.append(sText);
        sbValue.append(EPILOG);
        return sbValue.toString();
    }

    public static Frame getFrame(Component c) {
        Component frame;
        if (c == null) {
            return null;
        }
        Component component = frame = c == null ? null : c;
        while (frame != null && !(frame instanceof Frame)) {
            frame = frame.getParent();
        }
        return (Frame)frame;
    }

    public static JFrame getJFrame(Component c) {
        Component frame;
        if (c == null) {
            return null;
        }
        Component component = frame = c == null ? null : c;
        while (frame != null && !(frame instanceof JFrame)) {
            frame = frame.getParent();
        }
        return (JFrame)frame;
    }

    public static Window getWindow(Component c) {
        Component frame;
        if (c == null) {
            return null;
        }
        Component component = frame = c == null ? null : c;
        while (frame != null && !(frame instanceof Window)) {
            frame = frame.getParent();
        }
        return (Window)frame;
    }

    public static JDialog getJDialog(Component c) {
        Component dialog = c;
        while ((dialog = dialog.getParent()) != null && !(dialog instanceof JDialog)) {
        }
        return (JDialog)dialog;
    }

    public static Dialog getDialog(Component c) {
        if (c == null) {
            return null;
        }
        Component dialog = c;
        while ((dialog = dialog.getParent()) != null && !(dialog instanceof Dialog)) {
        }
        return (Dialog)dialog;
    }

    public static String getTitle(Component c) {
        Component frame;
        if (c == null) {
            return "";
        }
        Component component = frame = c == null ? null : c;
        while (frame != null && !(frame instanceof Frame) && !(frame instanceof Dialog)) {
            frame = frame.getParent();
        }
        if (frame == null) {
            return c.getName() == null ? "" : c.getName();
        }
        if (frame instanceof Frame) {
            return ((Frame)frame).getTitle();
        }
        return ((Dialog)frame).getTitle();
    }

    public static void enableTextComponent(JTextComponent t, boolean bEnable) {
        t.setEditable(bEnable);
        if (bEnable) {
            t.setBackground(UIManager.getColor("TextField.background"));
        } else {
            t.setBackground(UIManager.getColor("Label.background"));
        }
    }

    public static void equalizeByClass(Container c) {
        Component[] aComponents = c.getComponents();
        int ns = aComponents.length;
        HashMap map = new HashMap();
        for (int n = 0; n < ns; ++n) {
            ArrayList<Component> a;
            if (aComponents[n] instanceof JLabel && ((JLabel)aComponents[n]).getLabelFor() != null) continue;
            Object array = map.get(aComponents[n].getClass());
            if (array == null) {
                a = new ArrayList<Component>();
                a.add(aComponents[n]);
                map.put(aComponents[n].getClass(), a);
                continue;
            }
            a = (ArrayList<Component>)array;
            a.add(aComponents[n]);
        }
        for (ArrayList a : map.values()) {
            Helper.equalize(a);
        }
        c.doLayout();
    }

    public static void equalize(Container c) {
        Helper.equalize(c.getComponents());
        c.doLayout();
    }

    public static void equalize(Component[] components) {
        Dimension d;
        int nComponent;
        int nPreferredWidth = 0;
        int nComponents = components.length;
        for (nComponent = 0; nComponent < nComponents; ++nComponent) {
            d = components[nComponent].getPreferredSize();
            if (!(d.getWidth() > (double)nPreferredWidth)) continue;
            nPreferredWidth = (int)d.getWidth();
        }
        for (nComponent = 0; nComponent < nComponents; ++nComponent) {
            d = components[nComponent].getPreferredSize();
            Dimension dNew = new Dimension(nPreferredWidth, (int)d.getHeight());
            Helper.sizeComponent(components[nComponent], dNew);
        }
    }

    public static void equalize(ArrayList components) {
        Dimension d;
        int nComponent;
        int nPreferredWidth = 0;
        int nComponents = components.size();
        for (nComponent = 0; nComponent < nComponents; ++nComponent) {
            d = ((Component)components.get(nComponent)).getPreferredSize();
            if (!(d.getWidth() > (double)nPreferredWidth)) continue;
            nPreferredWidth = (int)d.getWidth();
        }
        for (nComponent = 0; nComponent < nComponents; ++nComponent) {
            d = ((Component)components.get(nComponent)).getPreferredSize();
            Dimension dNew = new Dimension(nPreferredWidth, (int)d.getHeight());
            Helper.sizeComponent((Component)components.get(nComponent), dNew);
        }
    }

    public static void sizeComponent(Component c, Dimension d) {
        if (c instanceof JComponent) {
            JComponent j = (JComponent)c;
            j.setPreferredSize(d);
            j.setMinimumSize(d);
            j.setMaximumSize(d);
        } else {
            c.setSize(d);
        }
    }

    public static void equalize(Component c1, Component c2) {
        Dimension d1 = c1.getPreferredSize();
        Dimension d2 = c2.getPreferredSize();
        int nPreferredWidth = Math.max(d1.width, d2.width);
        Helper.sizeComponent(c1, new Dimension(nPreferredWidth, d1.height));
        Helper.sizeComponent(c2, new Dimension(nPreferredWidth, d2.height));
    }

    public static JLabel getLabelFor(Container c, Component comp) {
        Component[] aComponents = c.getComponents();
        for (int n = 0; n < aComponents.length; ++n) {
            Component comp1 = aComponents[n];
            if (!(comp1 instanceof JLabel) || ((JLabel)comp1).getLabelFor() != comp) continue;
            return (JLabel)comp1;
        }
        return null;
    }

    public static void invoke(Runnable r, boolean bWait) {
        try {
            if (bWait) {
                if (SwingUtilities.isEventDispatchThread()) {
                    r.run();
                } else {
                    SwingUtilities.invokeAndWait(r);
                }
            } else {
                SwingUtilities.invokeLater(r);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            MgmtConsole.getMgmtConsole().notifyMessage(64, ex.getMessage(), ex, false);
        }
    }

    public static void invoke(Runnable r) {
        Helper.invoke(r, false);
    }

    public static void asyncExec(Runnable r) {
        threadPool.execute(r);
    }

    public static String formatToHTMLForWrapping(String strInput, int nMaxWidth) {
        StringBuffer sbOutput = new StringBuffer();
        if (strInput.length() > nMaxWidth) {
            StringBuffer sbTemp = new StringBuffer();
            StringTokenizer st = new StringTokenizer(strInput, " ");
            while (st.hasMoreTokens()) {
                String strToken = st.nextToken();
                if (sbTemp.length() + strToken.length() > nMaxWidth) {
                    sbTemp.append("<BR>");
                    sbOutput.append(sbTemp.toString());
                    sbTemp = new StringBuffer();
                }
                if (sbTemp.length() != 0) {
                    sbTemp.append(" ");
                }
                sbTemp.append(strToken);
            }
            if (sbTemp.length() > 0) {
                sbOutput.append(sbTemp.toString());
            }
        } else {
            sbOutput.append(strInput);
        }
        return Helper.toHtml(sbOutput.toString());
    }

    public static final void displayURL(String url) {
        boolean windows = Helper.isWindowsPlatform();
        String[] cmd = null;
        cmd = windows ? new String[]{WIN_PATH, WIN_FLAG, url} : new String[]{UNIX_PATH, "-remote openURL(" + url + ")"};
        try {
            Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
        }
    }

    public static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith("Windows");
    }

    static class DateTimeTableCellRenderer
    extends ExtendedJTable.ExtendedTableCellRenderer {
        public DateTimeTableCellRenderer() {
            this.setHorizontalAlignment();
        }

        private void setHorizontalAlignment() {
            this.setHorizontalAlignment(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String stringValue = null;
            try {
                stringValue = Helper.getDateTimeString((Long)value);
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            }
            return super.getTableCellRendererComponent(table, stringValue, isSelected, hasFocus, row, column);
        }
    }

    private static class TableCellRendererHolder {
        private static final TableCellRenderer INSTANCE = new DateTimeTableCellRenderer();

        private TableCellRendererHolder() {
        }
    }
}

