/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Stack;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ImageOverlayIcon
extends ImageIcon {
    protected int m_nHeight = 0;
    protected int m_nWidth = 0;
    protected Stack m_icons = new Stack();
    protected Image m_image;

    public ImageOverlayIcon(Icon icon) {
        this.addOverlay(icon);
    }

    public ImageOverlayIcon(Icon iconBase, Icon iconOverlay) {
        this.addOverlay(iconBase);
        this.addOverlay(iconOverlay);
    }

    public ImageOverlayIcon(List icons) {
        int nIcons = icons.size();
        for (int nIcon = 0; nIcon < nIcons; ++nIcon) {
            this.addOverlay((Icon)icons.get(nIcon));
        }
    }

    public final void addOverlay(Icon icon) {
        if (icon != null) {
            int nWidth = icon.getIconWidth();
            int nHeight = icon.getIconWidth();
            this.m_nHeight = Math.max(this.m_nHeight, nHeight);
            this.m_nWidth = Math.max(this.m_nWidth, nWidth);
            this.m_icons.push(icon);
            this.m_image = null;
        }
    }

    @Override
    public int getIconWidth() {
        return this.m_nWidth;
    }

    @Override
    public int getIconHeight() {
        return this.m_nHeight;
    }

    public int getOverlayCount() {
        return this.m_icons.size();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int nX, int nY) {
        for (Icon icon : this.m_icons) {
            icon.paintIcon(c, g, nX, nY);
        }
    }

    @Override
    public Image getImage() {
        if (this.m_image == null) {
            this.m_image = ImageOverlayIcon.createImage(this, component);
        }
        return this.m_image;
    }

    public static Image createImage(Icon icon) {
        return ImageOverlayIcon.createImage(icon, null);
    }

    public static Image createImage(Icon icon, Component c) {
        if (icon == null) {
            return null;
        }
        BufferedImage imageCopy = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics g = imageCopy.getGraphics();
        icon.paintIcon(c, g, 0, 0);
        return imageCopy;
    }
}

