/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.gui.util.ResourceManager;
import java.awt.Component;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class JBasicMenu
extends JMenu
implements MenuListener {
    private MouseListener m_mouseListener;

    public JBasicMenu(BasicAction action) {
        super(action);
        this.addMenuListener();
    }

    private void addMenuListener() {
        this.addMenuListener(this);
    }

    public void add(BasicAction action) {
        if (!action.canDisplay()) {
            return;
        }
        this.add(new JBasicMenuItem(action));
    }

    @Override
    public Icon getIcon() {
        Icon icon = super.getIcon();
        if (!(this.getParent() instanceof JMenuBar)) {
            icon = ResourceManager.getIcon(this.getClass(), "blank");
        }
        return icon;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    public void setToolTipText() {
    }

    @Override
    protected void configurePropertiesFromAction(Action a) {
        String[] types = new String[]{"MnemonicKey", "Name", "AcceleratorKey", "enabled"};
        Helper.configurePropertiesFromAction(this, a, types);
    }

    @Override
    public void menuCanceled(MenuEvent evt) {
    }

    @Override
    public void menuDeselected(MenuEvent evt) {
    }

    @Override
    public void menuSelected(MenuEvent evt) {
        for (int i = 0; i < this.getMenuComponentCount(); ++i) {
            Action action;
            Component item = this.getMenuComponent(i);
            if (!(item instanceof AbstractButton) || (action = ((AbstractButton)item).getAction()) == null) continue;
            item.setEnabled(action.isEnabled());
        }
        if (this.m_mouseListener != null) {
            this.registerMouseListener();
        }
    }

    public void setMouseListener(MouseListener mouseListener) {
        this.m_mouseListener = mouseListener;
    }

    protected void registerMouseListener() {
        this.registerMouseListener(this);
    }

    private void registerMouseListener(JMenu menu) {
        menu.addMouseListener(this.m_mouseListener);
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem item = menu.getItem(i);
            if (item == null) continue;
            if (item instanceof JMenu) {
                this.registerMouseListener((JMenu)item);
                continue;
            }
            item.removeMouseListener(this.m_mouseListener);
            item.addMouseListener(this.m_mouseListener);
        }
    }
}

