/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.util.JBasicButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import modelobjects.layout.PartitionLayout;

public class JButtonPanel
extends JPanel {
    private static final String REF_REMAINDER = "_remainder";
    protected ArrayList m_list;

    public JButtonPanel() {
        this(false);
    }

    public JButtonPanel(boolean vertical) {
        this(vertical, 5, 5, 5);
    }

    public JButtonPanel(boolean vertical, int gapSize, int tbEdgeGap, int lrEdgeGap) {
        this.setButtonPanelLayout(vertical, gapSize, tbEdgeGap, lrEdgeGap);
        this.m_list = new ArrayList();
    }

    private void setButtonPanelLayout(boolean vertical, int gapSize, int tbEdgeGap, int lrEdgeGap) {
        this.setLayout(new PartitionLayout(vertical, "", gapSize, tbEdgeGap, lrEdgeGap, this.getClass().getName()));
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        String name = "unknown";
        if (comp instanceof JButton) {
            JButton btn = (JButton)comp;
            name = btn.getActionCommand();
            if (name == null || name.trim().length() == 0) {
                name = (String)btn.getAction().getValue("Name");
            }
        } else if (comp instanceof JSeparator) {
            name = "separator";
        } else if (comp instanceof JRemainderPanel) {
            name = REF_REMAINDER;
        }
        this.m_list.add(new ButtonPanelItem(name, (Container)comp));
        this.updatePartitionSpecs();
        super.addImpl(comp, constraints, index);
    }

    public void addSeparator(int orientation) {
        JSeparator sep = new JSeparator(orientation);
        this.add(new JSeparator(orientation));
    }

    public void addSeparator() {
        this.addSeparator(((PartitionLayout)this.getLayout()).isVertical() ? 0 : 1);
    }

    public void addButton(String actionCommand) {
        JButton btn = new JButton(actionCommand);
        btn.setActionCommand(actionCommand);
        this.add(btn);
    }

    public void addButton(Action action) {
        this.add(new JBasicButton(action));
    }

    public void addButton(String[] actionCommand) {
        for (int i = 0; i < actionCommand.length; ++i) {
            this.addButton(actionCommand[i]);
        }
    }

    public void addRemainder() {
        this.add(new JRemainderPanel());
    }

    public Action getAction(String actionCmd) {
        return this.getAction("ActionCommandKey", actionCmd);
    }

    public Action getAction(String actionKey, Object actionValue) {
        JButton button = this.getButton(actionKey, actionValue);
        return button != null ? button.getAction() : null;
    }

    public JButton getButton(String actionCmd) {
        return this.getButton("ActionCommandKey", actionCmd);
    }

    public JButton getButton(String actionKey, Object actionValue) {
        JButton res = null;
        Iterator i = this.m_list.iterator();
        while (i.hasNext() && res == null) {
            Object value;
            Action action;
            ButtonPanelItem item = (ButtonPanelItem)i.next();
            if (item.getContainer() == null || !(item.getContainer() instanceof JButton) || (action = ((JButton)item.getContainer()).getAction()) == null || (value = action.getValue(actionKey)) == null || !value.equals(actionValue)) continue;
            res = (JButton)item.getContainer();
        }
        return res;
    }

    public JButton getButton(Class buttonClass) {
        if (!JButton.class.isAssignableFrom(buttonClass)) {
            return null;
        }
        for (ButtonPanelItem item : this.m_list) {
            if (!(item.getContainer() instanceof JButton) || !item.getContainer().getClass().equals(buttonClass)) continue;
            return (JButton)item.getContainer();
        }
        return null;
    }

    protected void updatePartitionSpecs() {
        PartitionLayout layout = (PartitionLayout)this.getLayout();
        int[] specs = new int[this.m_list.size()];
        for (int i = 0; i < this.m_list.size(); ++i) {
            ButtonPanelItem item = (ButtonPanelItem)this.m_list.get(i);
            String ref = item.getName();
            specs[i] = ref != null && ref.equals(REF_REMAINDER) ? -1 : -2;
        }
        layout.setPartitionSpecs(specs);
    }

    public static void main(String[] arg) {
        JButtonPanel panel = new JButtonPanel(true);
        panel.addButton("Hello");
        panel.addButton("Good-bye");
        panel.addSeparator();
        panel.addButton("test");
        panel.add(new JLabel("This is a little label!"));
        panel.addButton("The End");
        panel.addRemainder();
        panel.addButton("Fini");
        JFrame frame = new JFrame("Button Panel Test");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        frame.getContentPane().add((Component)panel, "Center");
        frame.pack();
        frame.setVisible(true);
    }

    class JRemainderPanel
    extends JPanel {
        JRemainderPanel() {
        }
    }

    class ButtonPanelItem {
        protected String name;
        protected Container c;

        public ButtonPanelItem(String name, Container c) {
            this.name = name;
            this.c = c;
        }

        public String getName() {
            return this.name;
        }

        public Container getContainer() {
            return this.c;
        }
    }
}

