/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.JBasicCheckBoxMenuItem;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.gui.util.JButtonPanel;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JMAInternalFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.ResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultDesktopManager;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DesktopManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JMADesktopPane
extends JDesktopPane
implements ComponentListener,
ContainerListener,
Scrollable {
    private static final int LAYOUT_NONE = 0;
    private static final int LAYOUT_CASCADE = 1;
    private static final int LAYOUT_TILE_HORIZONTAL = 2;
    private static final int LAYOUT_TILE_VERTICAL = 3;
    private static final int DEFAULT_OFFSETX = 24;
    private static final int DEFAULT_OFFSETY = 24;
    private JScrollPane m_scrollpane;
    private int nextX;
    private int nextY;
    private int currentLayoutSetting = 0;
    private boolean recomputeSizeInhibited = false;
    private ArrayList internalFrames;
    private JMenu m_menuWindow;
    private Vector m_fileList = new Vector();
    private TileHorizontalAction m_tileHorizontalAction;
    private TileVerticalAction m_tileVerticalAction;
    private CascadeAction m_cascadeAction;
    private InternalFramesWatcher internalFramesWatcher;

    public JMADesktopPane() {
        this.prepareDesktopPane();
    }

    private void prepareDesktopPane() {
        this.addContainerListener(this);
        this.internalFrames = new ArrayList();
        this.setBackground((Color)Toolkit.getDefaultToolkit().getDesktopProperty("win.mdi.backgroundColor"));
        this.m_menuWindow = new JMenu("Window"){

            @Override
            public JMenuItem add(JMenuItem menuItem) {
                if (this.getItemCount() < 14) {
                    if (this.getItemCount() == 3) {
                        this.addSeparator();
                    }
                    if (menuItem.getAction() != null) {
                        if (menuItem.getAction() instanceof OpenInternalFrameAction) {
                            OpenInternalFrameAction action = (OpenInternalFrameAction)menuItem.getAction();
                            JBasicCheckBoxMenuItem checkBoxMenuItem = new JBasicCheckBoxMenuItem(action);
                            checkBoxMenuItem.setUserObject(action.getInternalFrame());
                            checkBoxMenuItem.setIcon(action.getInternalFrame().getFrameIcon());
                            checkBoxMenuItem.addItemListener(new ItemListener(){

                                @Override
                                public void itemStateChanged(ItemEvent event) {
                                    JBasicCheckBoxMenuItem menuItem = (JBasicCheckBoxMenuItem)event.getItem();
                                    JInternalFrame frame = (JInternalFrame)menuItem.getUserObject();
                                    if (frame.isSelected() && event.getStateChange() == 2) {
                                        menuItem.setSelected(true);
                                    }
                                }
                            });
                            JMADesktopPane.this.m_fileList.add(checkBoxMenuItem);
                            return super.add(checkBoxMenuItem);
                        }
                        return super.add(menuItem);
                    }
                    return super.add(menuItem);
                }
                OpenInternalFrameAction action = (OpenInternalFrameAction)menuItem.getAction();
                JBasicCheckBoxMenuItem checkBoxMenuItem = new JBasicCheckBoxMenuItem(action);
                checkBoxMenuItem.setUserObject(action.getInternalFrame());
                checkBoxMenuItem.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent event) {
                        JBasicCheckBoxMenuItem menuItem = (JBasicCheckBoxMenuItem)event.getItem();
                        JInternalFrame frame = (JInternalFrame)menuItem.getUserObject();
                        if (frame.isSelected() && event.getStateChange() == 2) {
                            menuItem.setSelected(true);
                        }
                    }
                });
                JMADesktopPane.this.m_fileList.add(checkBoxMenuItem);
                if (this.getItemCount() == 14) {
                    return super.add(new JBasicMenuItem(new WindowFileListAction()));
                }
                return null;
            }

            @Override
            public void remove(JMenuItem menuItem) {
                block6: {
                    block5: {
                        if (this.isMenuComponent(menuItem)) {
                            super.remove(menuItem);
                        }
                        JMADesktopPane.this.m_fileList.remove(menuItem);
                        if (JMADesktopPane.this.m_fileList.size() != 10 && this.getMenuComponents().length >= 15) break block5;
                        Component[] components = this.getMenuComponents();
                        for (int i = 0; i < components.length; ++i) {
                            String key;
                            if (components[i] instanceof JPopupMenu.Separator || components[i] instanceof JBasicCheckBoxMenuItem) {
                                super.remove(components[i]);
                                continue;
                            }
                            Action action = ((JMenuItem)components[i]).getAction();
                            if (action == null || (key = (String)action.getValue("ActionCommandKey")) == null || !key.equals("JMADesktopPane.WindowFileList")) continue;
                            super.remove(components[i]);
                        }
                        Vector oldFileList = (Vector)JMADesktopPane.this.m_fileList.clone();
                        JMADesktopPane.this.m_fileList.removeAllElements();
                        for (int i = 0; i < oldFileList.size(); ++i) {
                            this.add((JCheckBoxMenuItem)oldFileList.get(i));
                        }
                        break block6;
                    }
                    if (this.getItemCount() != 4) break block6;
                    Component[] components = this.getMenuComponents();
                    for (int i = components.length - 1; i >= 0; --i) {
                        if (!(components[i] instanceof JPopupMenu.Separator)) continue;
                        super.remove(components[i]);
                    }
                }
            }
        };
        this.m_tileHorizontalAction = new TileHorizontalAction();
        this.m_tileHorizontalAction.setEnabled(false);
        this.m_menuWindow.add(new JBasicMenuItem(this.m_tileHorizontalAction));
        this.m_tileVerticalAction = new TileVerticalAction();
        this.m_tileVerticalAction.setEnabled(false);
        this.m_menuWindow.add(new JBasicMenuItem(this.m_tileVerticalAction));
        this.m_cascadeAction = new CascadeAction();
        this.m_cascadeAction.setEnabled(false);
        this.m_menuWindow.add(new JBasicMenuItem(this.m_cascadeAction));
        this.internalFramesWatcher = new InternalFramesWatcher();
        this.setDoubleBuffered(true);
        this.maInitialize();
        this.setDesktopManager(new DefaultDesktopManager(){

            @Override
            public void dragFrame(JComponent comp, int x, int y) {
                Rectangle viewPort = JMADesktopPane.this.m_scrollpane.getViewport().getBounds();
                Dimension size = comp.getSize();
                if (x > viewPort.x + viewPort.width - 22) {
                    x = viewPort.x + viewPort.width - 22;
                } else if (x + size.width < viewPort.x + 22) {
                    x += viewPort.x + 22 - (x + size.width);
                }
                if (y > viewPort.y + viewPort.height - 22) {
                    y = viewPort.y + viewPort.height - 22;
                } else if (y < viewPort.y - 22) {
                    y = viewPort.y - 22;
                }
                super.dragFrame(comp, x, y);
            }
        });
    }

    public void updateWindowMenuFileList() {
    }

    public void maInitialize() {
    }

    public void maCleanup() {
        JInternalFrame[] frames = this.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (!(frames[i] instanceof JMAInternalFrame)) continue;
            ((JMAInternalFrame)frames[i]).internalFrameClosed(null);
        }
    }

    public JInternalFrame getFrameWithTitle(String title) {
        JInternalFrame[] frames = this.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].getTitle().equals(title)) continue;
            return frames[i];
        }
        return null;
    }

    public JMenu getInternalFramesMenu() {
        return this.m_menuWindow;
    }

    public void setActive(boolean active, JInternalFrame frame) {
        JBasicCheckBoxMenuItem menuItem;
        JInternalFrame userObject;
        int i;
        for (i = 0; i < this.m_menuWindow.getItemCount(); ++i) {
            if (!(this.m_menuWindow.getItem(i) instanceof JBasicCheckBoxMenuItem) || (userObject = (JInternalFrame)(menuItem = (JBasicCheckBoxMenuItem)this.m_menuWindow.getItem(i)).getUserObject()) == null || userObject != frame) continue;
            menuItem.setSelected(active);
            break;
        }
        for (i = 0; i < this.m_fileList.size(); ++i) {
            if (!(this.m_fileList.get(i) instanceof JBasicCheckBoxMenuItem) || (userObject = (JInternalFrame)(menuItem = (JBasicCheckBoxMenuItem)this.m_fileList.get(i)).getUserObject()) == null || userObject != frame) continue;
            menuItem.setSelected(active);
        }
    }

    public void addCascaded(Component comp) {
        super.add(comp);
        if (comp instanceof JInternalFrame) {
            this.cascade(comp);
        }
        this.moveToFront(comp);
    }

    public void cascadeAll() {
        Component[] comps = this.getComponents();
        int count = comps.length;
        this.nextX = 0;
        this.nextY = 0;
        for (int i = count - 1; i >= 0; --i) {
            Component comp = comps[i];
            if (!(comp instanceof JInternalFrame) || !comp.isVisible()) continue;
            try {
                if (((JInternalFrame)comp).isMaximum()) {
                    ((JInternalFrame)comp).setMaximum(false);
                }
                if (((JInternalFrame)comp).isIcon()) {
                    ((JInternalFrame)comp).setIcon(false);
                }
                this.cascade(comp);
                continue;
            }
            catch (PropertyVetoException e) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Error while cascading components.", e, true);
            }
        }
        this.setCurrentLayoutSetting(1);
    }

    public void tileAll(boolean vertical) {
        Component comp;
        DesktopManager manager = this.getDesktopManager();
        if (manager == null) {
            return;
        }
        Component[] comps = this.getComponents();
        int count = 0;
        for (int i = 0; i < comps.length; ++i) {
            comp = comps[i];
            if (!(comp instanceof JInternalFrame) || !comp.isVisible()) continue;
            try {
                if (((JInternalFrame)comp).isMaximum()) {
                    ((JInternalFrame)comp).setMaximum(false);
                }
                if (((JInternalFrame)comp).isIcon()) {
                    ((JInternalFrame)comp).setIcon(false);
                }
            }
            catch (PropertyVetoException e) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Error while tiling components.", e, true);
            }
            ++count;
        }
        if (count != 0) {
            int rows = (int)Math.sqrt(count);
            int columns = count / rows;
            int spares = count - columns * rows;
            Dimension paneSize = this.m_scrollpane.getViewport().getSize();
            if (!vertical) {
                int columnHeight = paneSize.height / columns;
                int availableWidth = paneSize.width;
                int mainWidth = availableWidth / rows;
                int smallerWidth = availableWidth / (rows + 1);
                int rowWidth = mainWidth;
                int x = 0;
                int y = 0;
                int thisRow = rows;
                int normalColumns = columns - spares;
                for (int i = comps.length - 1; i >= 0; --i) {
                    comp = comps[i];
                    if (!(comp instanceof JInternalFrame) || !comp.isVisible()) continue;
                    manager.setBoundsForFrame((JComponent)comp, x, y, rowWidth, columnHeight);
                    x += rowWidth;
                    if (--thisRow != 0) continue;
                    y += columnHeight;
                    x = 0;
                    if (--normalColumns <= 0) {
                        thisRow = rows + 1;
                        rowWidth = smallerWidth;
                        continue;
                    }
                    thisRow = rows;
                }
            } else {
                int columnWidth = paneSize.width / columns;
                int availableHeight = paneSize.height;
                int mainHeight = availableHeight / rows;
                int smallerHeight = availableHeight / (rows + 1);
                int rowHeight = mainHeight;
                int x = 0;
                int y = 0;
                int thisRow = rows;
                int normalColumns = columns - spares;
                for (int i = comps.length - 1; i >= 0; --i) {
                    comp = comps[i];
                    if (!(comp instanceof JInternalFrame) || !comp.isVisible()) continue;
                    manager.setBoundsForFrame((JComponent)comp, x, y, columnWidth, rowHeight);
                    y += rowHeight;
                    if (--thisRow != 0) continue;
                    y = 0;
                    x += columnWidth;
                    if (--normalColumns <= 0) {
                        thisRow = rows + 1;
                        rowHeight = smallerHeight;
                        continue;
                    }
                    thisRow = rows;
                }
            }
        }
        this.setCurrentLayoutSetting(vertical ? 3 : 2);
    }

    public void cascade(Component comp) {
        Dimension paneSize = this.m_scrollpane.getViewport().getSize();
        int targetWidth = 3 * paneSize.width / 4;
        int targetHeight = 3 * paneSize.height / 4;
        DesktopManager manager = this.getDesktopManager();
        if (manager == null) {
            comp.setBounds(0, 0, targetWidth, targetHeight);
            return;
        }
        if (this.nextX + targetWidth > paneSize.width || this.nextY + targetHeight > paneSize.height) {
            this.nextX = 0;
            this.nextY = 0;
        }
        manager.setBoundsForFrame((JComponent)comp, this.nextX, this.nextY, targetWidth, targetHeight);
        this.nextX += 24;
        this.nextY += 24;
    }

    protected void recomputeSize() {
        if (!this.recomputeSizeInhibited) {
            this.recomputeSizeInhibited = true;
            Dimension viewportSize = this.m_scrollpane == null ? new Dimension(0, 0) : this.m_scrollpane.getViewport().getSize();
            int width = viewportSize.width;
            int height = viewportSize.height;
            Component[] comps = this.getComponents();
            boolean maximized = false;
            for (Component comp : comps) {
                if (!comp.isVisible()) continue;
                if (comp instanceof JInternalFrame && ((JInternalFrame)comp).isMaximum()) {
                    width = viewportSize.width;
                    height = viewportSize.height;
                    maximized = true;
                    break;
                }
                Rectangle compRect = comp.getBounds();
                int compRightX = compRect.x + compRect.width;
                int compBottomY = compRect.y + compRect.height;
                Rectangle parentRect = this.getBounds();
                int parentRightX = parentRect.x + parentRect.width;
                int parentBottomY = parentRect.y + parentRect.height;
                if (parentRect.contains(compRect) && parentRect.width != this.getSize().width && parentRect.height != this.getSize().height) {
                    maximized = true;
                    continue;
                }
                width = compRightX > parentRightX ? (width += compRightX - parentRightX) : (compRect.x < parentRect.x ? (width += parentRect.x - compRect.x) : Math.max(width, compRect.x + compRect.width));
                if (compBottomY > parentBottomY) {
                    height += compBottomY - parentBottomY;
                    continue;
                }
                if (compRect.y < parentRect.y) {
                    height += parentRect.y - compRect.y;
                    continue;
                }
                height = Math.max(height, compRect.y + compRect.height);
            }
            Dimension size = this.getSize();
            if (maximized || width != size.width || height != size.height) {
                Dimension newSize = new Dimension(width, height);
                this.setSize(newSize);
                this.setPreferredSize(newSize);
            }
            this.recomputeSizeInhibited = false;
        }
    }

    @Override
    public void componentAdded(ContainerEvent event) {
        Component comp = event.getChild();
        comp.addComponentListener(this);
        if (comp instanceof JInternalFrame && !this.internalFrames.contains(comp)) {
            JInternalFrame iframe = (JInternalFrame)comp;
            this.internalFrames.add(iframe);
            this.m_menuWindow.add(new OpenInternalFrameAction(iframe));
            iframe.addInternalFrameListener(this.internalFramesWatcher);
        }
        this.recomputeSize();
        this.m_tileHorizontalAction.setEnabled(true);
        this.m_tileVerticalAction.setEnabled(true);
        this.m_cascadeAction.setEnabled(true);
    }

    @Override
    public void componentRemoved(ContainerEvent event) {
        Component comp = event.getChild();
        comp.removeComponentListener(this);
        this.recomputeSize();
        if (this.getAllFrames().length < 1) {
            this.m_tileHorizontalAction.setEnabled(false);
            this.m_tileVerticalAction.setEnabled(false);
            this.m_cascadeAction.setEnabled(false);
        }
    }

    @Override
    public void componentResized(ComponentEvent evt) {
        Component c = evt.getComponent();
        if (c instanceof JViewport) {
            this.recomputeSize();
        }
        if (c instanceof JInternalFrame && ((JInternalFrame)c).isMaximum() && this.m_scrollpane != null) {
            Dimension viewPortSize = this.m_scrollpane.getViewport().getSize();
            Dimension compSize = c.getSize();
            if (compSize.width > viewPortSize.width || compSize.height > viewPortSize.height) {
                ((JInternalFrame)c).setMaximumSize(viewPortSize);
            }
        }
    }

    @Override
    public void componentMoved(ComponentEvent evt) {
        this.componentHidden(evt);
    }

    @Override
    public void componentShown(ComponentEvent evt) {
        this.componentHidden(evt);
    }

    @Override
    public void componentHidden(ComponentEvent evt) {
        if (evt.getComponent() instanceof JViewport) {
            this.recomputeSize();
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(700, 500);
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        boolean vertical = orientation == 1;
        return vertical ? 25 : 40;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        int fullSize = orientation == 1 ? visibleRect.height : visibleRect.width;
        return Math.max(10, (int)((double)fullSize * 0.9));
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (x != this.getX() || y != this.getY() || w != this.getWidth() || h != this.getHeight()) {
            super.setBounds(x, y, w, h);
            this.recomputeSize();
        }
    }

    private void refreshSettings() {
        if (this.getCurrentLayoutSetting() == 1) {
            this.cascadeAll();
        } else if (this.getCurrentLayoutSetting() == 2) {
            this.tileAll(false);
        } else if (this.getCurrentLayoutSetting() == 3) {
            this.tileAll(true);
        }
    }

    private void setCurrentLayoutSetting(int setting) {
        this.currentLayoutSetting = setting;
    }

    private int getCurrentLayoutSetting() {
        return this.currentLayoutSetting;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        JScrollPane sp = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
        if (sp != null && this.getParent().getParent() == sp) {
            this.m_scrollpane = sp;
            this.m_scrollpane.getViewport().addComponentListener(this);
            this.m_scrollpane.setHorizontalScrollBarPolicy(31);
            this.m_scrollpane.setVerticalScrollBarPolicy(21);
        }
    }

    private void removeMenuItemFor(JInternalFrame internalFrame) {
        JBasicCheckBoxMenuItem menuItem;
        JInternalFrame userObject;
        int i;
        boolean found = false;
        for (i = 0; i < this.m_menuWindow.getItemCount(); ++i) {
            if (!(this.m_menuWindow.getItem(i) instanceof JBasicCheckBoxMenuItem) || (userObject = (JInternalFrame)(menuItem = (JBasicCheckBoxMenuItem)this.m_menuWindow.getItem(i)).getUserObject()) == null || userObject != internalFrame) continue;
            this.m_menuWindow.remove(menuItem);
            found = true;
            break;
        }
        if (!found) {
            for (i = 0; i < this.m_fileList.size(); ++i) {
                if (!(this.m_fileList.get(i) instanceof JBasicCheckBoxMenuItem) || (userObject = (JInternalFrame)(menuItem = (JBasicCheckBoxMenuItem)this.m_fileList.get(i)).getUserObject()) == null || userObject != internalFrame) continue;
                this.m_menuWindow.remove(menuItem);
                break;
            }
        }
    }

    class FileNameRenderer
    extends DefaultListCellRenderer {
        FileNameRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            Icon icon = ResourceManager.getIcon(this.getClass(), "CheckMark");
            JBasicCheckBoxMenuItem menuItem = (JBasicCheckBoxMenuItem)value;
            if (JMADesktopPane.this.getSelectedFrame() == null) {
                this.setIcon(null);
            } else if (menuItem.isSelected()) {
                this.setIcon(icon);
            } else {
                BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                Graphics2D graphics = bufferedImage.createGraphics();
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight() - 1);
                this.setIcon(new ImageIcon(bufferedImage));
            }
            this.setText(menuItem.getText());
            return this;
        }
    }

    public class WindowFileListDialog
    extends JMADialog
    implements ListSelectionListener {
        protected JList m_list;

        public WindowFileListDialog(JMAFrame parent, String name) {
            super(parent, name);
        }

        public WindowFileListDialog(JMADialog parent, String name) {
            super(parent, name);
        }

        @Override
        protected void maInitialize() {
            this.getContentPane().add((Component)this.createListPanel(), "Center");
            super.getContentPane().add((Component)this.createButtonPanel(this.getButtonActions()), "South");
        }

        protected JPanel createListPanel() {
            JPartitionPanel outerPanel = new JPartitionPanel(true, "p,r", "");
            outerPanel.add(new JLabel("Select a window to activate:"));
            this.m_list = new JList(JMADesktopPane.this.m_fileList);
            this.m_list.setBorder(BorderFactory.createLoweredBevelBorder());
            this.m_list.setCellRenderer(new FileNameRenderer());
            this.m_list.getSelectionModel().setSelectionMode(0);
            this.m_list.addListSelectionListener(this);
            this.m_list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    JButton button;
                    BasicAction action;
                    if (e.getClickCount() == 2 && (action = WindowFileListDialog.this.getDefaultOKAction()) != null && (button = ((JButtonPanel)WindowFileListDialog.this.getButtonPanel()).getButton((String)action.getValue("ActionCommandKey"))) != null) {
                        button.doClick();
                    }
                }
            });
            outerPanel.add(new ExtendedJScrollPane(this.m_list));
            this.getDefaultOKAction().setEnabled(false);
            return outerPanel;
        }

        @Override
        protected JPanel createButtonPanel(Action[] action) {
            return this.m_list != null ? super.createButtonPanel(action) : null;
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getSource() == this.m_list) {
                this.enableButtons();
            }
        }

        protected void enableButtons() {
            this.getDefaultOKAction().setEnabled(!this.m_list.isSelectionEmpty());
        }

        @Override
        protected void maCleanup() {
        }

        public JList getWindowFileList() {
            return this.m_list;
        }
    }

    class WindowFileListAction
    extends BasicGuiAction {
        public WindowFileListAction() {
            super("JMADesktopPane.WindowFileList");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JList list;
            WindowFileListDialog dialog = new WindowFileListDialog(MgmtConsole.getMgmtConsole(), "WindowFileListDialog");
            dialog.setVisible(true);
            if (dialog.getCloseCommand() == 0 && (list = dialog.getWindowFileList()) != null && list.getSelectedValue() != null) {
                ((JBasicCheckBoxMenuItem)list.getSelectedValue()).doClick();
            }
        }
    }

    class OpenInternalFrameAction
    extends BasicGuiAction {
        private JInternalFrame internalFrame;

        OpenInternalFrameAction(JInternalFrame internalFrame) {
            super("JMADesktopPane.open");
            this.putNameValue(internalFrame);
            this.internalFrame = internalFrame;
        }

        private void putNameValue(JInternalFrame internalFrame) {
            this.putValue("Name", internalFrame.getTitle());
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                this.internalFrame.setIcon(false);
                this.internalFrame.show();
                this.internalFrame.setSelected(true);
            }
            catch (PropertyVetoException e) {
                MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
            }
        }

        public JInternalFrame getInternalFrame() {
            return this.internalFrame;
        }
    }

    class CascadeAction
    extends BasicGuiAction {
        public CascadeAction() {
            super("JMADesktopPane.cascade");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JMADesktopPane.this.cascadeAll();
        }
    }

    class TileVerticalAction
    extends BasicGuiAction {
        public TileVerticalAction() {
            super("JMADesktopPane.tile.vertical");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JMADesktopPane.this.tileAll(true);
        }
    }

    class TileHorizontalAction
    extends BasicGuiAction {
        public TileHorizontalAction() {
            super("JMADesktopPane.tile.horizontal");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JMADesktopPane.this.tileAll(false);
        }
    }

    class InternalFramesWatcher
    extends InternalFrameAdapter {
        InternalFramesWatcher() {
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent evt) {
            MgmtConsole console = MgmtConsole.getMgmtConsole();
            console.getDesktopPane().setActive(true, evt.getInternalFrame());
        }

        @Override
        public void internalFrameDeactivated(InternalFrameEvent evt) {
            MgmtConsole console = MgmtConsole.getMgmtConsole();
            console.getDesktopPane().setActive(false, evt.getInternalFrame());
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent e) {
            JInternalFrame iframe = e.getInternalFrame();
            JMADesktopPane.this.internalFrames.remove(iframe);
            JMADesktopPane.this.removeMenuItemFor(iframe);
            JMADesktopPane.this.remove(iframe);
        }
    }
}

