/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JButtonPanel;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.gui.util.SizeHelper;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public abstract class JMADialog
extends JDialog
implements WindowListener {
    public static final int CLOSE_OK = 0;
    public static final int CLOSE_CANCEL = -1;
    private final BasicAction defaultOKAction = new OkAction("dialog.ok");
    private final BasicAction defaultCancelAction = new CancelAction("dialog.cancel");
    private final BasicAction defaultHelpAction = new HelpAction("dialog.help");
    protected JButtonPanel m_buttonPanel;
    private boolean m_initialized = false;
    protected String m_name;
    protected int m_closeCommand = -1;
    private String m_helpId;
    private List keyEventProviders = new ArrayList();
    private DefaultsKeyAdapter keyAdaptor = new DefaultsKeyAdapter(this);

    public JMADialog(JMAFrame parent, String name) {
        super(parent);
        this.initializeDialog(name);
    }

    public JMADialog(JMADialog parent, String name) {
        super(parent);
        this.initializeDialog(name);
    }

    private void initializeDialog(String name) {
        this.initDialog(name);
    }

    protected void initDialog(String name) {
        this.m_name = name;
        if (this.m_name == null || this.m_name.trim().length() == 0) {
            this.setTitle(ResourceManager.getString(this.getClass(), "JMADialog.unknownTitle"));
        } else {
            this.setTitle(ResourceManager.getString(this.getClass(), "dialog." + this.m_name + ".title"));
        }
        this.internalInitialize();
        this.setModal(true);
    }

    public String getTitleKey() {
        return this.m_name;
    }

    public void setTitleKey(String key) {
        this.m_name = key;
    }

    protected abstract void maInitialize();

    protected abstract void maCleanup();

    @Override
    public void setVisible(boolean newState) {
        if (!this.m_initialized) {
            Action[] actions = this.getButtonActions();
            JPanel panel = null;
            if (actions != null && actions.length > 0) {
                panel = this.createButtonPanel(actions);
            }
            if (panel != null) {
                super.getContentPane().add((Component)panel, "South");
                if (panel instanceof JButtonPanel) {
                    JButton defBtn = ((JButtonPanel)panel).getButton("dialog.ok");
                    if (defBtn == null) {
                        defBtn = ((JButtonPanel)panel).getButton("dialog.cancel");
                    }
                    if (defBtn == null && actions != null && actions.length > 0) {
                        String defCmd = (String)actions[0].getValue("ActionCommandKey");
                        defBtn = ((JButtonPanel)panel).getButton(defCmd);
                    }
                    if (defBtn != null) {
                        this.getRootPane().setDefaultButton(defBtn);
                    }
                }
            }
            this.m_initialized = true;
            this.maInitialize();
            this.pack();
            if (this.isResizable()) {
                SizeHelper.restoreWindowSize(this);
            }
            if (!SizeHelper.restoreWindowPosition(this)) {
                this.setLocationRelativeTo(this.getParent());
            }
        }
        this.setKeyListener(this);
        if (newState) {
            Helper.invoke(new Runnable(){

                @Override
                public void run() {
                    Component component = JMADialog.this.findFocusableComponent(JMADialog.this.getContentPane().getComponents());
                    if (component != null) {
                        component.requestFocus();
                    }
                }
            });
        }
        super.setVisible(newState);
    }

    protected Component findFocusableComponent(Component[] components) {
        Component component = null;
        if (components != null) {
            for (int i = 0; i < components.length; ++i) {
                if (!components[i].isLightweight() || !(components[i] instanceof JComponent)) continue;
                JComponent jcomp = (JComponent)components[i];
                if (jcomp instanceof JComboBox || jcomp instanceof JList || jcomp instanceof JSlider) {
                    if (!jcomp.isFocusable() || !jcomp.isEnabled()) continue;
                    component = jcomp;
                    break;
                }
                if (jcomp.getComponentCount() > 0) {
                    if (jcomp instanceof JTabbedPane) {
                        Component selTab = ((JTabbedPane)jcomp).getSelectedComponent();
                        if (selTab == null) {
                            selTab = ((JTabbedPane)jcomp).getComponentAt(0);
                        }
                        if (selTab != null) {
                            component = this.findFocusableComponent(((JComponent)selTab).getComponents());
                        }
                        if (component != null) break;
                        component = jcomp;
                        break;
                    }
                    component = this.findFocusableComponent(jcomp.getComponents());
                    if (component == null) continue;
                    break;
                }
                if (!jcomp.isFocusable() || !jcomp.isEnabled()) continue;
                if (jcomp instanceof JTextComponent) {
                    if (!((JTextComponent)jcomp).isEditable()) continue;
                    component = jcomp;
                    break;
                }
                if (!(jcomp instanceof AbstractButton) && !(jcomp instanceof JTree) && !(jcomp instanceof JTable)) continue;
                component = jcomp;
                break;
            }
        }
        return component;
    }

    public void setKeyListener(Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component childComp = container.getComponent(i);
            if (childComp instanceof JComponent) {
                childComp.addKeyListener(this.keyAdaptor);
                this.keyEventProviders.add(childComp);
            }
            if (!(childComp instanceof Container)) continue;
            this.setKeyListener((Container)childComp);
        }
    }

    public JPanel getButtonPanel() {
        return this.m_buttonPanel;
    }

    protected void internalInitialize() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
    }

    protected boolean isHelpEnabled() {
        if (this.m_helpId == null && this.m_name != null && this.m_name.trim().length() > 0) {
            this.m_helpId = ResourceManager.getString(this.getClass(), "dialog." + this.m_name + ".help");
        }
        return this.m_helpId != null;
    }

    protected String getHelpId() {
        return this.isHelpEnabled() ? this.m_helpId : null;
    }

    public Action[] getButtonActions() {
        boolean hasHelp = this.isHelpEnabled();
        Action[] res = new Action[hasHelp ? 3 : 2];
        res[0] = this.defaultOKAction;
        res[1] = this.defaultCancelAction;
        if (hasHelp) {
            res[2] = this.defaultHelpAction;
        }
        return res;
    }

    protected boolean canClose() {
        return true;
    }

    protected JPanel createButtonPanel(Action[] action) {
        this.m_buttonPanel = new JButtonPanel(false);
        this.m_buttonPanel.addRemainder();
        for (int i = 0; i < action.length; ++i) {
            if (action[i] == null) continue;
            this.m_buttonPanel.addButton(action[i]);
        }
        Helper.equalize(this.m_buttonPanel);
        return this.m_buttonPanel;
    }

    public BasicAction getDefaultOKAction() {
        return this.defaultOKAction;
    }

    public BasicAction getDefaultCancelAction() {
        return this.defaultCancelAction;
    }

    public BasicAction getDefaultHelpAction() {
        return this.defaultHelpAction;
    }

    public int getCloseCommand() {
        return this.m_closeCommand;
    }

    @Override
    public void windowActivated(WindowEvent evt) {
    }

    @Override
    public void windowClosed(WindowEvent evt) {
        if (this.m_initialized) {
            if (this.isResizable()) {
                SizeHelper.saveWindowSize(this);
            }
            SizeHelper.saveWindowPosition(this);
        }
        try {
            this.maCleanup();
        }
        catch (Exception e) {
            MgmtConsole.displayMessage(4, "Error closing dialog.", e, true);
        }
        for (JComponent component : this.keyEventProviders) {
            try {
                component.removeKeyListener(this.keyAdaptor);
            }
            catch (Exception e) {
                MgmtConsole.displayMessage(4, "Error closing dialog.", e, true);
            }
        }
        this.keyEventProviders.clear();
    }

    @Override
    public void windowClosing(WindowEvent evt) {
        if (this.canClose()) {
            this.dispose();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent evt) {
    }

    @Override
    public void windowDeiconified(WindowEvent evt) {
    }

    @Override
    public void windowIconified(WindowEvent evt) {
    }

    @Override
    public void windowOpened(WindowEvent evt) {
    }

    static class DefaultsKeyAdapter
    extends KeyAdapter {
        JMADialog m_dialog;

        public DefaultsKeyAdapter(JMADialog dialog) {
            this.m_dialog = dialog;
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            BasicAction action = null;
            if (evt.getKeyCode() == 27) {
                action = this.m_dialog.getDefaultCancelAction();
            }
            if (action != null) {
                AbstractButton button = null;
                if (this.m_dialog.m_buttonPanel != null) {
                    button = this.m_dialog.m_buttonPanel.getButton(this.getCommandKey(action));
                }
                if (button != null) {
                    button.doClick();
                }
            }
        }

        private String getCommandKey(Action action) {
            return (String)action.getValue("ActionCommandKey");
        }
    }

    class HelpAction
    extends BasicGuiAction {
        public HelpAction(String resourceId) {
            super(resourceId);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            super.actionPerformed(evt);
            Helper.displayURL(JMADialog.this.getHelpId());
        }
    }

    class CancelAction
    extends BasicGuiAction {
        public CancelAction(String resourceId) {
            super(resourceId);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            super.actionPerformed(evt);
            Component source = (Component)evt.getSource();
            JMADialog dialog = (JMADialog)SwingUtilities.getAncestorOfClass(JDialog.class, source);
            if (dialog != null && dialog.canClose()) {
                dialog.m_closeCommand = -1;
                dialog.dispose();
            }
        }
    }

    class OkAction
    extends BasicGuiAction {
        public OkAction(String resourceId) {
            super(resourceId);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            super.actionPerformed(evt);
            Component source = (Component)evt.getSource();
            JMADialog dialog = (JMADialog)SwingUtilities.getAncestorOfClass(JDialog.class, source);
            dialog.m_closeCommand = 0;
            dialog.dispose();
        }
    }
}

