/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.gui.util.SizeHelper;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public abstract class JMAFrame
extends JFrame
implements WindowListener {
    private boolean m_initialized = false;
    private String m_name;
    private static final int DEF_WIDTH = 800;
    private static final int DEF_HEIGHT = 600;

    public JMAFrame(String name) {
        this.prepareJFrame(name);
    }

    private void prepareJFrame(String name) {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.m_name = name;
        if (this.m_name == null || this.m_name.trim().length() == 0) {
            this.setTitle(ResourceManager.getString(this.getClass(), "JMADialog.unknownTitle"));
        } else {
            String title = ResourceManager.getApplicationPropertyString("application.title");
            this.setTitle(title != null ? title : ResourceManager.getString(this.getClass(), "frame." + this.m_name + ".title"));
        }
    }

    protected abstract void maInitialize();

    protected abstract void maCleanup();

    public String getTitleKey() {
        return this.m_name;
    }

    public Object getId() {
        return null;
    }

    @Override
    public void setVisible(boolean newState) {
        if (!this.m_initialized) {
            this.maInitialize();
            if (!SizeHelper.restoreWindowSize(this)) {
                this.pack();
                this.setSize(800, 600);
            }
            if (!SizeHelper.restoreWindowPosition(this)) {
                Dimension screenSize = this.getToolkit().getScreenSize();
                Dimension windowSize = this.getSize();
                int x = (screenSize.width - windowSize.width) / 2;
                int y = (screenSize.height - windowSize.height) / 2;
                this.setLocation(x, y);
            }
            this.m_initialized = true;
        }
        super.setVisible(newState);
    }

    protected boolean canClose() {
        return true;
    }

    public void setImageIcon(ImageIcon icon) {
        if (icon != null) {
            this.setIconImage(icon.getImage());
        }
    }

    @Override
    public void windowActivated(WindowEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void windowClosed(WindowEvent evt) {
        JWaitCursor wc = new JWaitCursor(this);
        if (this.m_initialized) {
            SizeHelper.saveWindowSize(this);
            SizeHelper.saveWindowPosition(this);
        }
        try {
            this.maCleanup();
        }
        catch (Exception e) {
            MgmtConsole.displayMessage(4, "Error while closing the dialog.", e, true);
        }
        finally {
            wc.release();
        }
        System.exit(0);
    }

    @Override
    public void windowClosing(WindowEvent evt) {
        if (this.canClose()) {
            this.dispose();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent evt) {
    }

    @Override
    public void windowDeiconified(WindowEvent evt) {
    }

    @Override
    public void windowIconified(WindowEvent evt) {
    }

    @Override
    public void windowOpened(WindowEvent evt) {
    }
}

