/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.WorkspaceWindow;
import com.sonicsw.ma.gui.util.JMADesktopPane;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.gui.util.SizeHelper;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public abstract class JMAInternalFrame
extends JInternalFrame
implements InternalFrameListener {
    private ArrayList m_dependList = null;
    private JMAInternalFrame m_dependFrame = null;
    private Rectangle m_restoreBounds = null;
    private boolean m_initialized = false;
    private boolean m_isInit = false;
    private String m_name;

    public JMAInternalFrame(String name) throws IllegalArgumentException {
        super(null, true, true, true, true);
        this.prepareJMAInternalFrame(name);
    }

    private void prepareJMAInternalFrame(String name) {
        this.setDefaultCloseOperation(0);
        this.addInternalFrameListener(this);
        this.m_name = name;
        if (this.m_name == null || this.m_name.trim().length() == 0) {
            super.setTitle(ResourceManager.getString(this.getClass(), "JMADialog.unknownTitle"));
        } else {
            super.setTitle(ResourceManager.getString(this.getClass(), "iframe." + this.m_name + ".title"));
        }
    }

    protected abstract void maInitialize();

    protected abstract void maCleanup();

    public String getTitleKey() {
        return this.m_name;
    }

    public Object getId() {
        return null;
    }

    @Override
    public void setMaximum(boolean b) throws PropertyVetoException {
        if (this.isMaximum == b) {
            return;
        }
        if (b) {
            this.m_restoreBounds = this.getBounds();
        }
        Boolean oldValue = this.isMaximum ? Boolean.TRUE : Boolean.FALSE;
        Boolean newValue = b ? Boolean.TRUE : Boolean.FALSE;
        this.fireVetoableChange("maximum", oldValue, newValue);
        this.isMaximum = b;
        this.firePropertyChange("maximum", oldValue, newValue);
    }

    public Rectangle getRestoreBounds() {
        if (this.m_restoreBounds == null) {
            return this.getNormalBounds();
        }
        return this.m_restoreBounds;
    }

    @Override
    public void setVisible(boolean newState) {
        if (!this.m_initialized && newState) {
            this.maInitialize();
            JMADesktopPane desktop = MgmtConsole.getMgmtConsole().getDesktopPane();
            boolean handled = SizeHelper.restoreWindowSize(this);
            boolean bl = handled = SizeHelper.restoreWindowPosition(this) && handled;
            if (handled) {
                JInternalFrame selected = desktop.getSelectedFrame();
                if (selected != null) {
                    try {
                        this.setMaximum(selected.isMaximum());
                    }
                    catch (Exception e) {
                        MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                    }
                }
            } else {
                JInternalFrame selected = desktop.getSelectedFrame();
                int count = desktop.getAllFrames().length;
                if (count == 1 || selected != null && selected.isMaximum()) {
                    desktop.cascade(this);
                    try {
                        this.setMaximum(true);
                    }
                    catch (Exception e) {
                        MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                    }
                } else {
                    desktop.cascade(this);
                }
            }
            this.m_initialized = true;
        }
        super.setVisible(newState);
    }

    protected boolean canClose() {
        return true;
    }

    @Override
    public void dispose() {
        this.dispose(true);
    }

    public void dispose(boolean canClose) {
        if (!canClose || canClose && this.canClose()) {
            super.dispose();
        }
    }

    public void addDependantFrame(JMAInternalFrame frame) {
        if (!frame.isDependant()) {
            frame.setDependeeFrame(this);
            if (this.m_dependList == null || !this.m_dependList.contains(frame)) {
                if (this.m_dependList == null) {
                    this.m_dependList = new ArrayList();
                }
                this.m_dependList.add(frame);
            }
        }
    }

    public void removeDependantFrame(JMAInternalFrame frame) {
        frame.setDependeeFrame(null);
        if (this.m_dependList != null) {
            this.m_dependList.remove(frame);
            if (this.m_dependList.isEmpty()) {
                this.m_dependList = null;
            }
        }
    }

    public boolean isDependant() {
        return this.m_dependFrame != null;
    }

    public void setDependeeFrame(JMAInternalFrame frame) {
        this.m_dependFrame = frame;
    }

    public JMAInternalFrame getDependeeFrame() {
        return this.m_dependFrame;
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent evt) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent evt) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void internalFrameClosed(InternalFrameEvent evt) {
        if (this.m_initialized) {
            SizeHelper.saveWindowSize(this);
            SizeHelper.saveWindowPosition(this);
        }
        JWaitCursor wc = new JWaitCursor(this);
        try {
            this.maCleanup();
            if (this.getDependeeFrame() != null) {
                this.removeDependantFrame(this.getDependeeFrame());
            }
            while (this.m_dependList != null && !this.m_dependList.isEmpty()) {
                JMAInternalFrame aFrame = (JMAInternalFrame)this.m_dependList.remove(0);
                try {
                    aFrame.dispose(false);
                }
                catch (Exception e) {
                    MgmtConsole.getMgmtConsole().notifyMessage(64, e.getMessage(), e, false);
                }
            }
            this.m_dependList = null;
        }
        catch (Exception e) {
            MgmtConsole.displayMessage(4, "Failure closing internal frame - " + e.toString(), e, true);
        }
        finally {
            wc.release();
        }
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent evt) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent evt) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent evt) {
        MgmtConsole console = MgmtConsole.getMgmtConsole();
        if (this instanceof WorkspaceWindow) {
            ((WorkspaceWindow)this).stateChanged(null);
        } else {
            console.getToolBar().clearActions();
        }
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent evt) {
    }
}

