/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.util.Helper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;

public class JMAStatusBar
extends JPanel {
    private static final int TIMER_DELAY = 5000;
    private static final int PROGRESS_HEIGHT = 15;
    private String TEXT_READY = "Ready";
    private Timer m_timer;
    private JLabel m_statusArea;
    private JPanel panelProgress;
    private JProgressBar m_progressBar;
    private boolean m_bProgressLock = false;

    public JMAStatusBar(Action cancelAction) {
        super(new GridLayout(1, 2));
        this.init();
    }

    public JProgressBar getProgressBar() {
        JProgressBar barRes = null;
        if (!this.m_bProgressLock && this.m_progressBar != null) {
            this.m_bProgressLock = true;
            barRes = this.m_progressBar;
        }
        return barRes;
    }

    public void releaseProgressBar() {
        if (this.m_bProgressLock) {
            this.m_bProgressLock = false;
        }
    }

    public void showStatusMessage(String message) {
        this.updateText(this.m_statusArea, message != null ? message : this.TEXT_READY);
        if (message != null) {
            this.m_timer.restart();
        }
    }

    public void setPersistentMessage(String message) {
        this.updateText(this.m_statusArea, message != null ? message : this.TEXT_READY);
    }

    protected void updateText(JComponent comp, String text) {
        Helper.invoke(new TextUpdater(comp, text));
    }

    public synchronized void monitorProgress(boolean start) {
        if (this.m_progressBar != null) {
            this.m_progressBar.setIndeterminate(start);
        }
    }

    private void init() {
        this.m_timer = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMAStatusBar.this.showStatusMessage(JMAStatusBar.this.TEXT_READY);
            }
        });
        this.setBorder(new EmptyBorder(2, 2, 0, 0));
        this.m_statusArea = new JLabel(this.TEXT_READY);
        this.add(this.m_statusArea);
        this.add(this.createStatusPanel());
    }

    private JPanel createStatusPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add("Center", this.createCombinedStatusPanel());
        return panel;
    }

    private JPanel createCombinedStatusPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JPanel panelProgress = this.createProgressPanel();
        panel.add(panelProgress);
        this.setAnchor(panelProgress, 17);
        this.fillWidth(panelProgress);
        JPanel panelIndicators = this.createIndicatorPanel();
        panel.add(panelIndicators);
        this.setAnchor(panelIndicators, 13);
        this.fillWidth(panelIndicators);
        return panel;
    }

    private JPanel createProgressPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.m_progressBar = new JProgressBar(0);
        this.m_progressBar.setBorder(new SoftBevelBorder(1));
        this.m_progressBar.setVisible(false);
        this.m_progressBar.setPreferredSize(new Dimension(this.m_progressBar.getWidth(), 15));
        panel.add(this.m_progressBar);
        return panel;
    }

    private JPanel createIndicatorPanel() {
        return new JPanel(new FlowLayout(2, 5, 1));
    }

    public GridBagConstraints setAnchor(Component c, int nAnchor) {
        Container parent = c.getParent();
        GridBagLayout gbl = (GridBagLayout)parent.getLayout();
        GridBagConstraints gbc = gbl.getConstraints(c);
        if (gbc == null) {
            gbc = new GridBagConstraints();
        }
        gbc.anchor = nAnchor;
        gbl.setConstraints(c, gbc);
        return gbc;
    }

    public GridBagConstraints fillWidth(Component c) {
        Container parent = c.getParent();
        GridBagLayout gbl = (GridBagLayout)parent.getLayout();
        GridBagConstraints gbc = gbl.getConstraints(c);
        if (gbc == null) {
            gbc = new GridBagConstraints();
        }
        this.fillWidth(gbc);
        gbl.setConstraints(c, gbc);
        return gbc;
    }

    public void fillWidth(GridBagConstraints gbc) {
        switch (gbc.fill) {
            case 1: {
                break;
            }
            case 3: {
                gbc.fill = 1;
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                gbc.fill = 2;
            }
        }
        if (gbc.weightx == 0.0) {
            gbc.weightx = 1.0;
        }
    }

    static class TextUpdater
    implements Runnable {
        private Component comp;
        private String text;

        public TextUpdater(JComponent comp, String text) {
            this.comp = comp;
            this.text = text;
        }

        @Override
        public void run() {
            if (this.comp instanceof JTextField) {
                ((JTextField)this.comp).setText(this.text);
            } else if (this.comp instanceof JLabel) {
                ((JLabel)this.comp).setText(this.text);
            }
        }
    }
}

