/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.ModelListTableModel;
import com.sonicsw.ma.gui.table.RowTableColumn;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.JRowTable;
import com.sonicsw.ma.gui.util.JRowTableButtonPanel;
import com.sonicsw.ma.gui.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import modelobjects.layout.PartitionLayout;
import progress.message.jclient.DestinationFactory;
import progress.message.jimpl.MultiTopic;

public class JMultiTopicHelperPanel
extends JPanel {
    protected boolean m_bIsReadOnly = false;
    protected JRowTable m_topicTable;
    protected JTextField m_txTopicName;
    protected SmartRowTableButtonPanel m_btnPanel = null;
    protected JMADialog m_parent;
    private JTextField m_txQualifierName = null;
    private JComboBox m_cbQualifier = null;
    private progress.message.jclient.MultiTopic m_mt = null;
    private int m_nType = 0;
    private static final int QUAL_NONE = 0;
    private static final int QUAL_GROUP_NAME = 1;
    private static final int QUAL_ROUTING_NODE = 2;

    public JMultiTopicHelperPanel(JMADialog parent, int nType) {
        this(parent, false, null, nType);
    }

    public JMultiTopicHelperPanel(JMADialog parent, boolean bSetReadOnly, progress.message.jclient.MultiTopic mt, int nType) {
        super(new BorderLayout(5, 5));
        this.setBorder();
        this.m_parent = parent;
        this.m_bIsReadOnly = bSetReadOnly;
        if (mt == null) {
            try {
                mt = DestinationFactory.createMultiTopic();
            }
            catch (JMSException jmse) {
                MgmtConsole.displayMessage(parent, 4, "Could not create MultiTopic.", jmse, true);
            }
        }
        this.m_mt = mt;
        this.m_nType = nType;
        this.initializeUI();
    }

    private void setBorder() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private void initializeUI() {
        this.initUI();
    }

    public progress.message.jclient.MultiTopic getResult() {
        return this.m_mt;
    }

    protected final void initUI() {
        this.add((Component)this.createQualifierPanel(), "North");
        JPartitionPanel topicBuilderPanel = new JPartitionPanel(false, "p,r", ResourceManager.getString(this.getClass(), "dialog.JMultiTopicHelperDialog.Topics"));
        PartitionLayout layout = (PartitionLayout)topicBuilderPanel.getLayout();
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.add((Component)this.makeMultiTopicTable(), "Center");
        if (!this.m_bIsReadOnly) {
            this.m_btnPanel = this.makeMultiTopicButtons();
            panel.add((Component)this.m_btnPanel, "East");
        }
        topicBuilderPanel.addRow(panel);
        this.add((Component)topicBuilderPanel, "Center");
        this.initTopicTable();
        this.enableFields();
    }

    protected JPartitionPanel createQualifierPanel() {
        JPartitionPanel qualifierPanel = new JPartitionPanel(false, "p,r", ResourceManager.getString(this.getClass(), "dialog.JMultiTopicHelperDialog.Qualifier"));
        PartitionLayout layout = (PartitionLayout)qualifierPanel.getLayout();
        this.m_cbQualifier = this.m_nType == 0 ? new JComboBox<Object>(new Object[]{ResourceManager.getString(this.getClass(), "dialog.JMultiTopicHelperDialog.None"), ResourceManager.getString(this.getClass(), "dialog.JMultiTopicHelperDialog.GroupName"), ResourceManager.getString(this.getClass(), "dialog.JMultiTopicHelperDialog.RoutingNode")}) : (this.m_nType == 1 ? new JComboBox<Object>(new Object[]{ResourceManager.getString(this.getClass(), "dialog.JMultiTopicHelperDialog.None"), ResourceManager.getString(this.getClass(), "dialog.JMultiTopicHelperDialog.GroupName")}) : new JComboBox<Object>(new Object[]{ResourceManager.getString(this.getClass(), "dialog.JMultiTopicHelperDialog.None"), ResourceManager.getString(this.getClass(), "dialog.JMultiTopicHelperDialog.RoutingNode")}));
        qualifierPanel.addRow(ResourceManager.getString(this.getClass(), "dialog.JMultiTopicHelperDialog.QualifierType"), (JComponent)this.m_cbQualifier);
        int nIndex = 0;
        if (((MultiTopic)this.m_mt).hasGroup()) {
            nIndex = 1;
        } else if (((MultiTopic)this.m_mt).hasRouting()) {
            nIndex = 2;
        }
        this.setSelectedQualifier(nIndex);
        this.m_cbQualifier.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMultiTopicHelperPanel.this.enableFields();
            }
        });
        this.m_txQualifierName = new JTextField();
        this.m_txQualifierName.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                JMultiTopicHelperPanel.this.enableFields();
            }

            public void insertUpdate(DocumentEvent e) {
            }

            public void removeUpdate(DocumentEvent e) {
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        qualifierPanel.addRow(ResourceManager.getString(this.getClass(), "dialog.JMultiTopicHelperDialog.QualifierName"), (JComponent)this.m_txQualifierName);
        this.m_txQualifierName.setText(((MultiTopic)this.m_mt).hasGroup() ? ((MultiTopic)this.m_mt).getGroupName() : ((MultiTopic)this.m_mt).getRouting());
        return qualifierPanel;
    }

    protected int getSelectedQualifier() {
        int nSel = 0;
        Object obj = this.m_cbQualifier.getSelectedItem();
        if (((String)obj).compareTo(ResourceManager.getString(this.getClass(), "dialog.JMultiTopicHelperDialog.GroupName")) == 0) {
            nSel = 1;
        } else if (((String)obj).compareTo(ResourceManager.getString(this.getClass(), "dialog.JMultiTopicHelperDialog.RoutingNode")) == 0) {
            nSel = 2;
        }
        return nSel;
    }

    protected void setSelectedQualifier(int nSel) {
        if (nSel == 1) {
            this.m_cbQualifier.setSelectedItem(ResourceManager.getString(this.getClass(), "dialog.JMultiTopicHelperDialog.GroupName"));
        } else if (nSel == 2) {
            this.m_cbQualifier.setSelectedItem(ResourceManager.getString(this.getClass(), "dialog.JMultiTopicHelperDialog.RoutingNode"));
        } else {
            this.m_cbQualifier.setSelectedItem(ResourceManager.getString(this.getClass(), "dialog.JMultiTopicHelperDialog.None"));
        }
    }

    protected void enableFields() {
        int nIndex = this.getSelectedQualifier();
        if (this.m_topicTable != null) {
            this.m_txQualifierName.setEnabled(!this.m_bIsReadOnly && nIndex != 0 && this.m_topicTable.getRowCount() == 0);
            this.m_cbQualifier.setEnabled(!this.m_bIsReadOnly && this.m_topicTable.getRowCount() == 0);
        }
        boolean bEnable = !this.m_bIsReadOnly && (nIndex == 0 || nIndex != 0 && this.m_txQualifierName.getText().length() > 0);
        this.enableFields(bEnable);
    }

    protected void enableFields(boolean bEnable) {
        if (this.m_btnPanel != null) {
            this.m_btnPanel.setEnabled(bEnable);
            this.m_txTopicName.setEnabled(bEnable);
            this.m_topicTable.setEnabled(bEnable);
        }
    }

    private void initTopicTable() {
        IModelTableModel model = (IModelTableModel)this.m_topicTable.getModel();
        try {
            for (progress.message.jimpl.Topic topic : this.m_mt) {
                if (this.m_topicTable.getRowCount() == 0) {
                    if (topic.hasGroup()) {
                        this.setSelectedQualifier(1);
                        this.m_txQualifierName.setText(topic.getGroupName());
                    } else if (topic.hasRouting()) {
                        this.setSelectedQualifier(2);
                        this.m_txQualifierName.setText(topic.getRouting());
                    }
                }
                model.insertRow(topic, this.m_topicTable.getRowCount());
            }
        }
        catch (JMSException jmse) {
            MgmtConsole.displayMessage(this.m_parent, 4, "Could not iterate MultiTopic.", jmse, true);
        }
    }

    private SmartRowTableButtonPanel makeMultiTopicButtons() {
        SmartRowTableButtonPanel panel = new SmartRowTableButtonPanel(this.m_topicTable);
        panel.setAddAction(new AddAction());
        panel.setRemoveAction(new RemoveAction(panel.getRemoveAction()));
        panel.addRemainder();
        JButton btnAdd = panel.getButton(JRowTableButtonPanel.JAddButton.class);
        btnAdd.setDefaultCapable(true);
        panel.updateState(null);
        return panel;
    }

    private JComponent makeMultiTopicTable() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(0, 0));
        TableColumn[] COLUMNS = new TopicRowTableColumn[]{new TopicRowTableColumn(0, ResourceManager.getString(this.getClass(), "panel.topicbuilder.topic.names"), 100)};
        COLUMNS[0].setSortable(false);
        this.m_topicTable = new JRowTable(COLUMNS, this.getClass().getName());
        ExtendedJScrollPane scroller = new ExtendedJScrollPane(this.m_topicTable);
        panel.add((Component)scroller, "Center");
        scroller.setPreferredSize(new Dimension(300, 200));
        JLabel labelNewTopic = new JLabel(ResourceManager.getString(this.getClass(), "panel.topicbuilder.topic.new.label"));
        labelNewTopic.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        if (!this.m_bIsReadOnly) {
            JPanel panelNewTopic = new JPanel();
            panelNewTopic.setLayout(new BorderLayout(0, 0));
            panelNewTopic.add((Component)labelNewTopic, "West");
            this.m_txTopicName = new JTextField();
            panelNewTopic.add((Component)this.m_txTopicName, "Center");
            panelNewTopic.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            panel.add((Component)panelNewTopic, "North");
        }
        return panel;
    }

    class RemoveAction
    extends BasicGuiAction {
        public RemoveAction(Action target) {
            super("editable_component.remove", target);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                IModelTableModel model = (IModelTableModel)JMultiTopicHelperPanel.this.m_topicTable.getModel();
                int sel = JMultiTopicHelperPanel.this.m_topicTable.getSelectedRow();
                progress.message.jclient.Topic topic = (progress.message.jclient.Topic)model.getRowModel(sel);
                int match = model.findCell(0, 0, ((progress.message.jimpl.Topic)topic).getTopicNameOnly());
                if (match != -1) {
                    model.delete(topic);
                    ((ModelListTableModel)model).fireTableRowsDeleted(match, match);
                    JMultiTopicHelperPanel.this.m_mt.remove((Destination)topic);
                    JMultiTopicHelperPanel.this.m_topicTable.getSelectionModel().clearSelection();
                }
            }
            catch (JMSException jmse) {
                MgmtConsole.displayMessage(JMultiTopicHelperPanel.this.m_parent, 3, "Could not remove topic.", jmse, true);
            }
            JMultiTopicHelperPanel.this.enableFields();
        }
    }

    class EditAction
    extends BasicGuiAction {
        public EditAction() {
            super("editable_component.edit");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                String strTopicNewName;
                IModelTableModel model = (IModelTableModel)JMultiTopicHelperPanel.this.m_topicTable.getModel();
                int sel = JMultiTopicHelperPanel.this.m_topicTable.getSelectedRow();
                progress.message.jclient.Topic topic = (progress.message.jclient.Topic)model.getRowModel(sel);
                String strTopicOldName = topic.getName();
                EditTopicNameDialog dialog = new EditTopicNameDialog(JMultiTopicHelperPanel.this.m_parent, strTopicOldName);
                dialog.setVisible(true);
                if (dialog.getCloseCommand() == 0 && (strTopicNewName = dialog.getResult()).length() > 0 && !strTopicOldName.equals(strTopicNewName)) {
                    int match = model.findCell(0, 0, strTopicNewName);
                    if (match != -1 && match != sel) {
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        ((progress.message.jimpl.Topic)topic).setTopicName(strTopicNewName);
                        model.getContents().set(sel, strTopicNewName);
                        ((ModelListTableModel)model).fireTableRowsUpdated(sel, sel);
                    }
                }
            }
            catch (JMSException jmse) {
                MgmtConsole.displayMessage(JMultiTopicHelperPanel.this.m_parent, 3, "Could not edit topic name.", jmse, true);
            }
        }

        class EditTopicNameDialog
        extends JMADialog {
            JTextField m_txTopicName;
            Action m_okAction;
            String m_strTopicName;

            public EditTopicNameDialog(JMADialog parent, String strTopicName) {
                super(parent, "JTopicNameEditorDialog");
                this.m_txTopicName = new JTextField(32);
                this.setResizableProperty();
                this.m_okAction = this.createOKAction();
                this.m_strTopicName = strTopicName;
            }

            private void setResizableProperty() {
                this.setResizable(false);
            }

            private OKAction createOKAction() {
                return new OKAction((Action)this.getDefaultOKAction());
            }

            @Override
            public void maInitialize() {
                this.getContentPane().add(this.makeMainPanel());
                this.m_txTopicName.setText(this.m_strTopicName);
            }

            @Override
            public void maCleanup() {
            }

            private JPanel makeMainPanel() {
                JPanel panel = new JPanel(new GridBagLayout());
                GridBagConstraints gbc = new GridBagConstraints();
                Helper.setConstraints(gbc, 0, 0, 1, 1, 0.0, 0.0, 17, 0);
                panel.add((Component)new JLabel("Topic: "), gbc);
                Helper.setConstraints(gbc, 1, 0, 1, 1, 0.0, 0.0, 17, 2);
                panel.add((Component)this.m_txTopicName, gbc);
                panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                return panel;
            }

            public String getResult() {
                return this.m_txTopicName.getText();
            }

            @Override
            public Action[] getButtonActions() {
                ArrayList<Action> list = new ArrayList<Action>();
                list.add(this.m_okAction);
                list.add(this.getDefaultCancelAction());
                return list.toArray(new Action[list.size()]);
            }

            class OKAction
            extends BasicGuiAction {
                public OKAction(Action target) {
                    super("dialog.ok", target);
                }

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (EditTopicNameDialog.this.getResult().length() == 0) {
                        MgmtConsole.getMgmtConsole().notifyMessage(4, "Topic name can't be empty", true);
                        return;
                    }
                    super.actionPerformed(evt);
                }
            }
        }
    }

    class AddAction
    extends BasicGuiAction {
        public AddAction() {
            super("editable_component.addOnly");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String strNewTopic = JMultiTopicHelperPanel.this.m_txTopicName.getText();
            if (strNewTopic.length() > 0) {
                IModelTableModel model = (IModelTableModel)JMultiTopicHelperPanel.this.m_topicTable.getModel();
                if (model.findCell(0, 0, strNewTopic) == -1) {
                    try {
                        Topic t = DestinationFactory.createTopic((String)strNewTopic);
                        if (t instanceof progress.message.jclient.MultiTopic) {
                            MgmtConsole.displayMessage(JMultiTopicHelperPanel.this.m_parent, 3, "Could not add MultiTopic. Multitopic-based topics are not supported in the Topic Builder.", null, true);
                            return;
                        }
                        if (JMultiTopicHelperPanel.this.getSelectedQualifier() == 1 && !((progress.message.jimpl.Topic)t).hasGroup()) {
                            ((progress.message.jimpl.Topic)t).initGroupName(JMultiTopicHelperPanel.this.m_txQualifierName.getText());
                        } else if (JMultiTopicHelperPanel.this.getSelectedQualifier() == 2 && !((progress.message.jimpl.Topic)t).hasRouting()) {
                            ((progress.message.jimpl.Topic)t).initRouting(JMultiTopicHelperPanel.this.m_txQualifierName.getText());
                        }
                        String s = t.getTopicName();
                        JMultiTopicHelperPanel.this.m_mt.add((Destination)t);
                        model.insertRow(t, JMultiTopicHelperPanel.this.m_topicTable.getRowCount());
                        int found = model.findCell(0, 0, strNewTopic);
                        if (found != -1) {
                            JMultiTopicHelperPanel.this.m_topicTable.getSelectionModel().setSelectionInterval(found, found);
                        }
                    }
                    catch (JMSException jmse) {
                        MgmtConsole.displayMessage(JMultiTopicHelperPanel.this.m_parent, 3, "Could not add Topic to MultiTopic. Topic name failed validation.", jmse, true);
                        return;
                    }
                }
                JMultiTopicHelperPanel.this.m_txTopicName.setText("");
            }
            JMultiTopicHelperPanel.this.enableFields();
        }
    }

    class SmartRowTableButtonPanel
    extends JRowTableButtonPanel {
        public SmartRowTableButtonPanel(JRowTable table) {
            super(table, true);
        }

        public SmartRowTableButtonPanel(JRowTable table, boolean autoEdit) {
            super(table, autoEdit, 5, 0, 0);
        }

        public SmartRowTableButtonPanel(JRowTable table, int gapSize, int tbEdgeGap, int lrEdgeGap) {
            super(table, true, gapSize, tbEdgeGap, lrEdgeGap);
        }

        public SmartRowTableButtonPanel(JRowTable table, boolean autoEdit, int gapSize, int tbEdgeGap, int lrEdgeGap) {
            super(table, autoEdit, gapSize, tbEdgeGap, lrEdgeGap);
        }

        @Override
        public void setEnabled(boolean bEnable) {
            super.setEnabled(bEnable);
            this.getTable().setEnabled(bEnable);
            if (bEnable) {
                this.updateState(this.getTable().getSelectionModel());
            } else {
                if (this.getAddAction() != null) {
                    this.getAddAction().setEnabled(false);
                }
                if (this.getEditAction() != null) {
                    this.getEditAction().setEnabled(false);
                }
                if (this.getRemoveAction() != null) {
                    this.getRemoveAction().setEnabled(false);
                }
            }
        }

        @Override
        protected void updateState(ListSelectionModel selModel) {
            if (this.isEnabled()) {
                super.updateState(selModel);
            }
        }
    }

    class TopicRowTableColumn
    extends RowTableColumn {
        public TopicRowTableColumn(int modelIndex, String headerLabel) {
            super(modelIndex, headerLabel);
        }

        public TopicRowTableColumn(int modelIndex, String headerLabel, int width) {
            super(modelIndex, headerLabel, width);
        }

        public TopicRowTableColumn(int modelIndex, String headerLabel, int width, TableCellRenderer cellRenderer) {
            super(modelIndex, headerLabel, width, cellRenderer);
        }

        public TopicRowTableColumn(int modelIndex, String headerLabel, int width, TableCellRenderer cellRenderer, TableCellEditor cellEditor) {
            super(modelIndex, headerLabel, width, cellRenderer, cellEditor);
        }

        @Override
        public Object getColumnValue(Object rowModel) {
            String objTopicName = ((progress.message.jimpl.Topic)rowModel).getTopicNameOnly();
            return objTopicName;
        }
    }
}

