/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import java.awt.Component;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import modelobjects.layout.PartitionLayout;

public class JPartitionPanel
extends JPanel {
    private static final boolean DEFAULT_VERTICAL_LAYOUT = false;
    private static final String DEFAULT_ENCODED_LAYOUT = "p,r,p";
    public static final int DEFAULT_GAP_SIZE = 5;
    public static final int DEFAULT_TB_EDGE_GAP = 5;
    public static final int DEFAULT_LR_EDGE_GAP = 5;
    public static final int BORDER_SIZE = new JSplitPane().getWidth();
    public static final Insets BORDER_INSETS = new Insets(BORDER_SIZE, BORDER_SIZE, BORDER_SIZE, BORDER_SIZE);

    public JPartitionPanel() {
        this((String)null);
    }

    public JPartitionPanel(String borderTitle) {
        this(false, DEFAULT_ENCODED_LAYOUT, borderTitle);
    }

    public JPartitionPanel(boolean verticalLayout, String borderTitle) {
        this(verticalLayout, DEFAULT_ENCODED_LAYOUT, borderTitle);
    }

    public JPartitionPanel(boolean verticalLayout, String encodedLayout, String borderTitle) {
        this(verticalLayout, encodedLayout, borderTitle, 5, 5, 5);
    }

    public JPartitionPanel(boolean verticalLayout, String encodedLayout, String borderTitle, int gapSize) {
        this(verticalLayout, encodedLayout, borderTitle, gapSize, gapSize, gapSize);
    }

    public JPartitionPanel(boolean verticalLayout, String encodedLayout, String borderTitle, int sepGap, int tbEdgeGap, int lrEdgeGap) {
        super(new PartitionLayout(verticalLayout, encodedLayout, sepGap, tbEdgeGap, lrEdgeGap, null));
        if (borderTitle != null) {
            this.setBorder(borderTitle);
        }
    }

    private void setBorder(String borderTitle) {
        this.setBorder(BorderFactory.createTitledBorder(borderTitle));
    }

    public JComponent addRow(JComponent field) {
        return this.addRow((JLabel)null, new JComponent[]{field})[0];
    }

    public JComponent addRow(JLabel label, JComponent field) {
        return this.addRow(label, new JComponent[]{field})[0];
    }

    public JComponent addRow(String labelName, JComponent field) {
        return this.addRow(labelName, field, null);
    }

    public JComponent addRow(String labelName, JComponent field, String unitName) {
        return this.addRow(labelName, new JComponent[]{field, new JLabel(unitName)})[0];
    }

    public JComponent addRow(JLabel label, JComponent field, String unitName) {
        return this.addRow(label, new JComponent[]{field, new JLabel(unitName)})[0];
    }

    public JComponent[] addRow(String labelName, JComponent[] field) {
        return this.addRow(new JLabel(labelName != null ? labelName + ":" : ""), field);
    }

    public JComponent[] addRow(JLabel label, JComponent[] field) {
        JComponent[] list = new JComponent[field.length + 1];
        list[0] = label != null ? label : new JLabel();
        for (int i = 1; i < list.length; ++i) {
            list[i] = field[i - 1];
        }
        return this.addRow(list);
    }

    public JComponent[] addRow(JComponent[] field) {
        if (!(this.getLayout() instanceof PartitionLayout)) {
            return new JComponent[0];
        }
        boolean hasSP = this.containsScrollPane(field);
        int i = 0;
        for (int numCompInRow = ((PartitionLayout)this.getLayout()).getNumPartitions(); numCompInRow > 0; --numCompInRow) {
            if (field != null && i < field.length) {
                if (hasSP && !(field[i] instanceof JScrollPane)) {
                    this.add(this.internalWrap(field[i++]));
                    continue;
                }
                this.add(field[i++]);
                continue;
            }
            this.add(new JPanel());
        }
        return field;
    }

    private boolean containsScrollPane(JComponent[] c) {
        for (int i = 0; i < c.length; ++i) {
            if (!(c[i] instanceof JScrollPane)) continue;
            return true;
        }
        return false;
    }

    private JPanel internalWrap(JComponent c) {
        JPanel panel = new JPanel(new PartitionLayout(true, "p", 0, 0, 0, null));
        panel.add(c);
        return panel;
    }

    public Border getPreferredBorder() {
        Border outer = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        Border inner = BorderFactory.createBevelBorder(0, this.getBackground(), null, this.getBackground(), null);
        return BorderFactory.createCompoundBorder(outer, inner);
    }

    public static final JPartitionPanel wrap(JComponent component) {
        JPartitionPanel panel = new JPartitionPanel(true, "p", null);
        panel.add(component);
        return panel;
    }

    public static final JPartitionPanel wrap(JPanel component) {
        return JPartitionPanel.wrap((JComponent)component);
    }

    public static final JPartitionPanel merge(String partition, boolean vertical, Component[] component) {
        JPartitionPanel panel = new JPartitionPanel(vertical, partition, null);
        for (int i = 0; i < component.length; ++i) {
            if (component[i] == null) {
                panel.add(new JPanel());
                continue;
            }
            panel.add(component[i]);
        }
        return panel;
    }

    public static final JPartitionPanel merge(String partition, boolean vertical, int sepGap, int tbEdgeGap, int lrEdgeGap, Component[] component) {
        JPartitionPanel panel = new JPartitionPanel(vertical, partition, null, sepGap, tbEdgeGap, lrEdgeGap);
        for (int i = 0; i < component.length; ++i) {
            if (component[i] == null) {
                panel.add(new JPanel());
                continue;
            }
            panel.add(component[i]);
        }
        return panel;
    }
}

