/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPasswordDialog;
import com.sonicsw.ma.gui.util.PasswordHash;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import modelobjects.framework.EditRule;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.ViewAspectAdapter;
import modelobjects.framework.ViewValueConverter;
import modelobjects.framework.model.ModelAspectId;

public class JPasswordButtonViewAspectAdapter
extends ViewAspectAdapter
implements ActionListener {
    public static final String RES_ACTION = "password.default";
    private Object m_password;
    private JButton m_viewComponent;
    private boolean m_hashed;
    private boolean m_useDefault;
    private final BasicAction m_defAction = new PasswordAction();

    public JPasswordButtonViewAspectAdapter(ModelAspectId modelAspectId, JButton viewComponent, EditRule editRule, ViewValueConverter viewValueConverter, ModelEditMediator modelEditMediator, boolean hashed) {
        this(modelAspectId, viewComponent, editRule, viewValueConverter, modelEditMediator, hashed, true);
    }

    public JPasswordButtonViewAspectAdapter(ModelAspectId modelAspectId, JButton viewComponent, EditRule editRule, ViewValueConverter viewValueConverter, ModelEditMediator modelEditMediator, boolean hashed, boolean useDefaultPassword) {
        super(modelAspectId, editRule, viewValueConverter, modelEditMediator);
        this.setViewComponent(viewComponent);
        this.m_useDefault = useDefaultPassword;
        this.m_hashed = hashed;
    }

    private void setViewComponent(JButton viewComponent) {
        if (this.m_viewComponent != null) {
            this.m_viewComponent.removeActionListener(this);
        }
        this.m_viewComponent = viewComponent;
        if (this.m_viewComponent.getAction() == null) {
            this.m_viewComponent.setAction(this.getDefaultAction());
        } else {
            Action old = this.m_viewComponent.getAction();
            if (old instanceof BasicAction) {
                ((BasicAction)old).setTargetAction(this.getDefaultAction());
            }
        }
        this.m_viewComponent.addActionListener(this);
    }

    @Override
    public Component getViewComponent() {
        return this.m_viewComponent;
    }

    public boolean isHashed() {
        return this.m_hashed;
    }

    public BasicAction getDefaultAction() {
        return this.m_defAction;
    }

    @Override
    public boolean isEditable() {
        return this.m_viewComponent.isEnabled();
    }

    @Override
    public void setEditable(boolean editable) {
        if (editable != this.m_viewComponent.isEnabled()) {
            this.m_viewComponent.setEnabled(editable);
        }
    }

    @Override
    public Object getViewAspectValue() {
        Object res = null;
        if (this.m_password != null) {
            res = this.m_password;
        } else if (this.m_useDefault) {
            res = this.getDefaultPassword();
        }
        return res;
    }

    @Override
    public String getViewAspectStringValue() {
        return this.getViewAspectValue().toString();
    }

    @Override
    protected void setViewAspectValue(Object viewAspectValue) throws IllegalArgumentException {
        if (viewAspectValue != null) {
            if (this.isHashed()) {
                if (viewAspectValue instanceof byte[]) {
                    this.m_password = viewAspectValue;
                }
            } else if (viewAspectValue instanceof String) {
                this.m_password = viewAspectValue;
            } else {
                throw new IllegalArgumentException(this.getModelAspectId().getName() + " : invalid password format - expecting byte[], got " + viewAspectValue.getClass().getName());
            }
        }
    }

    public void setPasswordValue(Object value) throws IllegalArgumentException {
        this.setViewAspectValue(value);
        this.fireChangeEvent();
    }

    @Override
    protected void setViewAspectStringValue(String viewStringValue) throws IllegalArgumentException {
        if (this.isHashed()) {
            throw new IllegalArgumentException(this.getModelAspectId().getName() + " : can't take hashed password as a string - insecure!");
        }
        this.m_password = viewStringValue;
    }

    private Object getDefaultPassword() {
        byte[] res = null;
        if (this.isHashed()) {
            try {
                res = PasswordHash.doSHA(new String(""));
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(4, "Error getting password.", e, true);
            }
        }
        return res;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
    }

    class PasswordAction
    extends BasicGuiAction {
        public PasswordAction() {
            super(JPasswordButtonViewAspectAdapter.RES_ACTION);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JPasswordDialog dialog = null;
            JMADialog pDialog = (JMADialog)SwingUtilities.getAncestorOfClass(JMADialog.class, JPasswordButtonViewAspectAdapter.this.getViewComponent());
            if (pDialog != null) {
                dialog = new JPasswordDialog(pDialog);
            } else {
                JMAFrame pFrame = (JMAFrame)SwingUtilities.getAncestorOfClass(JMADialog.class, JPasswordButtonViewAspectAdapter.this.getViewComponent());
                if (pFrame != null) {
                    dialog = new JPasswordDialog(pFrame);
                }
            }
            if (dialog != null) {
                dialog.setVisible(true);
                if (dialog.getCloseCommand() == 0) {
                    JPasswordButtonViewAspectAdapter.this.m_password = JPasswordButtonViewAspectAdapter.this.isHashed() ? dialog.getHashedPassword() : (byte[])dialog.getPassword();
                    JPasswordButtonViewAspectAdapter.this.fireChangeEvent();
                }
                dialog.dispose();
            }
        }
    }
}

