/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.PasswordHash;
import com.sonicsw.ma.gui.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;

public class JPasswordDialog
extends JMADialog {
    protected JPasswordField passwordField;
    protected JPasswordField confirmField;
    private JPanel m_contentPanel;

    public JPasswordDialog(JMAFrame parent) {
        super(parent, "JPasswordDialog");
        this.setResizableProperty();
    }

    public JPasswordDialog(JMADialog parent) {
        super(parent, "JPasswordDialog");
        this.setResizableProperty();
    }

    private void setResizableProperty() {
        this.setResizable(false);
    }

    @Override
    public Container getContentPane() {
        return this.m_contentPanel;
    }

    @Override
    protected void internalInitialize() {
        super.internalInitialize();
        this.m_contentPanel = new JPanel(new BorderLayout(2, 2));
        super.getContentPane().add(this.m_contentPanel);
    }

    @Override
    protected void maInitialize() {
        JPartitionPanel topPanel = new JPartitionPanel(true, "p", null);
        this.getContentPane().add((Component)topPanel, "Center");
        JPartitionPanel loginPanel = new JPartitionPanel(false, "p,r", "", 5, 0, 0);
        topPanel.add(loginPanel);
        this.passwordField = new JPasswordField(16);
        loginPanel.addRow(ResourceManager.getString(this.getClass(), "dialog.JPasswordDialog.Password"), (JComponent)this.passwordField);
        this.confirmField = new JPasswordField(16);
        loginPanel.addRow(ResourceManager.getString(this.getClass(), "dialog.JPasswordDialog.ConfirmPassword"), (JComponent)this.confirmField);
    }

    @Override
    public Action[] getButtonActions() {
        Action[] OVERRIDDEN_BUTTON_ACTIONS = new Action[]{new OkButtonAction("dialog.ok", this), new CancelButtonAction("dialog.cancel")};
        return OVERRIDDEN_BUTTON_ACTIONS;
    }

    public byte[] getHashedPassword() {
        byte[] bytes = null;
        try {
            String password = this.getPassword();
            if (password != null && password.length() > 0) {
                bytes = PasswordHash.doSHA(password);
            }
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(4, "Error while getting password.", e, true);
        }
        return bytes;
    }

    public String getPassword() {
        if (this.passwordField.getPassword() == null) {
            return null;
        }
        return new String(this.passwordField.getPassword());
    }

    public void setPassword(String value) {
        this.passwordField.setText(value);
    }

    public char[] getPasswordChars() {
        if (this.passwordField.getPassword() == null) {
            return null;
        }
        return this.passwordField.getPassword();
    }

    public void setPasswordChars(char[] chars) {
        if (chars == null) {
            this.passwordField.setText(null);
        } else {
            this.passwordField.setText(new String(chars));
        }
    }

    public byte[] getPasswordBytes() {
        if (this.passwordField.getPassword() == null) {
            return null;
        }
        String password = new String(this.passwordField.getPassword());
        return password.getBytes();
    }

    public void setPasswordBytes(byte[] bytes) {
        if (bytes == null) {
            this.passwordField.setText(null);
        } else {
            this.passwordField.setText(new String(bytes));
        }
    }

    public String getConfirmPassword() {
        if (this.confirmField.getPassword() == null) {
            return null;
        }
        return new String(this.confirmField.getPassword());
    }

    public boolean validatePassword(String password, String confirmPassword) {
        boolean valid = false;
        if (password != null && confirmPassword != null && password.equals(confirmPassword)) {
            valid = true;
        }
        return valid;
    }

    @Override
    protected void maCleanup() {
    }

    protected class CancelButtonAction
    extends BasicGuiAction {
        public CancelButtonAction(String resourceId) {
            super(resourceId);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            super.actionPerformed(evt);
            Component source = (Component)evt.getSource();
            JPasswordDialog dialog = (JPasswordDialog)SwingUtilities.getAncestorOfClass(JDialog.class, source);
            dialog.m_closeCommand = -1;
            dialog.setVisible(false);
        }
    }

    protected class OkButtonAction
    extends BasicGuiAction {
        protected Component m_parent;

        public OkButtonAction(String resourceId, Component parent) {
            super(resourceId);
            this.m_parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            super.actionPerformed(evt);
            Component source = (Component)evt.getSource();
            JPasswordDialog dialog = (JPasswordDialog)SwingUtilities.getAncestorOfClass(JDialog.class, source);
            if (!dialog.validatePassword(dialog.getPassword(), dialog.getConfirmPassword())) {
                JOptionPane.showMessageDialog(this.m_parent, ResourceManager.getString(this.getClass(), "dialog.JPasswordDialog.ValidateError"), ResourceManager.getString(this.getClass(), "dialog.JPasswordDialog.title"), 0);
            } else {
                dialog.m_closeCommand = 0;
                dialog.setVisible(false);
            }
        }
    }
}

