/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.Helper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import modelobjects.layout.PartitionLayout;

public class JPathChooser
extends JComponent
implements ListSelectionListener,
KeyListener,
ItemListener {
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    public static final int ERROR_OPTION = -1;
    private static final int MODE_NOP = 0;
    private static final int MODE_EDIT = 1;
    private static final int MODE_NEW = 2;
    private static int PREF_WIDTH = 500;
    private static int PREF_HEIGHT = 326;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    private static int MIN_WIDTH = 500;
    private static int MIN_HEIGHT = 326;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    DefaultListModel pathModel;
    JDialog dialog = null;
    JList pathList;
    JLabel lblField;
    JComponent field;
    JButton btnOk;
    JButton btnCancel;
    JButton btnNew;
    JButton btnDelete;
    JButton btnApply;
    int returnValue;
    int mode = 0;
    boolean fieldChanged = false;
    boolean formChanged = false;
    boolean selChanged = false;
    String[] oldPath;
    String[] choices = new String[0];
    boolean pathEditable = true;
    JButton btnMoveUp;
    JButton btnMoveDown;
    Action applyAction;
    boolean m_readOnly = false;

    public JPathChooser() {
        this.pathModel = new DefaultListModel();
        this.prepareJPathChooser();
    }

    private void prepareJPathChooser() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createMainPanel(), "Center");
        this.add((Component)this.createButtonPanel(), "South");
        this.add((Component)this.createTableButtonPanel(), "East");
        this.applyAction = new ApplyAction();
        this.btnApply.setAction(this.applyAction);
        this.setPathChoices(null);
        this.formUpdate();
    }

    private JPanel createMainPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new PartitionLayout(true, "r,p", 5, 2, 2, "JPathChooserMainPanel"));
        this.pathList = new JList(this.pathModel);
        this.pathList.addListSelectionListener(this);
        panel.add(new ExtendedJScrollPane(this.pathList));
        panel.add(this.createEditPanel());
        return panel;
    }

    private JPanel createEditPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new PartitionLayout(false, "p,r", 5, 2, 2, "JPathChooserEditPanel"));
        this.lblField = new JLabel("Path: ");
        this.field = new JTextField();
        panel.add(this.lblField);
        panel.add(this.field);
        return panel;
    }

    public int showDialog(Component parent) throws HeadlessException {
        this.dialog = this.createDialog(parent);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JPathChooser.this.returnValue = 1;
            }
        });
        this.returnValue = -1;
        this.dialog.show();
        this.dialog.dispose();
        this.dialog = null;
        return this.returnValue;
    }

    protected JDialog createDialog(Component parent) throws HeadlessException {
        Frame frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        JDialog dialog = new JDialog(frame, "Path Chooser", true);
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this, "Center");
        this.setPreferredSize(PREF_SIZE);
        this.setMinimumSize(MIN_SIZE);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        return dialog;
    }

    public void setPathChoices(String[] path) {
        this.choices = path != null ? path : new String[]{};
        JComponent theField = (JComponent)Helper.getDescendentClass(JTextField.class, this);
        Container parent = theField.getParent();
        if (path == null || path.length == 0) {
            if (this.field instanceof JComboBox) {
                parent.remove(this.field);
                ((JComboBox)this.field).removeItemListener(this);
                ((JComboBox)this.field).getEditor().getEditorComponent().removeKeyListener(this);
                this.field = new JTextField();
                ((JTextField)this.field).addKeyListener(this);
                ((JTextField)this.field).setAction(this.applyAction);
                parent.add(this.field);
                this.formUpdate();
            }
        } else if (this.field instanceof JTextField) {
            parent.remove(this.field);
            this.field.removeKeyListener(this);
            this.field = new JNoActionComboBox(this.choices);
            ((JComboBox)this.field).setSelectedItem(null);
            ((JComboBox)this.field).addItemListener(this);
            ((JComboBox)this.field).getEditor().getEditorComponent().addKeyListener(this);
            ((JComboBox)this.field).setAction(this.applyAction);
            parent.add(this.field);
            this.formUpdate();
        }
    }

    public String[] getPathChoices() {
        return this.choices;
    }

    public void setSelectedPaths(String[] path) {
        this.oldPath = path;
        for (int i = 0; i < path.length; ++i) {
            String aPath = path[i].trim();
            if (aPath.length() <= 0) continue;
            this.pathModel.addElement(aPath);
        }
    }

    public String[] getSelectedPaths() {
        String[] res = new String[this.pathModel.getSize()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (String)this.pathModel.getElementAt(i);
        }
        return res;
    }

    public void setPathEditable(boolean editable) {
        this.pathEditable = editable;
        if (this.field instanceof JComboBox) {
            ((JComboBox)this.field).setEditable(this.pathEditable);
        }
    }

    public boolean isPathEditable() {
        return this.pathEditable;
    }

    public void setReadOnly(boolean readOnly) {
        this.m_readOnly = readOnly;
        this.formUpdate();
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new PartitionLayout(false, "r,p,p,r", 5, 2, 2, "JPathChooserButonPanel"));
        this.btnOk = new JButton("OK");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPathChooser.this.dialog.setVisible(false);
                JPathChooser.this.returnValue = 0;
            }
        });
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPathChooser.this.dialog.setVisible(false);
                JPathChooser.this.returnValue = 1;
            }
        });
        panel.add(new JPanel());
        panel.add(this.btnOk);
        panel.add(this.btnCancel);
        panel.add(new JPanel());
        return panel;
    }

    private JPanel createTableButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new PartitionLayout(true, "p,p,p,r", 5, 2, 2, "JPathChooserTableButonPanel"));
        this.btnNew = new JButton(new NewAction());
        this.btnDelete = new JButton(new DeleteAction());
        this.btnApply = new JButton();
        panel.add(this.btnNew);
        panel.add(this.btnDelete);
        panel.add(this.btnApply);
        return panel;
    }

    protected void formUpdate() {
        DefaultListModel model = (DefaultListModel)this.pathList.getModel();
        int selIndex = this.pathList.getSelectedIndex();
        boolean oneSel = this.pathList.getSelectedIndices().length == 1;
        boolean sel = oneSel && selIndex >= 0 && selIndex < model.size();
        this.btnNew.setEnabled(!this.isReadOnly() && !this.fieldChanged && this.mode != 2);
        this.btnDelete.setEnabled(!this.isReadOnly() && this.mode != 2 && this.pathList.getSelectedIndices().length > 0);
        this.btnApply.setEnabled(!this.isReadOnly() && this.fieldChanged && (this.mode == 2 || this.mode == 1));
        this.field.setEnabled(!this.isReadOnly() && this.mode != 0);
        this.btnOk.setEnabled(this.formChanged);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        this.fieldChanged = false;
        this.mode = this.pathList.getSelectedIndices().length > 0 ? 1 : 0;
        Helper.invoke(new Runnable(){

            @Override
            public void run() {
                String value;
                DefaultListModel model = (DefaultListModel)JPathChooser.this.pathList.getModel();
                int selIndex = JPathChooser.this.pathList.getSelectedIndex();
                boolean oneSel = JPathChooser.this.pathList.getSelectedIndices().length == 1;
                boolean sel = oneSel && selIndex >= 0 && selIndex < model.size();
                String string = value = sel ? (String)model.getElementAt(selIndex) : null;
                if (JPathChooser.this.field instanceof JTextField) {
                    ((JTextField)JPathChooser.this.field).setText(value);
                } else {
                    ((JComboBox)JPathChooser.this.field).setSelectedItem(value);
                }
                JPathChooser.this.formUpdate();
            }
        });
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.fieldChanged = true;
        }
        Helper.invoke(new Runnable(){

            @Override
            public void run() {
                JPathChooser.this.formUpdate();
            }
        });
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == '\n') {
            return;
        }
        this.fieldChanged = true;
        Helper.invoke(new Runnable(){

            @Override
            public void run() {
                JPathChooser.this.formUpdate();
            }
        });
    }

    @Override
    public void keyPressed(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    class JNoActionComboBox
    extends JComboBox {
        public JNoActionComboBox(Object[] values) {
            super(values);
        }

        @Override
        public void setSelectedItem(Object value) {
            JPathChooser.this.selChanged = true;
            super.setSelectedItem(value);
        }
    }

    class ApplyAction
    extends BasicGuiAction {
        public ApplyAction() {
            super("JPathChooser.apply");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String path;
            if (evt.getSource().getClass().equals(JNoActionComboBox.class) && JPathChooser.this.selChanged) {
                JPathChooser.this.selChanged = false;
                return;
            }
            String string = path = JPathChooser.this.field instanceof JTextField ? ((JTextField)JPathChooser.this.field).getText() : (String)((JComboBox)JPathChooser.this.field).getSelectedItem();
            if (path == null || path.length() == 0) {
                return;
            }
            path = path.trim();
            DefaultListModel model = (DefaultListModel)JPathChooser.this.pathList.getModel();
            if (JPathChooser.this.mode == 2) {
                if (model.indexOf(path) == -1) {
                    model.addElement(path);
                }
                JPathChooser.this.pathList.setSelectedIndex(model.indexOf(path));
                JPathChooser.this.mode = 1;
            } else if (JPathChooser.this.mode == 1) {
                model.setElementAt(path, JPathChooser.this.pathList.getSelectedIndex());
            }
            JPathChooser.this.fieldChanged = false;
            JPathChooser.this.formChanged = true;
            Helper.invoke(new Runnable(){

                @Override
                public void run() {
                    JPathChooser.this.formUpdate();
                }
            });
        }
    }

    class DeleteAction
    extends BasicGuiAction {
        public DeleteAction() {
            super("JPathChooser.delete");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            DefaultListModel model = (DefaultListModel)JPathChooser.this.pathList.getModel();
            int[] index = JPathChooser.this.pathList.getSelectedIndices();
            for (int i = index.length - 1; i >= 0; --i) {
                model.remove(index[i]);
            }
            int newIndex = Math.max(index[index.length - 1] - 1, model.getSize() - 1);
            JPathChooser.this.pathList.setSelectedIndex(newIndex);
            JPathChooser.this.mode = newIndex >= 0 ? 1 : 0;
            JPathChooser.this.formChanged = true;
            JPathChooser.this.fieldChanged = false;
            Helper.invoke(new Runnable(){

                @Override
                public void run() {
                    JPathChooser.this.formUpdate();
                }
            });
        }
    }

    class NewAction
    extends BasicGuiAction {
        public NewAction() {
            super("JPathChooser.new");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JPathChooser.this.mode = 2;
            Helper.invoke(new Runnable(){

                @Override
                public void run() {
                    JPathChooser.this.formUpdate();
                    JPathChooser.this.field.requestFocus();
                }
            });
        }
    }
}

